/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.hl7.util.HL7Archetypes;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.component.workspace.BrowserCRUDWindowTab;
import org.openvpms.web.component.workspace.DefaultCRUDWindow;
import org.openvpms.web.component.workspace.TabComponent;
import org.openvpms.web.component.workspace.TabbedWorkspace;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.tabpane.ObjectTabPaneModel;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.hl7.HL7ConnectorBrowser;
import org.openvpms.web.workspace.admin.hl7.HL7ConnectorCRUDWindow;
import org.openvpms.web.workspace.admin.hl7.HL7MappingCRUDWindow;

public class HL7Workspace
extends TabbedWorkspace<IMObject> {
    public HL7Workspace(Context context) {
        super("admin.hl7", context);
    }

    protected Class<IMObject> getType() {
        return IMObject.class;
    }

    protected void addTabs(ObjectTabPaneModel<TabComponent> model) {
        this.addServiceBrowser(model);
        this.addConnectorBrowser(model);
        this.addMappingBrowser(model);
    }

    private void addServiceBrowser(ObjectTabPaneModel<TabComponent> model) {
        Context context = this.getContext();
        HelpContext help = this.subtopic("service");
        String[] archetypes = new String[]{"entity.HL7Service*", "entity.laboratoryTestHL7"};
        Query query = QueryFactory.create((String[])archetypes, (Context)context);
        Browser browser = BrowserFactory.create((Query)query, (LayoutContext)new DefaultLayoutContext(context, help));
        DefaultCRUDWindow window = new DefaultCRUDWindow(Archetypes.create((String[])archetypes, IMObject.class, (String)Messages.get((String)"admin.hl7.service.type")), context, help);
        this.addTab("admin.hl7.services", model, (TabComponent)new BrowserCRUDWindowTab(browser, (AbstractCRUDWindow)window));
    }

    private void addConnectorBrowser(ObjectTabPaneModel<TabComponent> model) {
        Context context = this.getContext();
        HelpContext help = this.subtopic("connector");
        Query query = QueryFactory.create((String[])HL7Archetypes.CONNECTORS, (Context)context);
        HL7ConnectorBrowser browser = new HL7ConnectorBrowser((Query<Entity>)query, (LayoutContext)new DefaultLayoutContext(context, help));
        Archetypes archetypes = Archetypes.create((String[])HL7Archetypes.CONNECTORS, Entity.class, (String)Messages.get((String)"admin.hl7.connector.type"));
        HL7ConnectorCRUDWindow window = new HL7ConnectorCRUDWindow((Archetypes<Entity>)archetypes, this.getContext(), help);
        this.addTab("admin.hl7.connectors", model, (TabComponent)new BrowserCRUDWindowTab((Browser)browser, (AbstractCRUDWindow)window));
    }

    private void addMappingBrowser(ObjectTabPaneModel<TabComponent> model) {
        Context context = this.getContext();
        HelpContext help = this.subtopic("mapping");
        Query query = QueryFactory.create((String)"entity.HL7Mapping*", (Context)context);
        Browser browser = BrowserFactory.create((Query)query, (LayoutContext)new DefaultLayoutContext(context, help));
        Archetypes archetypes = Archetypes.create((String)"entity.HL7Mapping*", Entity.class, (String)Messages.get((String)"admin.hl7.mapping.type"));
        HL7MappingCRUDWindow window = new HL7MappingCRUDWindow((Archetypes<Entity>)archetypes, context, help);
        this.addTab("admin.hl7.mappings", model, (TabComponent)new BrowserCRUDWindowTab(browser, (AbstractCRUDWindow)window));
    }
}

