/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.hl7.io.HL7DocumentHandler;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.system.ServiceHelper;

public class HL7MessageLayoutStrategy
extends AbstractLayoutStrategy {
    private static final ArchetypeNodes NODES = new ArchetypeNodes().exclude(new String[]{"document", "error"});

    public HL7MessageLayoutStrategy() {
        super(NODES);
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Property error = properties.get("error");
        if (error.getString() != null) {
            this.addComponent(this.createComponent(error, parent, context));
        }
        this.addComponent(this.getMessage(object, properties));
        return super.apply(object, properties, parent, context);
    }

    protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        ComponentGrid grid = this.createGrid(object, properties, context);
        this.addAuditInfo(object, grid, context);
        ComponentState error = this.getComponent("error");
        if (error != null) {
            grid.add(error, 2);
        }
        grid.add(this.getComponent("document"), 2);
        Grid component = this.createGrid(grid);
        container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{component}));
    }

    private ComponentState getMessage(IMObject object, PropertySet properties) {
        DocumentAct act = (DocumentAct)object;
        Document document = (Document)IMObjectHelper.getObject((Reference)act.getDocument());
        String content = null;
        if (document != null) {
            HL7DocumentHandler handler = new HL7DocumentHandler((IArchetypeService)ServiceHelper.getArchetypeService());
            content = handler.toString(document);
        }
        TextArea text = TextComponentFactory.createTextArea();
        text.setStyleName("monospace");
        text.setWidth(Styles.FULL_WIDTH);
        text.setHeight(new Extent(20, 64));
        text.setText(content);
        text.setEnabled(false);
        return new ComponentState((Component)text, properties.get("document"));
    }
}

