/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.esci;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SplitPane;
import org.openvpms.esci.adapter.dispatcher.Inbox;
import org.openvpms.esci.ubl.common.aggregate.DocumentReferenceType;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractTableBrowser;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.esci.DocumentReference;
import org.openvpms.web.workspace.admin.esci.ESCIDocumentTableModel;

class ESCIDocumentBrowser
extends AbstractTableBrowser<DocumentReference> {
    private final Inbox inbox;
    private final Row message;

    public ESCIDocumentBrowser(Inbox inbox, LayoutContext context) {
        super((IMTableModel)new ESCIDocumentTableModel(), context);
        this.inbox = inbox;
        Label label = LabelFactory.text((String)Messages.format((String)"admin.esci.inbox.message", (Object[])new Object[]{inbox.getSupplier().getName(), inbox.getStockLocation().getName()}));
        this.message = RowFactory.create((String)"Inset", (Component[])new Component[]{label});
    }

    public void query() {
        Component component = this.getComponent();
        ResultSet<DocumentReference> set = this.getResultSet();
        boolean hasResults = this.hasResults(set);
        this.doLayout(component, hasResults);
        PagedIMTable table = this.getTable();
        table.setResultSet(set);
        this.setFocusOnResults();
    }

    public boolean isFirstDocumentSelected() {
        List objects;
        boolean result = false;
        DocumentReference selected = (DocumentReference)this.getSelected();
        PagedIMTable table = this.getTable();
        if (selected != null && table != null && table.getPage() == 0 && (objects = table.getTable().getObjects()).size() > 0 && ((DocumentReference)objects.get(0)).equals(selected)) {
            result = true;
        }
        return result;
    }

    protected void doLayout() {
        super.doLayout();
        SplitPane container = (SplitPane)this.getComponent();
        int height = StyleSheetHelper.getProperty((String)"font.size", (int)-1);
        if (height > 0) {
            container.setSeparatorPosition(new Extent(height * 2));
        }
    }

    protected void doLayout(Component container) {
        container.add((Component)this.message);
    }

    private ResultSet<DocumentReference> getResultSet() {
        ArrayList<DocumentReference> result = new ArrayList<DocumentReference>();
        List documents = this.inbox.getDocuments();
        for (DocumentReferenceType reference : documents) {
            result.add(new DocumentReference(reference));
        }
        return new ListResultSet(result, 8);
    }
}

