/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.eftpos;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import org.openvpms.eftpos.service.ManagedTerminalRegistrar;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.im.edit.DefaultEditableComponentFactory;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.InformationDialogBuilder;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedTerminalRegistrationDialog
extends ModalDialog {
    private final ManagedTerminalRegistrar registrar;
    private final List<Property> properties = new ArrayList<Property>();
    private static final Logger log = LoggerFactory.getLogger(ManagedTerminalRegistrationDialog.class);

    public ManagedTerminalRegistrationDialog(ManagedTerminalRegistrar registrar, HelpContext help) {
        super(Messages.get((String)"admin.eftpos.register.title"), OK_CANCEL, help);
        this.registrar = registrar;
        Column column = ColumnFactory.create((String)"WideCellSpacing");
        String message = registrar.getMessage();
        if (message != null) {
            column.add((Component)LabelFactory.text((String)message));
        }
        FocusGroup group = this.getFocusGroup();
        ComponentGrid grid = new ComponentGrid();
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)new LocalContext(), help);
        DefaultEditableComponentFactory factory = new DefaultEditableComponentFactory((LayoutContext)layoutContext);
        for (final ManagedTerminalRegistrar.Field field : registrar.getFields()) {
            SimpleProperty property = new SimpleProperty(field.getName(), null, field.getType(), field.getDisplayName()){

                public boolean isPassword() {
                    return field.isPassword();
                }
            };
            property.setDescription(field.getDescription());
            this.properties.add((Property)property);
            Component component = factory.create((Property)property);
            ComponentState state = new ComponentState(component, (Property)property, group);
            grid.add(new ComponentState[]{state});
        }
        column.add((Component)grid.createGrid());
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
        this.resize("ManagedTerminalRegistrationDialog.size");
    }

    protected void onOK() {
        this.register();
    }

    private void register() {
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (Property property : this.properties) {
                values.put(property.getName(), property.getValue());
            }
            this.registrar.register(values);
            ((InformationDialogBuilder)((InformationDialogBuilder)((InformationDialogBuilder)InformationDialog.newDialog().title(Messages.get((String)"admin.eftpos.register.title"))).message(Messages.get((String)"admin.eftpos.register.registered"))).ok(() -> this.close("ok"))).show();
        }
        catch (Throwable exception) {
            String error = ErrorFormatter.format((Throwable)exception);
            ((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().title(Messages.get((String)"admin.eftpos.register.title"))).message(Messages.format((String)"admin.eftpos.register.error", (Object[])new Object[]{error}))).show();
        }
    }
}

