/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.calendar;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.workspace.admin.calendar.CalendarGrid;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;

public class DefaultCalendarGrid
implements CalendarGrid {
    private final Schedule schedule;
    private final Date startDate;
    private final int days;
    private final int slotSize = 15;

    public DefaultCalendarGrid(Entity calendar, Date date, int days, List<PropertySet> events, AppointmentRules rules) {
        this.startDate = date;
        this.days = days;
        this.schedule = new Schedule(calendar, null, 0, 1440, 15, Collections.emptyList(), rules);
        for (PropertySet event : events) {
            IMObjectReference eventRef = event.getReference("act.objectReference");
            if (this.schedule.indexOf((Reference)eventRef) != -1) continue;
            this.schedule.addEvent(event);
        }
    }

    @Override
    public int getStartMins() {
        return 0;
    }

    @Override
    public int getEndMins() {
        return 1440;
    }

    @Override
    public int getFirstSlot(int minutes) {
        if (minutes < this.getStartMins() || minutes > this.getEndMins()) {
            return -1;
        }
        return (minutes - this.getStartMins()) / this.getSlotSize();
    }

    @Override
    public int getLastSlot(int minutes) {
        return this.getFirstSlot(minutes);
    }

    @Override
    public int getSlots() {
        return 96;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public int getDays() {
        return this.days;
    }

    @Override
    public Date getStartTime(int slot) {
        return DateRules.getDate((Date)this.startDate, (int)(slot * 15), (DateUnits)DateUnits.MINUTES);
    }

    @Override
    public Date getDatetime(int offset, int slot) {
        Date date = DateRules.getDate((Date)this.startDate, (int)offset, (DateUnits)DateUnits.DAYS);
        return DateRules.getDate((Date)date, (int)(slot * 15), (DateUnits)DateUnits.MINUTES);
    }

    @Override
    public PropertySet getEvent(int offset, int slot) {
        Date datetime = this.getDatetime(offset, slot);
        PropertySet result = this.schedule.getEvent(datetime, 15, true);
        if (result == null) {
            result = this.schedule.getIntersectingEvent(datetime, datetime, 15, true);
        }
        return result;
    }

    @Override
    public int getHour(int slot) {
        return slot * 15 / 60;
    }

    @Override
    public int getSlotSize() {
        return 15;
    }
}

