/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.calendar;

import java.util.Objects;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;

public class CalendarEventSeries
extends ScheduleEventSeries {
    public CalendarEventSeries(Act event, IArchetypeService service) {
        super(event, service, 730);
    }

    @Override
    protected ScheduleEventSeries.State createState(IMObjectBean bean) {
        return new EventState(bean);
    }

    @Override
    protected ScheduleEventSeries.State copy(ScheduleEventSeries.State state) {
        return new EventState((EventState)state);
    }

    @Override
    protected void populate(IMObjectBean bean, ScheduleEventSeries.State state) {
        super.populate(bean, state);
        EventState eventState = (EventState)state;
        bean.setValue("name", (Object)eventState.getName());
        bean.setValue("notes", (Object)eventState.getNotes());
        bean.setTarget("location", eventState.getLocation());
    }

    private static class EventState
    extends ScheduleEventSeries.State {
        private String name;
        private String notes;
        private Reference location;

        public EventState(IMObjectBean event) {
            super(event);
        }

        public EventState(EventState state) {
            super(state);
            this.name = state.getName();
            this.notes = state.getNotes();
            this.location = state.getLocation();
        }

        @Override
        public void update(IMObjectBean event) {
            super.update(event);
            this.name = event.getString("name");
            this.notes = event.getString("notes");
            this.location = event.getTargetRef("location");
        }

        public String getName() {
            return this.name;
        }

        public String getNotes() {
            return this.notes;
        }

        public Reference getLocation() {
            return this.location;
        }

        @Override
        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof EventState && super.equals(obj)) {
                EventState other = (EventState)obj;
                result = Objects.equals(this.name, other.name) && Objects.equals(this.notes, other.notes) && Objects.equals(this.location, other.location);
            }
            return result;
        }
    }
}

