/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.calendar;

import java.util.List;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.workflow.CalendarService;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.delete.AbstractIMObjectDeletionListener;
import org.openvpms.web.component.im.delete.ConfirmingDeleter;
import org.openvpms.web.component.im.delete.IMObjectDeletionListener;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.AbstractCalendarEventEditDialog;
import org.openvpms.web.workspace.workflow.appointment.AbstractCalendarEventEditor;
import org.openvpms.web.workspace.workflow.appointment.DeleteSeriesDialog;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeriesState;

public class CalendarEventEditDialog
extends AbstractCalendarEventEditDialog {
    private static final String DELETE_ID = "button.delete";

    public CalendarEventEditDialog(AbstractCalendarEventEditor editor, Context context) {
        super(editor, context);
        ButtonSet buttons = this.getButtons();
        buttons.add(DELETE_ID, this::onDelete);
        this.enableDelete();
    }

    public boolean save() {
        boolean save = super.save();
        this.enableDelete();
        return save;
    }

    @Override
    protected boolean checkEventTimes(List<Times> times, boolean close) {
        boolean result = true;
        AbstractCalendarEventEditor editor = this.getEditor();
        Entity schedule = editor.getSchedule();
        if (schedule != null) {
            Times overlap;
            CalendarService service = (CalendarService)ServiceHelper.getBean(CalendarService.class);
            List overlaps = service.getOverlappingEvents(times, schedule, 1);
            Times times2 = overlap = overlaps != null && !overlaps.isEmpty() ? (Times)overlaps.get(0) : null;
            if (overlap != null) {
                this.displayOverlapError(overlap);
                result = false;
            }
        }
        return result;
    }

    protected void deleteSeries(final ScheduleEventSeriesState state) {
        final DeleteSeriesDialog dialog = new DeleteSeriesDialog(state, this.getHelpContext().subtopic("deleteseries"));
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                boolean deleted = false;
                if (dialog.single()) {
                    deleted = state.delete();
                } else if (dialog.future()) {
                    deleted = state.deleteFuture();
                } else if (dialog.all()) {
                    deleted = state.deleteSeries();
                }
                if (deleted) {
                    CalendarEventEditDialog.this.close(CalendarEventEditDialog.DELETE_ID);
                }
            }
        });
        dialog.show();
    }

    protected void delete(Act event) {
        ConfirmingDeleter deleter = (ConfirmingDeleter)ServiceHelper.getBean(ConfirmingDeleter.class);
        HelpContext delete = this.getHelpContext().subtopic("delete");
        LocalContext local = new LocalContext(this.getContext());
        deleter.delete((IMObject)event, (Context)local, delete, (IMObjectDeletionListener)new AbstractIMObjectDeletionListener<Act>(){

            public void deleted(Act object) {
                CalendarEventEditDialog.this.close(CalendarEventEditDialog.DELETE_ID);
            }

            public void deactivated(Act object) {
                CalendarEventEditDialog.this.close(CalendarEventEditDialog.DELETE_ID);
            }
        });
    }

    private void onDelete() {
        Act event = this.getEvent();
        if ((event = (Act)IMObjectHelper.reload((IMObject)event)) != null) {
            ScheduleEventSeriesState state = new ScheduleEventSeriesState(event, (IArchetypeService)ServiceHelper.getArchetypeService());
            if (state.hasSeries() && state.canEditFuture()) {
                this.deleteSeries(state);
            } else {
                this.delete(event);
            }
        } else {
            this.close(DELETE_ID);
        }
    }

    private void enableDelete() {
        ButtonSet buttons = this.getButtons();
        buttons.setEnabled(DELETE_ID, !this.getEvent().isNew());
    }
}

