/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.calendar;

import java.util.Date;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.calendar.CalendarEventEditor;
import org.openvpms.web.workspace.admin.calendar.CalendarEventViewer;
import org.openvpms.web.workspace.admin.calendar.CalendarLayoutStrategy;
import org.openvpms.web.workspace.admin.calendar.CalendarListener;
import org.openvpms.web.workspace.workflow.appointment.EditSeriesDialog;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeriesState;

public class AbstractCalendarEditor
extends AbstractIMObjectEditor {
    private final CalendarEventViewer viewer;

    public AbstractCalendarEditor(Entity object, IMObject parent, LayoutContext layoutContext) {
        super((IMObject)object, parent, layoutContext);
        this.viewer = new CalendarEventViewer(object);
        this.viewer.setListener(new CalendarListener(){

            @Override
            public void create(Date date) {
                AbstractCalendarEditor.this.onCreate(date);
            }

            @Override
            public void edit(Act event) {
                AbstractCalendarEditor.this.onEdit(event);
            }
        });
    }

    public CalendarEventViewer getViewer() {
        return this.viewer;
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new CalendarLayoutStrategy(this.viewer);
    }

    protected void onCreate(Date date) {
        if (this.getObject().isNew()) {
            this.save();
        }
        Act event = (Act)IMObjectCreator.create((String)"act.calendarEvent");
        event.setActivityStartTime(date);
        IMObjectBean bean = this.getBean((IMObject)event);
        bean.addTarget("schedule", this.getObject());
        this.onEdit(event);
    }

    protected void onEdit(final Act event) {
        final ScheduleEventSeriesState state = new ScheduleEventSeriesState(event, (IArchetypeService)ServiceHelper.getArchetypeService());
        if (state.hasSeries()) {
            if (state.canEditFuture()) {
                final EditSeriesDialog dialog = new EditSeriesDialog(state, this.getHelpContext().subtopic("editseries"));
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        if (dialog.single()) {
                            AbstractCalendarEditor.this.edit(event, false);
                        } else if (dialog.future()) {
                            AbstractCalendarEditor.this.edit(event, true);
                        } else if (dialog.all()) {
                            AbstractCalendarEditor.this.edit(state.getFirst(), true);
                        }
                    }
                });
                dialog.show();
            } else {
                this.edit(event, false);
            }
        } else {
            this.edit(event, true);
        }
    }

    protected IMObjectEditor createEditor(Act event, boolean editSeries, LayoutContext layout) {
        return new CalendarEventEditor(event, null, editSeries, layout);
    }

    private void edit(Act event, boolean editSeries) {
        HelpContext help = this.getHelpContext().topic((IMObject)event, "edit");
        Context context = this.getLayoutContext().getContext();
        DefaultLayoutContext layout = new DefaultLayoutContext(context, help);
        IMObjectEditor editor = this.createEditor(event, editSeries, (LayoutContext)layout);
        EditDialog dialog = ((EditDialogFactory)ServiceHelper.getBean(EditDialogFactory.class)).create(editor, context);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onClose(WindowPaneEvent event) {
                AbstractCalendarEditor.this.viewer.refresh();
            }
        });
        dialog.show();
    }
}

