/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.archetype;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IterableIMObjectQuery;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.tools.archetype.comparator.ArchetypeChange;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.processor.ProgressBarProcessor;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.MessageDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.archetype.BatchArchetypeUpdater;

class ObjectUpdateProgressBarProcessor
extends ProgressBarProcessor<IMObject> {
    private final IArchetypeService service;
    private boolean derive = false;
    private List<String> nodes;
    private final List<IMObject> batch = new ArrayList<IMObject>();

    public ObjectUpdateProgressBarProcessor() {
        super(null);
        this.service = ServiceHelper.getArchetypeService();
    }

    public void update(ArchetypeChange change) {
        this.derive = change.hasChangedDerivedNodes();
        this.nodes = change.getNodesWithAddedAssertions(BatchArchetypeUpdater.ASSERTIONS);
        String archetype = ((ArchetypeDescriptor)change.getNewVersion()).getArchetypeType();
        ArchetypeQuery query = new ArchetypeQuery(archetype, false, false);
        query.add((IConstraint)new NodeSortConstraint("id"));
        query.setMaxResults(0);
        query.setCountResults(true);
        int size = this.service.get((IArchetypeQuery)query).getTotalResults();
        query.setMaxResults(100);
        query.setCountResults(false);
        IterableIMObjectQuery iter = new IterableIMObjectQuery(this.service, (IArchetypeQuery)query);
        this.setItems((Iterable)iter, size);
        this.process();
    }

    protected void process(IMObject object) {
        boolean changed = false;
        try {
            if (!this.nodes.isEmpty()) {
                changed = this.updateNodes(object);
            }
            if (changed || this.derive) {
                this.service.deriveValues(object);
                changed = true;
            }
            boolean flushed = false;
            if (changed) {
                this.batch.add(object);
                if (this.batch.size() > 100) {
                    this.flushBatch(new ProcessNextContinuation(object));
                    flushed = true;
                }
            }
            if (!flushed) {
                this.processCompleted(object);
            }
        }
        catch (Throwable exception) {
            this.prompt(object, exception, new ProcessNextContinuation(object));
        }
    }

    protected void processingCompleted() {
        Continuation continuation = new Continuation(){

            @Override
            public void execute() {
                ObjectUpdateProgressBarProcessor.super.processingCompleted();
            }

            @Override
            public void cancel() {
                ObjectUpdateProgressBarProcessor.super.processingCompleted();
            }
        };
        this.flushBatch(continuation);
    }

    private boolean updateNodes(IMObject object) {
        boolean changed = false;
        IMObjectBean bean = this.service.getBean(object);
        for (String name : this.nodes) {
            String old = bean.getString(name);
            if (old == null) continue;
            bean.setValue(name, null);
            bean.setValue(name, (Object)old);
            if (old.equals(bean.getString(name))) continue;
            changed = true;
        }
        return changed;
    }

    private void flushBatch(Continuation continuation) {
        if (!this.batch.isEmpty()) {
            try {
                this.service.save(this.batch);
                this.batch.clear();
                continuation.execute();
            }
            catch (Throwable exception) {
                BatchFlusher flusher = new BatchFlusher(continuation);
                flusher.flush();
            }
        } else {
            continuation.execute();
        }
    }

    private void prompt(IMObject object, Throwable exception, final Continuation continuation) {
        this.setSuspend(true);
        String displayName = DescriptorHelper.getDisplayName((IMObject)object, (ArchetypeService)ServiceHelper.getArchetypeService());
        String title = Messages.format((String)"archetype.update.errortitle", (Object[])new Object[]{displayName});
        String error = ErrorFormatter.format((Throwable)exception, (String)displayName);
        String message = Messages.format((String)"archetype.update.errormessage", (Object[])new Object[]{displayName, object.getId(), error});
        ErrorDialog dialog = new ErrorDialog(title, message, MessageDialog.SKIP_CANCEL);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onSkip() {
                continuation.execute();
            }

            public void onCancel() {
                continuation.cancel();
            }
        });
        dialog.show();
    }

    private class ProcessNextContinuation
    implements Continuation {
        private final IMObject object;

        public ProcessNextContinuation(IMObject object) {
            this.object = object;
        }

        @Override
        public void execute() {
            ObjectUpdateProgressBarProcessor.this.processCompleted(this.object);
            if (ObjectUpdateProgressBarProcessor.this.isSuspended()) {
                ObjectUpdateProgressBarProcessor.this.process();
            }
        }

        @Override
        public void cancel() {
            ObjectUpdateProgressBarProcessor.this.batch.clear();
            ObjectUpdateProgressBarProcessor.this.processingCompleted();
        }
    }

    private class BatchFlusher {
        private final Continuation continuation;
        private final ListIterator<IMObject> iter;

        public BatchFlusher(Continuation continuation) {
            this.continuation = continuation;
            this.iter = ObjectUpdateProgressBarProcessor.this.batch.listIterator();
        }

        public void flush() {
            boolean error = false;
            while (this.iter.hasNext()) {
                IMObject object = this.iter.next();
                this.iter.remove();
                try {
                    ObjectUpdateProgressBarProcessor.this.service.save(object);
                }
                catch (Throwable exception) {
                    ObjectUpdateProgressBarProcessor.this.prompt(object, exception, new Continuation(){

                        @Override
                        public void execute() {
                            BatchFlusher.this.flush();
                        }

                        @Override
                        public void cancel() {
                            BatchFlusher.this.continuation.cancel();
                        }
                    });
                    error = true;
                    break;
                }
            }
            if (!error) {
                this.continuation.execute();
            }
        }
    }

    private static interface Continuation {
        public void execute();

        public void cancel();
    }
}

