/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin;

import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.query.BrowserState;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.component.workspace.ResultSetCRUDWorkspace;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.organisation.OrganisationCRUDWindow;

public class OrganisationWorkspace
extends ResultSetCRUDWorkspace<Entity> {
    private static final String[] ARCHETYPES = new String[]{"party.organisation*", "entity.organisation*", "entity.department", "entity.rosterArea", "entity.smsProvider*", "entity.SMSConfigEmail*", "entity.calendarServiceRatio", "entity.mailServer", "entity.insuranceService*", "entity.printerService*", "entity.plugin*", "entity.EFTPOSTerminal*", "entity.paymentProcessor*"};

    public OrganisationWorkspace(Context context) {
        super("admin.organisation", context);
        String displayName = Messages.get((String)(this.getId() + ".type"));
        this.setArchetypes(Archetypes.create((String[])ARCHETYPES, Entity.class, null, (String)displayName));
    }

    public void setObject(Entity object) {
        super.setObject((IMObject)object);
        Context context = this.getContext();
        if (TypeHelper.isA((IMObject)object, (String)"party.organisationSchedule")) {
            context.setSchedule(object);
        } else if (TypeHelper.isA((IMObject)object, (String)"party.organisationWorkList")) {
            context.setWorkList(object);
        } else if (TypeHelper.isA((IMObject)object, (String)"party.organisationTill")) {
            context.setTill(object);
        }
    }

    public void show() {
        if (this.updateArchetypes(ARCHETYPES)) {
            BrowserState state = null;
            QueryBrowser browser = this.getBrowser();
            if (browser != null) {
                state = browser.getBrowserState();
            }
            this.layoutWorkspace(false);
            if (state != null && (browser = this.getBrowser()) != null) {
                browser.setBrowserState(state);
            }
        }
        super.show();
    }

    public boolean canUpdate(String shortName) {
        return false;
    }

    protected Query<Entity> createQuery() {
        Query query = super.createQuery();
        query.setContains(true);
        return query;
    }

    protected CRUDWindow<Entity> createCRUDWindow() {
        QueryBrowser browser = this.getBrowser();
        return new OrganisationCRUDWindow((Archetypes<Entity>)this.getArchetypes(), (Query<Entity>)browser.getQuery(), (ResultSet<Entity>)browser.getResultSet(), this.getContext(), this.getHelpContext());
    }
}

