/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace;

import echopointng.ImageIcon;
import echopointng.image.URLImageReference;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.layout.RowLayoutData;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.archetype.rules.doc.LogoService;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextListener;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.list.IMObjectListModel;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.component.prefs.UserPreferences;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.pane.ContentPane;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.user.UserPreferencesDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitlePane
extends ContentPane {
    private final PracticeRules practiceRules;
    private final UserRules userRules;
    private final GlobalContext context;
    private final UserPreferences preferences;
    private final LogoService logoService;
    private ImageIcon logo;
    private SelectField locationSelector;
    private SelectField departmentSelector;
    private ContextListener departmentListener;
    private static final String STYLE = "TitlePane";
    private static final Logger log = LoggerFactory.getLogger(TitlePane.class);

    public TitlePane(PracticeRules practiceRules, UserRules userRules, GlobalContext context, UserPreferences preferences, LogoService logoService) {
        this.practiceRules = practiceRules;
        this.userRules = userRules;
        this.context = context;
        this.preferences = preferences;
        this.logoService = logoService;
        this.doLayout();
    }

    public void dispose() {
        if (this.departmentListener != null) {
            this.context.removeListener("entity.department", this.departmentListener);
            this.departmentListener = null;
        }
        super.dispose();
    }

    protected void doLayout() {
        List<Entity> departments;
        this.setStyleName(STYLE);
        this.logo = new ImageIcon();
        this.logo.setStyleName("logo");
        this.logo.setLayoutData((LayoutData)RowFactory.layout((Alignment)new Alignment(0, 4)));
        Label user = LabelFactory.create(null, (String)"small");
        user.setText(Messages.format((String)"label.user", (Object[])new Object[]{this.getUserName()}));
        Row locationUserRow = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{user});
        List<Party> locations = this.getLocations();
        if (!locations.isEmpty()) {
            Party defLocation = this.getDefaultLocation();
            Label location = LabelFactory.create((String)"app.location", (String)"small");
            IMObjectListModel model = new IMObjectListModel(locations, false, false);
            this.locationSelector = SelectFieldFactory.create((ListModel)model);
            if (defLocation != null) {
                this.locationSelector.setSelectedItem((Object)defLocation);
            }
            this.locationSelector.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
            locationUserRow.add((Component)location);
            locationUserRow.add((Component)this.locationSelector);
            this.locationSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent e) {
                    TitlePane.this.changeLocation();
                }
            });
            this.setLogo(defLocation);
        }
        if (!(departments = this.getDepartments()).isEmpty()) {
            Entity defDepartment = this.getDefaultDepartment(departments);
            Label department = LabelFactory.create((String)"app.department", (String)"small");
            IMObjectListModel model = new IMObjectListModel(departments, false, false);
            this.departmentSelector = SelectFieldFactory.create((ListModel)model);
            if (defDepartment == null) {
                defDepartment = departments.get(0);
            }
            this.departmentSelector.setSelectedItem((Object)defDepartment);
            this.context.setDepartment(defDepartment);
            this.departmentSelector.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
            locationUserRow.add((Component)department);
            locationUserRow.add((Component)this.departmentSelector);
            this.departmentSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent e) {
                    TitlePane.this.changeDepartment();
                }
            });
            this.departmentListener = (key, value) -> this.onDepartmentChanged();
            this.context.addListener("entity.department", this.departmentListener);
        }
        if (this.canEditPreferences()) {
            Button preferences = ButtonFactory.create(null, (String)"button.preferences", this::editPreferences);
            locationUserRow.add((Component)preferences);
        }
        Row inset = RowFactory.create((String)"InsetX", (Component[])new Component[]{locationUserRow});
        RowLayoutData right = new RowLayoutData();
        right.setAlignment(new Alignment(5, 4));
        right.setWidth(new Extent(100, 2));
        inset.setLayoutData((LayoutData)right);
        Row row = RowFactory.create((Component[])new Component[]{this.logo, inset});
        this.add((Component)row);
    }

    protected String getUserName() {
        User user = this.context.getUser();
        return user != null ? user.getName() : null;
    }

    private void changeLocation() {
        Party selected = (Party)this.locationSelector.getSelectedItem();
        this.context.setLocation(selected);
        this.setLogo(selected);
    }

    private void changeDepartment() {
        Entity selected = (Entity)this.departmentSelector.getSelectedItem();
        this.context.setDepartment(selected);
        Long id = selected != null ? Long.valueOf(selected.getId()) : null;
        this.preferences.setPreference("entity.preferenceGroupGeneral", "department", (Object)id, true);
    }

    private void onDepartmentChanged() {
        Entity department = this.context.getDepartment();
        if (!Objects.equals(department, this.departmentSelector.getSelectedItem())) {
            this.departmentSelector.setSelectedItem((Object)department);
        }
    }

    private void setLogo(Party location) {
        URLImageReference ref = null;
        try {
            Party practice;
            URL url = this.logoService.getURL((Entity)location);
            if (url == null && (practice = this.context.getPractice()) != null) {
                url = this.logoService.getURL((Entity)practice);
            }
            if (url != null) {
                ref = new URLImageReference(url);
            }
        }
        catch (Exception exception) {
            log.warn("Failed to retrieve logo: {}", (Object)exception.getMessage(), (Object)exception);
        }
        this.logo.setIcon(ref);
    }

    private List<Party> getLocations() {
        List locations = Collections.emptyList();
        User user = this.context.getUser();
        Party practice = this.context.getPractice();
        if (user != null && practice != null) {
            locations = this.userRules.getLocations(user, practice);
            IMObjectSorter.sort((List)locations, (String[])new String[]{"name"});
        }
        return locations;
    }

    private List<Entity> getDepartments() {
        List departments = Collections.emptyList();
        Party practice = this.context.getPractice();
        User user = this.context.getUser();
        if (practice != null && user != null && this.practiceRules.departmentsEnabled(practice)) {
            departments = this.userRules.getDepartments(user);
            IMObjectSorter.sort((List)departments, (String[])new String[]{"name"});
        }
        return departments;
    }

    private Entity getDefaultDepartment(List<Entity> departments) {
        long id;
        Entity result = null;
        User user = this.context.getUser();
        if (user != null && (result = this.userRules.getDefaultDepartment(user, departments)) == null && (id = this.preferences.getLong("entity.preferenceGroupGeneral", "department", -1L)) != -1L) {
            result = departments.stream().filter(entity -> entity.getId() == id).findFirst().orElse(null);
        }
        return result;
    }

    private Party getDefaultLocation() {
        Party practice;
        Party location = null;
        User user = this.context.getUser();
        if (user != null && (location = this.userRules.getDefaultLocation(user)) == null && (practice = this.context.getPractice()) != null) {
            location = this.practiceRules.getDefaultLocation(practice);
        }
        return location;
    }

    private boolean canEditPreferences() {
        boolean result = false;
        User user = this.context.getUser();
        if (user != null) {
            IMObjectBean bean = IMObjectHelper.getBean((IMObject)user);
            result = bean.getBoolean("editPreferences");
        }
        return result;
    }

    private void editPreferences() {
        User user = (User)IMObjectHelper.reload((IMObject)this.context.getUser());
        if (user != null) {
            UserPreferencesDialog dialog = new UserPreferencesDialog(user, this.context.getPractice(), (Context)new LocalContext((Context)this.context));
            dialog.show();
        }
    }
}

