/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import org.junit.Test;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.query.EntityObjectSetQuery;
import org.openvpms.web.component.im.query.EntityQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryTestHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.worklist.ScheduleWorkListQuery;

public class ScheduleWorklistQueryTestCase
extends AbstractAppTest {
    @Test
    public void testQueryAll() {
        Party workList1 = ScheduleTestHelper.createWorkList();
        Party workList2 = ScheduleTestHelper.createWorkList();
        ScheduleWorkListQuery query = new ScheduleWorkListQuery(null, null);
        EntityQuery adapter = new EntityQuery((EntityObjectSetQuery)query, (Context)new LocalContext());
        QueryTestHelper.checkSelects((boolean)true, (Query)adapter, (IMObject)workList1);
        QueryTestHelper.checkSelects((boolean)true, (Query)adapter, (IMObject)workList2);
    }

    @Test
    public void testQueryBySchedule() {
        Party schedule = ScheduleTestHelper.createSchedule((Party)TestHelper.createLocation());
        Party workList1 = ScheduleTestHelper.createWorkList();
        Party workList2 = ScheduleTestHelper.createWorkList();
        Party workList3 = ScheduleTestHelper.createWorkList();
        ScheduleTestHelper.addWorkLists((Entity)schedule, (Entity[])new Entity[]{workList1, workList2});
        ScheduleWorkListQuery query = new ScheduleWorkListQuery((Entity)schedule, null);
        EntityQuery adapter = new EntityQuery((EntityObjectSetQuery)query, (Context)new LocalContext());
        QueryTestHelper.checkSelects((boolean)true, (Query)adapter, (IMObject)workList1);
        QueryTestHelper.checkSelects((boolean)true, (Query)adapter, (IMObject)workList2);
        QueryTestHelper.checkSelects((boolean)false, (Query)adapter, (IMObject)workList3);
        IMObjectBean bean = this.getBean((IMObject)schedule);
        bean.setValue("useAllWorkLists", (Object)true);
        QueryTestHelper.checkSelects((boolean)true, (Query)adapter, (IMObject)workList1);
        QueryTestHelper.checkSelects((boolean)true, (Query)adapter, (IMObject)workList2);
        QueryTestHelper.checkSelects((boolean)true, (Query)adapter, (IMObject)workList3);
    }

    @Test
    public void testQueryByLocation() {
        Party location = TestHelper.createLocation();
        Party workList1 = ScheduleTestHelper.createWorkList();
        Party workList2 = ScheduleTestHelper.createWorkList();
        Party workList3 = ScheduleTestHelper.createWorkList();
        Entity workListView = ScheduleTestHelper.createWorkListView((Entity[])new Entity[]{workList1, workList2});
        ScheduleTestHelper.addWorkListView((Party)location, (Entity)workListView, (boolean)true);
        ScheduleWorkListQuery query = new ScheduleWorkListQuery(null, (Entity)location);
        EntityQuery adapter = new EntityQuery((EntityObjectSetQuery)query, (Context)new LocalContext());
        QueryTestHelper.checkSelects((boolean)true, (Query)adapter, (IMObject)workList1);
        QueryTestHelper.checkSelects((boolean)true, (Query)adapter, (IMObject)workList2);
        QueryTestHelper.checkSelects((boolean)false, (Query)adapter, (IMObject)workList3);
    }

    @Test
    public void testQueryByScheduleAndLocation() {
        Party location = TestHelper.createLocation();
        Party schedule = ScheduleTestHelper.createSchedule((Party)location);
        Party workList1 = ScheduleTestHelper.createWorkList();
        Party workList2 = ScheduleTestHelper.createWorkList();
        Party workList3 = ScheduleTestHelper.createWorkList();
        ScheduleTestHelper.addWorkLists((Entity)schedule, (Entity[])new Entity[]{workList1, workList2});
        Entity workListView = ScheduleTestHelper.createWorkListView((Entity[])new Entity[]{workList1, workList3});
        ScheduleTestHelper.addWorkListView((Party)location, (Entity)workListView, (boolean)true);
        ScheduleWorkListQuery query = new ScheduleWorkListQuery((Entity)schedule, (Entity)location);
        EntityQuery adapter = new EntityQuery((EntityObjectSetQuery)query, (Context)new LocalContext());
        QueryTestHelper.checkSelects((boolean)true, (Query)adapter, (IMObject)workList1);
        QueryTestHelper.checkSelects((boolean)true, (Query)adapter, (IMObject)workList2);
        QueryTestHelper.checkSelects((boolean)false, (Query)adapter, (IMObject)workList3);
        IMObjectBean bean = this.getBean((IMObject)schedule);
        bean.setValue("useAllWorkLists", (Object)true);
        QueryTestHelper.checkSelects((boolean)true, (Query)adapter, (IMObject)workList1);
        QueryTestHelper.checkSelects((boolean)false, (Query)adapter, (IMObject)workList2);
        QueryTestHelper.checkSelects((boolean)true, (Query)adapter, (IMObject)workList3);
    }
}

