/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.otc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.otc.OTCPaymentEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class OTCPaymentEditorTestCase
extends AbstractAppTest {
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testPaymentProcessorItemsExcluded() {
        FinancialAct payment = (FinancialAct)this.create("act.customerAccountPayment", FinancialAct.class);
        OTCPaymentEditor editor = this.createEditor(payment, BigDecimal.TEN);
        CollectionProperty items = editor.getCollectionProperty("items");
        Assert.assertNotNull((Object)items);
        List<String> archetypes = Arrays.asList(items.getArchetypeRange());
        Assert.assertFalse((boolean)archetypes.contains("act.customerAccountPaymentPP"));
        Assert.assertFalse((boolean)archetypes.contains("act.customerAccountRefundPP"));
    }

    private OTCPaymentEditor createEditor(FinancialAct act, BigDecimal charge) {
        LocalContext localContext = new LocalContext();
        localContext.setCustomer(this.practiceFactory.createOTC());
        DefaultLayoutContext context = new DefaultLayoutContext((Context)localContext, new HelpContext("foo", null));
        context.setEdit(true);
        OTCPaymentEditor editor = new OTCPaymentEditor(act, null, (LayoutContext)context, charge);
        editor.getComponent();
        return editor;
    }
}

