/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.sms;

import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.builder.sms.TestSMSBuilder;
import org.openvpms.archetype.test.builder.sms.TestSMSFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.messaging.sms.SMSMessageEditor;
import org.openvpms.web.workspace.workflow.messaging.sms.SMSMessageLayoutStrategy;
import org.springframework.beans.factory.annotation.Autowired;

public class SMSMessageEditorTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestSMSFactory smsFactory;

    @Test
    public void testStartEndTimeValidation() {
        Act act1 = (Act)((TestSMSBuilder)this.smsFactory.newSMS().message("test 1")).sent(DateRules.getYesterday()).updated(DateRules.getToday()).build(false);
        Assert.assertTrue((boolean)this.createEditor(act1).isValid());
        Act act2 = (Act)((TestSMSBuilder)this.smsFactory.newSMS().message("test 2")).sent(DateRules.getToday()).updated(DateRules.getYesterday()).build(false);
        Assert.assertTrue((boolean)this.createEditor(act2).isValid());
    }

    @Test
    public void testNewInstance() {
        Act act = (Act)this.smsFactory.newSMS().build(false);
        SMSMessageEditor editor = this.createEditor(act);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof SMSMessageEditor));
    }

    @Test
    public void testFactory() {
        Act act = (Act)this.smsFactory.newSMS().build(false);
        IMObjectEditor editor = this.factory.create((IMObject)act, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        Assert.assertTrue((boolean)(editor instanceof SMSMessageEditor));
    }

    @Test
    public void testLayoutStrategy() {
        Act act = (Act)this.smsFactory.newSMS().build(false);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        MutableObject strategy = new MutableObject();
        SMSMessageEditor editor = new SMSMessageEditor(act, null, (LayoutContext)context, (Mutable)strategy){
            final /* synthetic */ Mutable val$strategy;
            {
                this.val$strategy = mutable;
                super(x0, x1, x2);
            }

            protected IMObjectLayoutStrategy createLayoutStrategy() {
                IMObjectLayoutStrategy result = super.createLayoutStrategy();
                this.val$strategy.setValue((Object)result);
                return result;
            }
        };
        editor.getComponent();
        Assert.assertTrue((boolean)(strategy.getValue() instanceof SMSMessageLayoutStrategy));
    }

    private SMSMessageEditor createEditor(Act act) {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        return new SMSMessageEditor(act, null, (LayoutContext)context);
    }
}

