/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.insurance.InsuranceTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.archetype.test.builder.product.TestServiceProductBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestTaskBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditDialog;
import org.openvpms.web.workspace.patient.insurance.claim.TestGapInsuranceService;
import org.openvpms.web.workspace.workflow.AbstractWorkflowTest;
import org.openvpms.web.workspace.workflow.checkout.CheckOutWorkflow;
import org.openvpms.web.workspace.workflow.checkout.CheckoutWorkflowRunner;
import org.openvpms.web.workspace.workflow.checkout.InvoiceViewerDialog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.test.annotation.DirtiesContext;

@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class CheckoutWorkflowTestCase
extends AbstractWorkflowTest {
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    private Context context;
    private Party patient;
    private Party customer;
    private User clinician;
    private Entity till;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.till = this.practiceFactory.createTill();
        Party location = (Party)this.practiceFactory.newLocation().tills(new Entity[]{this.till}).build();
        User user = this.userFactory.createUser();
        this.context = new LocalContext();
        this.context.setLocation(location);
        this.context.setUser(user);
        this.customer = this.customerFactory.createCustomer();
        this.clinician = this.userFactory.createClinician();
        this.patient = this.patientFactory.createPatient(this.customer);
        SingletonBeanRegistry factory = (SingletonBeanRegistry)this.applicationContext.getAutowireCapableBeanFactory();
        if (!factory.containsSingleton("insuranceServices")) {
            TestGapInsuranceService service = new TestGapInsuranceService();
            InsuranceServices insuranceServices = (InsuranceServices)Mockito.mock(InsuranceServices.class);
            Mockito.when((Object)insuranceServices.getService((Party)Mockito.any())).thenReturn((Object)service);
            factory.registerSingleton("insuranceServices", (Object)insuranceServices);
        }
    }

    @Test
    public void testCheckOutWorkflowForAppointment() {
        Act appointment = this.createAppointment();
        this.checkWorkflow(appointment, this.clinician);
    }

    @Test
    public void testCheckoutFromFutureDatedAppointmentWithMissingVisit() {
        Date now = new Date();
        Act appointment = (Act)((TestAppointmentBuilder)this.newAppointment().startTime(DateRules.getDate((Date)now, (int)30, (DateUnits)DateUnits.MINUTES))).build();
        CheckoutWorkflowRunner runner = this.checkWorkflow(appointment, this.clinician);
        List<Act> visits = runner.getVisits();
        Assert.assertEquals((long)1L, (long)visits.size());
        Act visit = visits.get(0);
        Assert.assertEquals((Object)"COMPLETED", (Object)visit.getStatus());
        Assert.assertTrue((DateRules.compareTo((Date)visit.getActivityStartTime(), (Date)now, (boolean)true) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)visit.getActivityStartTime().before(appointment.getActivityStartTime()));
        Assert.assertTrue((visit.getActivityEndTime().compareTo(visit.getActivityStartTime()) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCheckoutWorkflowForTask() {
        Act task = this.createTask();
        Act appointment = (Act)this.newAppointment().task(task).build();
        CheckoutWorkflowRunner workflow = this.checkWorkflow(task, this.clinician);
        workflow.checkAppointmentComplete(appointment);
    }

    @Test
    public void testCancelInvoiceByUserCloseNoSave() {
        this.checkCancelInvoice(false, true);
    }

    @Test
    public void testCancelInvoiceByUserCloseAfterSave() {
        this.checkCancelInvoice(true, true);
    }

    @Test
    public void testCancelInvoiceByCancelButtonNoSave() {
        this.checkCancelInvoice(false, false);
    }

    @Test
    public void testCancelInvoiceByCancelButtonAfterSave() {
        this.checkCancelInvoice(true, false);
    }

    @Test
    public void testNoFinaliseInvoice() {
        Act appointment = this.createAppointment();
        this.createEvent(appointment);
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.start();
        BigDecimal amount = workflow.addInvoice(this.patient, false);
        workflow.confirm("no");
        workflow.print();
        workflow.checkComplete(true);
        workflow.checkContext(this.context, this.customer, this.patient, null, this.clinician);
        workflow.checkInvoice("IN_PROGRESS", amount, this.clinician);
        Assert.assertNull((Object)workflow.getPayment());
    }

    @Test
    public void testCancelFinaliseInvoice() {
        this.checkCancelFinaliseInvoice(false);
    }

    @Test
    public void testUserCloseFinaliseInvoice() {
        this.checkCancelFinaliseInvoice(true);
    }

    @Test
    public void testSkipPayment() {
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(this.createAppointment(), this.getPractice(), this.context);
        workflow.start();
        BigDecimal amount = workflow.addInvoice(this.patient, true);
        workflow.skipPayment();
        workflow.print();
        workflow.checkComplete(true);
        workflow.checkContext(this.context, this.customer, this.patient, null, this.clinician);
        workflow.checkInvoice("POSTED", amount, this.clinician);
        Assert.assertNull((Object)workflow.getPayment());
    }

    @Test
    public void testCancelPaymentConfirmation() {
        this.checkCancelPaymentConfirmation(false);
    }

    @Test
    public void testUserClosePaymentConfirmation() {
        this.checkCancelPaymentConfirmation(true);
    }

    @Test
    public void testCancelPayment() {
        this.checkCancelPayment(false);
    }

    @Test
    public void testCancelPaymentByUserClose() {
        this.checkCancelPayment(true);
    }

    @Test
    public void testFinalisedInvoice() {
        Act appointment = this.createAppointment();
        Act event = this.createEvent(appointment);
        BigDecimal amount = BigDecimal.TEN;
        List acts = FinancialTestHelper.createChargesInvoice((BigDecimal)amount, (Party)this.customer, (Party)this.patient, (Product)TestHelper.createProduct(), (String)"POSTED");
        this.save(acts);
        IMObjectBean bean = this.getBean((IMObject)event);
        bean.addTarget("chargeItems", (IMObject)acts.get(1));
        bean.save();
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.start();
        InvoiceViewerDialog dialog = workflow.getInvoiceViewerDialog();
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        workflow.confirm("yes");
        workflow.addPayment(this.till);
        workflow.checkPayment("POSTED", amount);
        workflow.print();
        workflow.checkComplete(true);
        workflow.checkContext(this.context, this.customer, this.patient, this.till, this.clinician);
    }

    @Test
    public void testUseLoggedInClinicianForClinician() {
        User clinician2 = TestHelper.createClinician();
        this.checkUseLoggedInClinician(true, clinician2, this.clinician, clinician2);
    }

    @Test
    public void testUseLoggedInClinicianForNonClinician() {
        User user = this.userFactory.createUser();
        this.checkUseLoggedInClinician(true, user, this.clinician, this.clinician);
    }

    @Test
    public void testUseLoggedInClinicianDisabledForClinician() {
        User clinician2 = this.userFactory.createClinician();
        this.checkUseLoggedInClinician(false, this.clinician, clinician2, clinician2);
    }

    @Test
    public void testUseLoggedInClinicianDisabledForNonClinician() {
        User user = this.userFactory.createUser();
        this.checkUseLoggedInClinician(false, user, this.clinician, this.clinician);
    }

    @Test
    public void testCheckoutAtLocationDifferentToInvoice() {
        Party location1 = this.context.getLocation();
        Party location2 = this.practiceFactory.createLocation();
        BigDecimal amount = BigDecimal.TEN;
        List acts = FinancialTestHelper.createChargesInvoice((BigDecimal)amount, (Party)this.customer, (Party)this.patient, (Product)TestHelper.createProduct(), (String)"IN_PROGRESS");
        IMObjectBean invoiceBean = this.getBean((IMObject)acts.get(0));
        invoiceBean.setTarget("location", (IMObject)location2);
        this.save(acts);
        Act appointment = this.createAppointment();
        Act event = this.createEvent(appointment);
        IMObjectBean bean = this.getBean((IMObject)event);
        bean.addTarget("chargeItems", (IMObject)acts.get(1));
        bean.save();
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.start();
        EditDialog dialog = workflow.getEditDialog();
        Assert.assertTrue((boolean)(dialog instanceof CustomerChargeActEditDialog));
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        workflow.confirmPostInvoice();
        workflow.checkInvoice("POSTED", amount, null);
        workflow.confirmPayment();
        workflow.addPayment(this.till);
        workflow.checkPayment("POSTED", amount, location1);
        workflow.print();
        workflow.checkComplete(true);
        workflow.checkContext(this.context, this.customer, this.patient, this.till, this.clinician);
        Assert.assertEquals((Object)location1, (Object)this.context.getLocation());
    }

    @Test
    public void testPromptForAllClaims() {
        this.checkPromptForClaim(CheckOutWorkflow.ClaimAtCheckout.ALL);
    }

    @Test
    public void testDisablePromptForClaim() {
        this.checkPromptForClaim(CheckOutWorkflow.ClaimAtCheckout.NONE);
    }

    @Test
    public void testPromptForStandardClaim() {
        this.checkPromptForClaim(CheckOutWorkflow.ClaimAtCheckout.STANDARD_CLAIM);
    }

    @Test
    public void testPromptForGapClaim() {
        this.checkPromptForClaim(CheckOutWorkflow.ClaimAtCheckout.GAP_CLAIM);
    }

    @Test
    public void testInvoicePostedByAnotherUser() {
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(this.createAppointment(), this.getPractice(), this.context);
        workflow.start();
        BigDecimal amount = workflow.addInvoice(this.patient, false);
        FinancialAct invoice = (FinancialAct)this.get((IMObject)workflow.getInvoice());
        Assert.assertNotNull((Object)invoice);
        invoice.setStatus("POSTED");
        this.save((IMObject)invoice);
        workflow.confirmPostInvoice();
        workflow.skipPayment();
        workflow.print();
        workflow.checkComplete(true);
        workflow.checkContext(this.context, this.customer, this.patient, null, this.clinician);
        workflow.checkInvoice("POSTED", amount, this.clinician);
        Assert.assertNull((Object)workflow.getPayment());
    }

    @Test
    public void testInvoiceDeletedByAnotherUserPrePost() {
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(this.createAppointment(), this.getPractice(), this.context);
        workflow.start();
        workflow.addInvoice(this.patient, false);
        FinancialAct invoice = (FinancialAct)this.get((IMObject)workflow.getInvoice());
        Assert.assertNotNull((Object)invoice);
        this.remove((IMObject)invoice);
        workflow.confirmPostInvoice();
        ErrorDialog error = (ErrorDialog)EchoTestHelper.getWindowPane(ErrorDialog.class);
        Assert.assertEquals((Object)Messages.get((String)"workflow.checkout.postinvoice.title"), (Object)error.getTitle());
        EchoTestHelper.fireDialogButton((PopupDialog)error, (String)"ok");
        workflow.checkComplete(false);
        workflow.checkContext(this.context, null, null, null, null);
        Assert.assertNull((Object)workflow.getPayment());
    }

    @Test
    public void testInvoiceCannotBePosted() {
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(this.createAppointment(), this.getPractice(), this.context);
        workflow.start();
        Entity investigationType = this.laboratoryFactory.createInvestigationType(this.laboratoryFactory.createLaboratory());
        Product product = (Product)((TestServiceProductBuilder)this.productFactory.newService().addTests(new Entity[]{this.laboratoryFactory.createTest(investigationType)})).build();
        EditDialog dialog = workflow.addInvoiceItem(this.patient, product);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        workflow.fireDialogButton(PopupDialog.class, Messages.get((String)"customer.charge.investigation.submit.title"), "skip");
        workflow.confirmPostInvoice();
        workflow.fireDialogButton(ErrorDialog.class, "ok");
        workflow.fireDialogButton(CustomerChargeActEditDialog.class, "cancel");
        workflow.checkComplete(false);
        workflow.checkContext(this.context, null, null, null, null);
        Assert.assertNull((Object)workflow.getPayment());
    }

    @Test
    public void testAppointmentChangedByAnotherUser() {
        Act appointment = this.createAppointment();
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.start();
        appointment = (Act)this.get((IMObject)appointment);
        appointment.setDescription("set to force update");
        this.save((IMObject)appointment);
        workflow.runToCompletion(this.patient, this.clinician, this.till);
        workflow.checkComplete(true);
        workflow.checkContext(this.context, this.customer, this.patient, this.till, this.clinician);
    }

    @Test
    public void testAppointmentDeletedByAnotherUser() {
        Act appointment = this.createAppointment();
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.start();
        this.remove((IMObject)appointment);
        workflow.runToCompletion(this.patient, this.clinician, this.till);
        workflow.checkVisitsCompleted();
        workflow.checkContext(this.context, this.customer, this.patient, this.till, this.clinician);
    }

    @Test
    public void testTaskChangedByAnotherUser() {
        Act task = this.createTask();
        Act appointment = (Act)this.newAppointment().task(task).build();
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(task, this.getPractice(), this.context);
        workflow.start();
        task = (Act)this.get((IMObject)task);
        task.setDescription("set to force update");
        this.save((IMObject)task);
        workflow.runToCompletion(this.patient, this.clinician, this.till);
        workflow.checkComplete(true);
        workflow.checkAppointmentComplete(appointment);
        workflow.checkContext(this.context, this.customer, this.patient, this.till, this.clinician);
    }

    @Test
    public void testTaskDeletedByAnotherUser() {
        Act task = this.createTask();
        Act appointment = (Act)this.newAppointment().task(task).build();
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(task, this.getPractice(), this.context);
        workflow.start();
        this.remove((IMObject)task);
        workflow.runToCompletion(this.patient, this.clinician, this.till);
        workflow.checkVisitsCompleted();
        workflow.checkAppointmentComplete(appointment);
        workflow.checkContext(this.context, this.customer, this.patient, this.till, this.clinician);
    }

    private void checkPromptForClaim(CheckOutWorkflow.ClaimAtCheckout claim) {
        Party insurer = InsuranceTestHelper.createInsurer();
        Act policy = InsuranceTestHelper.createPolicy((Party)this.customer, (Party)this.patient, (Party)insurer, (String)"APOLICY");
        this.save((IMObject)policy);
        IMObjectBean bean = this.getBean((IMObject)this.getPractice());
        bean.setValue("claimAtCheckout", (Object)claim.toString());
        bean.save();
        Act appointment = this.createAppointment();
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.start();
        BigDecimal amount = workflow.addInvoice(this.patient, false);
        workflow.confirmPostInvoice();
        workflow.checkInvoice("POSTED", amount, this.clinician);
        if (claim == CheckOutWorkflow.ClaimAtCheckout.GAP_CLAIM || claim == CheckOutWorkflow.ClaimAtCheckout.ALL) {
            workflow.confirm("Gap Claim", "no");
        }
        workflow.confirmPayment();
        workflow.addPayment(this.till);
        workflow.checkPayment("POSTED", amount);
        if (claim == CheckOutWorkflow.ClaimAtCheckout.STANDARD_CLAIM || claim == CheckOutWorkflow.ClaimAtCheckout.ALL) {
            workflow.confirm("Claim", "no");
        }
        workflow.print();
        workflow.checkComplete(true);
        workflow.checkContext(this.context, this.customer, this.patient, this.till, this.clinician);
    }

    private void checkUseLoggedInClinician(boolean enabled, User user, User appointmentClinician, User expectedClinician) {
        this.context.setUser(user);
        this.context.setClinician(this.clinician);
        this.practiceFactory.updatePractice(this.getPractice()).useLoggedInClinician(enabled).build();
        Act appointment = this.createAppointment(appointmentClinician);
        this.checkWorkflow(appointment, expectedClinician);
    }

    private CheckoutWorkflowRunner checkWorkflow(Act act, User clinician) {
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(act, this.getPractice(), this.context);
        workflow.start();
        BigDecimal amount = workflow.addInvoice(this.patient, false);
        workflow.confirmPostInvoice();
        workflow.checkInvoice("POSTED", amount, clinician);
        workflow.confirmPayment();
        workflow.addPayment(this.till);
        workflow.checkPayment("POSTED", amount);
        workflow.print();
        workflow.checkComplete(true);
        workflow.checkContext(this.context, this.customer, this.patient, this.till, clinician);
        return workflow;
    }

    private void checkCancelInvoice(boolean save, boolean userClose) {
        this.context.setClinician(this.clinician);
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(this.createAppointment(), this.getPractice(), this.context);
        workflow.start();
        BigDecimal fixedPrice = new BigDecimal("18.18");
        EditDialog dialog = workflow.addInvoiceItem(this.patient, fixedPrice);
        if (save) {
            EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"apply");
        }
        workflow.addInvoiceItem(this.patient, fixedPrice);
        EchoTestHelper.cancelDialog((PopupDialog)dialog, (boolean)userClose);
        if (save) {
            BigDecimal fixedPriceIncTax = BigDecimal.valueOf(20L);
            workflow.checkInvoice("IN_PROGRESS", fixedPriceIncTax, this.clinician);
        } else {
            FinancialAct invoice = workflow.getInvoice();
            Assert.assertNotNull((Object)invoice);
            Assert.assertTrue((boolean)invoice.isNew());
        }
        workflow.checkComplete(false);
        workflow.checkContext(this.context, null, null, null, this.clinician);
        Assert.assertNull((Object)workflow.getPayment());
    }

    private void checkCancelFinaliseInvoice(boolean userClose) {
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(this.createAppointment(), this.getPractice(), this.context);
        workflow.start();
        BigDecimal amount = workflow.addInvoice(this.patient, false);
        String id = userClose ? null : "cancel";
        workflow.confirm(id);
        workflow.checkComplete(false);
        workflow.checkContext(this.context, null, null, null, null);
        workflow.checkInvoice("IN_PROGRESS", amount, this.clinician);
        Assert.assertNull((Object)workflow.getPayment());
    }

    private void checkCancelPaymentConfirmation(boolean userClose) {
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(this.createAppointment(), this.getPractice(), this.context);
        workflow.start();
        BigDecimal amount = workflow.addInvoice(this.patient, true);
        String id = userClose ? null : "cancel";
        workflow.confirm(id);
        workflow.checkComplete(false);
        workflow.checkContext(this.context, null, null, null, null);
        workflow.checkInvoice("POSTED", amount, this.clinician);
        Assert.assertNull((Object)workflow.getPayment());
    }

    private void checkCancelPayment(boolean userClose) {
        CheckoutWorkflowRunner workflow = new CheckoutWorkflowRunner(this.createAppointment(), this.getPractice(), this.context);
        workflow.start();
        BigDecimal amount = workflow.addInvoice(this.patient, true);
        workflow.confirm("yes");
        EditDialog dialog = workflow.addPaymentItem(this.till);
        EchoTestHelper.cancelDialog((PopupDialog)dialog, (boolean)userClose);
        workflow.checkComplete(false);
        workflow.checkContext(this.context, null, null, null, null);
        workflow.checkInvoice("POSTED", amount, this.clinician);
        FinancialAct payment = workflow.getPayment();
        Assert.assertNotNull((Object)payment);
        Assert.assertTrue((boolean)payment.isNew());
    }

    private Act createAppointment() {
        return this.createAppointment(this.clinician);
    }

    private Act createAppointment(User clinician) {
        return (Act)((TestAppointmentBuilder)this.newAppointment().clinician(clinician)).build();
    }

    private TestAppointmentBuilder newAppointment() {
        return (TestAppointmentBuilder)this.newAppointment(new Date(), this.customer, this.patient, this.clinician, this.context.getLocation()).status("IN_PROGRESS");
    }

    private Act createTask() {
        Entity workList = this.schedulingFactory.createWorkList();
        return (Act)((TestTaskBuilder)((TestTaskBuilder)((TestTaskBuilder)((TestTaskBuilder)((TestTaskBuilder)this.schedulingFactory.newTask().status("IN_PROGRESS")).startTime(new Date())).taskType(this.schedulingFactory.createTaskType()).customer(this.customer)).patient(this.patient)).clinician(this.clinician)).workList(workList).build();
    }

    private Act createEvent(Act appointment) {
        Act event = (Act)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().patient(this.patient)).location(this.context.getLocation())).build();
        this.schedulingFactory.updateAppointment(appointment).event(event).build();
        return event;
    }
}

