/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatExpressionTest;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatOnDaysEditor;

public class RepeatOnDaysEditorTestCase
extends AbstractRepeatExpressionTest {
    @Test
    public void testCreateWithStartTime() {
        Date startTime = TestHelper.getDatetime((String)"2015-01-08 09:30:00");
        RepeatOnDaysEditor editor = new RepeatOnDaysEditor(startTime);
        RepeatExpression expression = editor.getExpression();
        Assert.assertTrue((boolean)(expression instanceof CronRepeatExpression));
        CronRepeatExpression cron = (CronRepeatExpression)expression;
        Assert.assertEquals((Object)"9", (Object)cron.getHours());
        Assert.assertEquals((Object)"30", (Object)cron.getMinutes());
        Assert.assertTrue((boolean)cron.getDayOfMonth().isAll());
        Assert.assertTrue((boolean)cron.getMonth().isAll());
        Assert.assertEquals((long)5L, (long)cron.getDayOfWeek().day());
        Assert.assertTrue((boolean)cron.getYear().isAll());
        Assert.assertEquals((Object)"0 30 9 ? * THU *", (Object)cron.getExpression());
        Date date1 = this.checkNext(startTime, (RepeatExpression)cron, "2015-01-15 09:30:00");
        Date date2 = this.checkNext(date1, (RepeatExpression)cron, "2015-01-22 09:30:00");
        this.checkNext(date2, (RepeatExpression)cron, "2015-01-29 09:30:00");
    }

    @Test
    public void testCreateWithExpression() {
        CronRepeatExpression cron = this.parse("0 30 9 ? * THU *");
        Assert.assertTrue((boolean)RepeatOnDaysEditor.supports((CronRepeatExpression)cron));
        RepeatOnDaysEditor editor = new RepeatOnDaysEditor(cron);
        Date startTime = TestHelper.getDatetime((String)"2015-01-08 09:30:00");
        editor.setStartTime(startTime);
        RepeatExpression expression = editor.getExpression();
        Assert.assertEquals((Object)cron, (Object)expression);
        Date date1 = this.checkNext(startTime, (RepeatExpression)cron, "2015-01-15 09:30:00");
        Date date2 = this.checkNext(date1, (RepeatExpression)cron, "2015-01-22 09:30:00");
        this.checkNext(date2, (RepeatExpression)cron, "2015-01-29 09:30:00");
    }

    @Test
    public void testSupports() {
        Assert.assertTrue((boolean)RepeatOnDaysEditor.supports((CronRepeatExpression)this.parse("0 0 10 ? * * *")));
        Assert.assertTrue((boolean)RepeatOnDaysEditor.supports((CronRepeatExpression)this.parse("0 0 10 ? * SUN,MON,TUE,WED,THU,FRI,SAT *")));
        Assert.assertTrue((boolean)RepeatOnDaysEditor.supports((CronRepeatExpression)this.parse("0 0 10 ? * SUN-SAT *")));
        Assert.assertFalse((boolean)RepeatOnDaysEditor.supports((CronRepeatExpression)this.parse("0 30 9 2 1 ? 2015/1")));
        Assert.assertFalse((boolean)RepeatOnDaysEditor.supports((CronRepeatExpression)this.parse("0 30 9 8,10 1/2 ? *")));
        Assert.assertFalse((boolean)RepeatOnDaysEditor.supports((CronRepeatExpression)this.parse("0 30 9 ? 1 THU#2 2015/1")));
    }
}

