/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractScheduleEventSeriesTest;
import org.openvpms.web.workspace.workflow.appointment.repeat.Repeats;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;

public abstract class AbstractCalendarEventSeriesTest
extends AbstractScheduleEventSeriesTest {
    private Party schedule;
    private Entity appointmentType;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.appointmentType = ScheduleTestHelper.createAppointmentType();
        this.schedule = ScheduleTestHelper.createSchedule((int)15, (String)DateUnits.MINUTES.toString(), (int)1, (Entity)this.appointmentType, (Party)TestHelper.createLocation());
    }

    @Test
    public void testChangeSchedule() {
        Act event = this.createEvent();
        ScheduleEventSeries series = this.createSeries(event, Repeats.yearly(), Repeats.times((int)2));
        this.checkSeries(series, event, 1, DateUnits.YEARS, 3);
        Party schedule2 = ScheduleTestHelper.createSchedule((int)15, (String)DateUnits.MINUTES.toString(), (int)1, (Entity)this.appointmentType, (Party)TestHelper.createLocation());
        IMObjectBean bean = this.getBean((IMObject)event);
        bean.setTarget("schedule", (IMObject)schedule2);
        this.checkSave(series);
        Assert.assertEquals((Object)schedule2, (Object)bean.getTarget("schedule"));
        this.checkSeries(series, event, 1, DateUnits.YEARS, 3);
    }

    @Override
    protected Act createEvent(Date startTime, Date endTime) {
        return this.createEvent(startTime, endTime, (Entity)this.schedule, this.appointmentType);
    }

    protected abstract Act createEvent(Date var1, Date var2, Entity var3, Entity var4);

    protected Entity getSchedule() {
        return this.schedule;
    }
}

