/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Table;
import org.junit.Assert;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.workflow.ConfirmationTask;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.LocalTask;
import org.openvpms.web.component.workflow.SelectIMObjectTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskListener;
import org.openvpms.web.component.workflow.WorkflowImpl;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.patient.visit.VisitEditorDialog;
import org.openvpms.web.workspace.workflow.EditVisitTask;
import org.openvpms.web.workspace.workflow.TaskTracker;

public class WorkflowRunner<T extends WorkflowImpl> {
    private final TaskTracker tracker = new TaskTracker();
    private T workflow;

    public Task getTask() {
        Task task = this.tracker.getCurrent();
        if (task instanceof LocalTask) {
            task = ((LocalTask)task).getTask();
        }
        return task;
    }

    public T getWorkflow() {
        return this.workflow;
    }

    public TaskContext getContext() {
        return this.getWorkflow().getContext();
    }

    public void start() {
        this.workflow.start();
    }

    public <T extends IMObject> BrowserDialog<T> getSelectionDialog() {
        Task current = this.getTask();
        Assert.assertTrue((boolean)(current instanceof SelectIMObjectTask));
        return ((SelectIMObjectTask)current).getBrowserDialog();
    }

    public void confirm(String button) {
        this.confirm(null, button);
    }

    public void confirm(String title, String button) {
        Task current = this.tracker.getCurrent();
        Assert.assertTrue((boolean)(current instanceof ConfirmationTask));
        ConfirmationTask task = (ConfirmationTask)current;
        if (title != null) {
            Assert.assertEquals((Object)title, (Object)task.getConfirmationDialog().getTitle());
        }
        ConfirmationDialog dialog = task.getConfirmationDialog();
        if (button != null) {
            EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)button);
        } else {
            dialog.userClose();
        }
    }

    public EditDialog getEditDialog() {
        EditIMObjectTask edit = this.getEditTask();
        return edit.getEditDialog();
    }

    public EditIMObjectTask getEditTask() {
        Task current = this.getTask();
        Assert.assertTrue((boolean)(current instanceof EditIMObjectTask));
        return (EditIMObjectTask)current;
    }

    public VisitEditorDialog editVisit() {
        Task current = this.getTask();
        Assert.assertTrue((boolean)(current instanceof EditVisitTask));
        EditVisitTask edit = (EditVisitTask)current;
        return edit.getVisitDialog();
    }

    public void fireSelection(Browser<Party> browser, Party object) {
        browser.setSelected((Object)object);
        Table table = (Table)EchoTestHelper.findComponent((Component)browser.getComponent(), Table.class);
        Assert.assertNotNull((Object)table);
        table.processInput("action", null);
    }

    public <T extends PopupDialog> T findDialog(Class<T> type) {
        return (T)((PopupDialog)EchoTestHelper.getWindowPane(type));
    }

    public void fireDialogButton(PopupDialog dialog, String buttonId) {
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)buttonId);
    }

    public void fireDialogButton(Class<? extends PopupDialog> type, String buttonId) {
        this.fireDialogButton(type, null, buttonId);
    }

    public void fireDialogButton(Class<? extends PopupDialog> type, String title, String buttonId) {
        PopupDialog dialog = this.findDialog(type);
        if (title != null) {
            Assert.assertEquals((Object)title, (Object)dialog.getTitle());
        }
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)buttonId);
    }

    protected void setWorkflow(T workflow) {
        this.workflow = workflow;
        workflow.addTaskListener((TaskListener)this.tracker);
    }

    protected <T extends IMObject> T get(T object) {
        return (T)IMObjectHelper.reload(object);
    }
}

