/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.till;

import java.math.BigDecimal;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ListBox;
import nextapp.echo2.app.button.AbstractButton;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.finance.deposit.DepositTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.domain.im.security.ArchetypeAwareGrantedAuthority;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.edit.payment.PaymentItemEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.SelectionDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.account.ReverseConfirmationDialog;
import org.openvpms.web.workspace.reporting.till.ClearTillDialog;
import org.openvpms.web.workspace.reporting.till.StartClearTillDialog;
import org.openvpms.web.workspace.reporting.till.TillBalanceAdjustmentEditor;
import org.openvpms.web.workspace.reporting.till.TillCRUDWindow;
import org.openvpms.web.workspace.reporting.till.TillPaymentEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class TillCRUDWindowTestCase
extends AbstractAppTest {
    private Entity till;
    private Party customer;
    @Autowired
    private TestUserFactory userFactory;

    @Before
    public void setUp() {
        super.setUp();
        this.customer = TestHelper.createCustomer();
        this.till = TestHelper.createTill();
    }

    @Test
    public void testCreatePayment() {
        this.checkCreatePaymentRefund("act.customerAccountPayment");
    }

    @Test
    public void testCreateRefund() {
        this.checkCreatePaymentRefund("act.customerAccountRefund");
    }

    @Test
    public void testUsersCannotEditPayments() {
        User user = TestHelper.createUser((boolean)false);
        this.checkCanEditPayment(false, user);
    }

    @Test
    public void testAdminUsersCanEditPayments() {
        User admin = TestHelper.createAdministrator((boolean)false);
        this.checkCanEditPayment(true, admin);
        ArchetypeAwareGrantedAuthority createTBA = this.userFactory.createAuthority("create", "act.tillBalanceAdjustment");
        ArchetypeAwareGrantedAuthority saveTBA = this.userFactory.createAuthority("save", "act.tillBalanceAdjustment");
        User user = (User)this.userFactory.newUser().addRoles(new SecurityRole[]{this.userFactory.createRole(new ArchetypeAwareGrantedAuthority[]{createTBA, saveTBA})}).build();
        this.checkCanEditPayment(true, user);
    }

    @Test
    public void testCannotEditRefund() {
        FinancialAct refund1 = FinancialTestHelper.createRefund((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)refund1);
        this.checkCannotEdit(refund1, TestHelper.createUser((boolean)false));
        FinancialAct refund2 = FinancialTestHelper.createRefund((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)refund2);
        this.checkCannotEdit(refund2, TestHelper.createAdministrator((boolean)false));
    }

    @Test
    public void testEditPaymentForClearedTill() {
        LocalContext context = new LocalContext();
        context.setUser(TestHelper.createAdministrator((boolean)false));
        TestTillCRUDWindow window = new TestTillCRUDWindow((Context)context);
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)payment);
        FinancialAct balance = this.getTillBalance(payment);
        Assert.assertEquals((Object)"UNCLEARED", (Object)balance.getStatus());
        window.setObject(balance);
        window.onChildActSelected(payment);
        window.edit();
        EditDialog dialog1 = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog1);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog1, (String)"ok");
        Assert.assertNull((Object)EchoTestHelper.findEditDialog());
        balance.setStatus("IN_PROGRESS");
        this.save((IMObject)balance);
        window.onChildActSelected(payment);
        window.edit();
        EditDialog dialog2 = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog2);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog2, (String)"ok");
        Assert.assertNull((Object)EchoTestHelper.findEditDialog());
        balance.setStatus("CLEARED");
        this.save((IMObject)balance);
        window.onChildActSelected(payment);
        window.edit();
        Assert.assertNull((Object)EchoTestHelper.findEditDialog());
        ErrorDialog errorDialog = (ErrorDialog)EchoTestHelper.getWindowPane(ErrorDialog.class);
        Assert.assertEquals((Object)"This payment cannot be edited as it linked to a Cleared Till Balance", (Object)errorDialog.getMessage());
    }

    @Test
    public void testCreateAdjustment() {
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)payment);
        FinancialAct tillBalance = this.getTillBalance(payment);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        LocalContext context = new LocalContext();
        context.setUser(TestHelper.createUser((boolean)false));
        TestTillCRUDWindow window = new TestTillCRUDWindow((Context)context);
        this.checkButton(window, "button.adjust", false);
        window.setObject(tillBalance);
        this.checkButton(window, "button.adjust", true);
        window.onAdjust();
        EditDialog dialog1 = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog1);
        Assert.assertTrue((boolean)(dialog1.getEditor() instanceof TillBalanceAdjustmentEditor));
        TillBalanceAdjustmentEditor editor = (TillBalanceAdjustmentEditor)dialog1.getEditor();
        editor.setAmount(BigDecimal.TEN);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog1, (String)"ok");
        tillBalance = (FinancialAct)this.get((IMObject)tillBalance);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        this.checkEquals(BigDecimal.ZERO, tillBalance.getTotal());
        tillBalance.setStatus("IN_PROGRESS");
        this.save((IMObject)tillBalance);
        window.setObject(tillBalance);
        this.checkButton(window, "button.adjust", true);
        window.onAdjust();
        EditDialog dialog2 = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog2);
        Assert.assertTrue((boolean)(dialog2.getEditor() instanceof TillBalanceAdjustmentEditor));
        TillBalanceAdjustmentEditor editor2 = (TillBalanceAdjustmentEditor)dialog2.getEditor();
        editor2.setAmount(BigDecimal.TEN);
        editor2.setCredit(true);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog2, (String)"ok");
        tillBalance = (FinancialAct)this.get((IMObject)tillBalance);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)tillBalance.getStatus());
        this.checkEquals(BigDecimal.TEN, tillBalance.getTotal());
        tillBalance.setStatus("CLEARED");
        this.save((IMObject)tillBalance);
        window.setObject(tillBalance);
        this.checkButton(window, "button.adjust", false);
    }

    @Test
    public void testEditAdjustment() {
        LocalContext context = new LocalContext();
        context.setUser(TestHelper.createUser((boolean)false));
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)payment);
        FinancialAct tillBalance = this.getTillBalance(payment);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        this.checkEquals(BigDecimal.TEN, tillBalance.getTotal());
        FinancialAct adjustment = this.createAdjustment(tillBalance, (Context)context);
        tillBalance = (FinancialAct)this.get((IMObject)tillBalance);
        this.checkEquals(BigDecimal.ZERO, tillBalance.getTotal());
        TestTillCRUDWindow window = new TestTillCRUDWindow((Context)context);
        this.checkButton(window, "button.edit", false);
        window.setObject(tillBalance);
        this.checkButton(window, "button.edit", false);
        window.onChildActSelected(adjustment);
        this.checkButton(window, "button.edit", true);
        window.edit();
        EditDialog dialog = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog);
        Assert.assertTrue((boolean)(dialog.getEditor() instanceof TillBalanceAdjustmentEditor));
        TillBalanceAdjustmentEditor editor2 = (TillBalanceAdjustmentEditor)dialog.getEditor();
        editor2.setCredit(true);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        tillBalance = (FinancialAct)this.get((IMObject)tillBalance);
        this.checkEquals(BigDecimal.valueOf(20L), tillBalance.getTotal());
        tillBalance.setStatus("IN_PROGRESS");
        this.save((IMObject)tillBalance);
        window.setObject(tillBalance);
        window.onChildActSelected(adjustment);
        this.checkButton(window, "button.edit", false);
        tillBalance.setStatus("CLEARED");
        this.save((IMObject)tillBalance);
        window.setObject(tillBalance);
        window.onChildActSelected(adjustment);
        this.checkButton(window, "button.edit", false);
    }

    @Test
    public void testReversePayment() {
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)payment);
        this.checkReverse(payment);
    }

    @Test
    public void testReverseRefund() {
        FinancialAct refund = FinancialTestHelper.createRefund((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)refund);
        this.checkReverse(refund);
    }

    @Test
    public void testCannotReverseAdjustment() {
        LocalContext context = new LocalContext();
        context.setUser(TestHelper.createUser((boolean)false));
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)payment);
        FinancialAct tillBalance = this.getTillBalance(payment);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        FinancialAct adjustment = this.createAdjustment(tillBalance, (Context)context);
        tillBalance = (FinancialAct)this.get((IMObject)tillBalance);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        this.checkEquals(BigDecimal.ZERO, tillBalance.getTotal());
        TestTillCRUDWindow window = new TestTillCRUDWindow((Context)context);
        this.checkButton(window, "button.reverse", false);
        window.setObject(tillBalance);
        this.checkButton(window, "button.reverse", false);
        window.onChildActSelected(adjustment);
        this.checkButton(window, "button.reverse", false);
        tillBalance.setStatus("IN_PROGRESS");
        this.save((IMObject)tillBalance);
        window.setObject(tillBalance);
        window.onChildActSelected(adjustment);
        this.checkButton(window, "button.reverse", false);
        tillBalance.setStatus("CLEARED");
        this.save((IMObject)tillBalance);
        window.setObject(tillBalance);
        window.onChildActSelected(adjustment);
        this.checkButton(window, "button.reverse", false);
    }

    @Test
    public void testTransferPayment() {
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)payment);
        this.checkTransfer(payment);
    }

    @Test
    public void testTransferRefund() {
        FinancialAct refund = FinancialTestHelper.createRefund((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)refund);
        this.checkTransfer(refund);
    }

    @Test
    public void testCannotTransferAdjustment() {
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)payment);
        LocalContext context = new LocalContext();
        context.setUser(TestHelper.createUser((boolean)false));
        FinancialAct tillBalance = this.getTillBalance(payment);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        this.checkEquals(BigDecimal.TEN, tillBalance.getTotal());
        FinancialAct adjustment = this.createAdjustment(tillBalance, (Context)context);
        TestTillCRUDWindow window = new TestTillCRUDWindow((Context)context);
        this.checkButton(window, "button.transfer", false);
        window.setObject(tillBalance);
        this.checkButton(window, "button.transfer", false);
        window.onChildActSelected(adjustment);
        this.checkButton(window, "button.transfer", false);
        tillBalance = (FinancialAct)this.get((IMObject)tillBalance);
        tillBalance.setStatus("IN_PROGRESS");
        this.save((IMObject)tillBalance);
        window.setObject(tillBalance);
        this.checkButton(window, "button.transfer", false);
        window.onChildActSelected(adjustment);
        this.checkButton(window, "button.transfer", false);
        tillBalance.setStatus("CLEARED");
        this.save((IMObject)tillBalance);
        window.setObject(tillBalance);
        this.checkButton(window, "button.transfer", false);
        window.onChildActSelected(tillBalance);
        this.checkButton(window, "button.transfer", false);
    }

    @Test
    public void testClearForUnclearedTillBalance() {
        this.checkClear("UNCLEARED");
    }

    @Test
    public void testClearForInProgressTillBalance() {
        this.checkClear("IN_PROGRESS");
    }

    @Test
    public void testClearCannotBeRunForClearedTillBalance() {
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)payment);
        FinancialAct tillBalance = this.getTillBalance(payment);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        tillBalance.setStatus("CLEARED");
        this.save((IMObject)tillBalance);
        LocalContext context = new LocalContext();
        context.setUser(TestHelper.createUser((boolean)false));
        TestTillCRUDWindow window = new TestTillCRUDWindow((Context)context);
        this.checkButton(window, "button.clear", false);
        window.setObject(tillBalance);
        this.checkButton(window, "button.clear", false);
    }

    @Test
    public void testStartClear() {
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)payment);
        FinancialAct tillBalance = this.getTillBalance(payment);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        LocalContext context = new LocalContext();
        context.setUser(TestHelper.createUser((boolean)false));
        TestTillCRUDWindow window = new TestTillCRUDWindow((Context)context);
        this.checkButton(window, "button.startClear", false);
        window.setObject(tillBalance);
        this.checkButton(window, "button.startClear", true);
        window.onStartClear(tillBalance);
        StartClearTillDialog dialog = (StartClearTillDialog)EchoTestHelper.getWindowPane(StartClearTillDialog.class);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        tillBalance = (FinancialAct)this.get((IMObject)tillBalance);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)tillBalance.getStatus());
        this.checkButton(window, "button.startClear", false);
        window.onStartClear(tillBalance);
        ErrorDialog errorDialog = (ErrorDialog)EchoTestHelper.getWindowPane(ErrorDialog.class);
        Assert.assertEquals((Object)"Cannot clear till. Clear the balance with Clear In Progress status first.", (Object)errorDialog.getMessage());
        tillBalance.setStatus("CLEARED");
        this.save((IMObject)tillBalance);
        window.setObject(tillBalance);
        this.checkButton(window, "button.startClear", false);
        window.onStartClear(tillBalance);
        ErrorDialog errorDialog2 = (ErrorDialog)EchoTestHelper.getWindowPane(ErrorDialog.class);
        Assert.assertEquals((Object)"Cannot clear till. Clear the balance with Clear In Progress status first.", (Object)errorDialog2.getMessage());
    }

    private FinancialAct createAdjustment(FinancialAct tillBalance, Context context) {
        FinancialAct adjustment = (FinancialAct)this.create("act.tillBalanceAdjustment", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)adjustment);
        bean.setTarget("till", (IMObject)this.till);
        TillBalanceAdjustmentEditor editor1 = new TillBalanceAdjustmentEditor(adjustment, tillBalance, (LayoutContext)new DefaultLayoutContext(context, new HelpContext("foo", null)));
        editor1.getComponent();
        editor1.setAmount(BigDecimal.TEN);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        return adjustment;
    }

    private void checkTransfer(FinancialAct act) {
        LocalContext context = new LocalContext();
        context.setUser(TestHelper.createUser((boolean)false));
        BigDecimal expected = act.isCredit() ? BigDecimal.TEN : BigDecimal.TEN.negate();
        FinancialAct tillBalance = this.getTillBalance(act);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        this.checkEquals(expected, tillBalance.getTotal());
        TestTillCRUDWindow window = new TestTillCRUDWindow((Context)context);
        this.checkButton(window, "button.transfer", false);
        window.setObject(tillBalance);
        this.checkButton(window, "button.transfer", false);
        window.onChildActSelected(act);
        this.checkButton(window, "button.transfer", true);
        Entity till2 = TestHelper.createTill();
        window.onTransfer();
        ListBox list = this.getSelectionDialogList();
        EchoTestHelper.click((ListBox)list, (Object)till2);
        tillBalance = (FinancialAct)this.get((IMObject)tillBalance);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        this.checkEquals(BigDecimal.ZERO, tillBalance.getTotal());
        FinancialAct tillBalance2 = this.getTillBalance(act);
        Assert.assertNotEquals((Object)tillBalance, (Object)tillBalance2);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance2.getStatus());
        this.checkEquals(expected, tillBalance2.getTotal());
        tillBalance2.setStatus("IN_PROGRESS");
        this.save((IMObject)tillBalance2);
        window.setObject(tillBalance2);
        this.checkButton(window, "button.transfer", false);
        window.onChildActSelected(act);
        this.checkButton(window, "button.transfer", false);
        tillBalance2.setStatus("CLEARED");
        this.save((IMObject)tillBalance2);
        window.setObject(tillBalance2);
        this.checkButton(window, "button.transfer", false);
        window.onChildActSelected(act);
        this.checkButton(window, "button.transfer", false);
    }

    private void checkReverse(FinancialAct act) {
        LocalContext context = new LocalContext();
        context.setUser(TestHelper.createUser((boolean)false));
        context.setPractice((Party)this.create("party.organisationPractice", Party.class));
        FinancialAct tillBalance = this.getTillBalance(act);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        BigDecimal expected = act.isCredit() ? BigDecimal.TEN : BigDecimal.TEN.negate();
        this.checkEquals(expected, tillBalance.getTotal());
        TestTillCRUDWindow window = new TestTillCRUDWindow((Context)context);
        this.checkButton(window, "button.reverse", false);
        window.setObject(tillBalance);
        this.checkButton(window, "button.reverse", false);
        window.onChildActSelected(act);
        this.checkButton(window, "button.reverse", false);
        tillBalance.setStatus("IN_PROGRESS");
        this.save((IMObject)tillBalance);
        window.setObject(tillBalance);
        this.checkButton(window, "button.reverse", false);
        window.onChildActSelected(act);
        this.checkButton(window, "button.reverse", true);
        window.onReverse();
        ReverseConfirmationDialog dialog = (ReverseConfirmationDialog)EchoTestHelper.getWindowPane(ReverseConfirmationDialog.class);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        tillBalance = (FinancialAct)this.get((IMObject)tillBalance);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)tillBalance.getStatus());
        this.checkEquals(BigDecimal.ZERO, tillBalance.getTotal());
        act = (FinancialAct)this.get((IMObject)act);
        FinancialAct reversal = (FinancialAct)this.getBean((IMObject)act).getTarget("reversal", FinancialAct.class);
        Assert.assertNotNull((Object)reversal);
        tillBalance.setStatus("CLEARED");
        this.save((IMObject)tillBalance);
        window.setObject(tillBalance);
        this.checkButton(window, "button.reverse", false);
        window.onChildActSelected(reversal);
        this.checkButton(window, "button.reverse", false);
    }

    private void checkCreatePaymentRefund(String archetype) {
        FinancialAct initial = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)initial);
        FinancialAct tillBalance = this.getTillBalance(initial);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        this.checkEquals(BigDecimal.TEN, tillBalance.getTotal());
        LocalContext context = new LocalContext();
        context.setUser(TestHelper.createUser((boolean)false));
        context.setCustomer(this.customer);
        TestTillCRUDWindow window = new TestTillCRUDWindow((Context)context);
        this.checkButton(window, "button.new", false);
        window.setObject(tillBalance);
        this.checkButton(window, "button.new", false);
        tillBalance.setStatus("IN_PROGRESS");
        this.save((IMObject)tillBalance);
        window.setObject(tillBalance);
        this.checkButton(window, "button.new", true);
        window.onNew();
        ListBox listBox = this.getSelectionDialogList();
        Assert.assertEquals((long)2L, (long)listBox.getModel().size());
        int index = archetype.equals("act.customerAccountPayment") ? 0 : 1;
        EchoTestHelper.click((ListBox)listBox, (int)index);
        EditDialog dialog = EchoTestHelper.findEditDialog();
        Assert.assertTrue((boolean)(dialog.getEditor() instanceof TillPaymentEditor));
        TillPaymentEditor editor = (TillPaymentEditor)dialog.getEditor();
        Assert.assertEquals((Object)archetype, (Object)editor.getObject().getArchetype());
        PaymentItemEditor item = editor.getUnsavedItem();
        Assert.assertNotNull((Object)item);
        item.getProperty("amount").setValue((Object)BigDecimal.TEN);
        FinancialAct act = (FinancialAct)dialog.getEditor().getObject();
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        act = (FinancialAct)this.get((IMObject)act);
        Assert.assertEquals((Object)"POSTED", (Object)act.getStatus());
        this.checkEquals(BigDecimal.TEN, act.getTotal());
        tillBalance = (FinancialAct)this.get((IMObject)tillBalance);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)tillBalance.getStatus());
        if (act.isA("act.customerAccountPayment")) {
            this.checkEquals(BigDecimal.valueOf(20L), tillBalance.getTotal());
        } else {
            this.checkEquals(BigDecimal.ZERO, tillBalance.getTotal());
        }
        tillBalance.setStatus("CLEARED");
        this.save((IMObject)tillBalance);
        window.setObject(tillBalance);
        this.checkButton(window, "button.new", false);
    }

    private ListBox getSelectionDialogList() {
        SelectionDialog selection = (SelectionDialog)EchoTestHelper.getWindowPane(SelectionDialog.class);
        ListBox listBox = (ListBox)EchoTestHelper.findComponent((Component)selection, ListBox.class);
        Assert.assertNotNull((Object)listBox);
        return listBox;
    }

    private void checkClear(String status) {
        Party location = TestHelper.createLocation();
        DepositTestHelper.createDepositAccount((Party)location);
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)payment);
        FinancialAct tillBalance = this.getTillBalance(payment);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        tillBalance.setStatus(status);
        this.save((IMObject)tillBalance);
        LocalContext context = new LocalContext();
        context.setUser(TestHelper.createUser((boolean)false));
        context.setLocation(location);
        TestTillCRUDWindow window = new TestTillCRUDWindow((Context)context);
        this.checkButton(window, "button.clear", false);
        window.setObject(tillBalance);
        this.checkButton(window, "button.clear", true);
        window.onClear(tillBalance);
        ClearTillDialog dialog = (ClearTillDialog)EchoTestHelper.getWindowPane(ClearTillDialog.class);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        tillBalance = (FinancialAct)this.get((IMObject)tillBalance);
        Assert.assertEquals((Object)"CLEARED", (Object)tillBalance.getStatus());
    }

    private void checkCannotEdit(FinancialAct object, User user) {
        FinancialAct tillBalance = this.getTillBalance(object);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        this.checkCanEdit(user, false, object, tillBalance);
        tillBalance.setStatus("IN_PROGRESS");
        this.save((IMObject)tillBalance);
        this.checkCanEdit(user, false, object, tillBalance);
        tillBalance.setStatus("CLEARED");
        this.save((IMObject)tillBalance);
        this.checkCanEdit(user, false, object, tillBalance);
    }

    private FinancialAct getTillBalance(FinancialAct act) {
        FinancialAct tillBalance = (FinancialAct)this.getBean((IMObject)act).getSource("tillBalance", FinancialAct.class);
        Assert.assertNotNull((Object)tillBalance);
        return tillBalance;
    }

    private void checkCanEditPayment(boolean edit, User user) {
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)this.customer, (Entity)this.till, (String)"POSTED");
        this.save((IMObject)payment);
        FinancialAct tillBalance = this.getTillBalance(payment);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        this.checkCanEdit(user, edit, payment, tillBalance);
        tillBalance.setStatus("IN_PROGRESS");
        this.save((IMObject)tillBalance);
        this.checkCanEdit(user, edit, payment, tillBalance);
        tillBalance.setStatus("CLEARED");
        this.save((IMObject)tillBalance);
        this.checkCanEdit(user, false, payment, tillBalance);
    }

    private void checkCanEdit(User user, boolean edit, FinancialAct object, FinancialAct tillBalance) {
        LocalContext context = new LocalContext();
        context.setUser(user);
        TestTillCRUDWindow window = new TestTillCRUDWindow((Context)context);
        window.setObject(tillBalance);
        this.checkButton(window, "button.edit", false);
        window.onChildActSelected(object);
        this.checkButton(window, "button.edit", edit);
    }

    private void checkButton(TestTillCRUDWindow window, String id, boolean enabled) {
        AbstractButton button = window.getButtons().getButton(id);
        Assert.assertNotNull((Object)button);
        Assert.assertEquals((Object)enabled, (Object)button.isEnabled());
    }

    private static class TestTillCRUDWindow
    extends TillCRUDWindow {
        public TestTillCRUDWindow(Context context) {
            super(context, new HelpContext("foo", null));
            this.getComponent();
        }

        public ButtonSet getButtons() {
            return super.getButtons();
        }

        public void onChildActSelected(FinancialAct child) {
            super.onChildActSelected(child);
        }
    }
}

