/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.till;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.finance.till.TillBalanceRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.workspace.reporting.till.TillBalanceUpdater;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TillBalanceUpdaterTestCase
extends ArchetypeServiceTest {
    @Autowired
    PlatformTransactionManager transactionManager;

    @Test
    public void testUpdateBalanceForPayment() {
        Entity till = TestHelper.createTill();
        FinancialAct balance = FinancialTestHelper.createTillBalance((Entity)till);
        balance.setStatus("IN_PROGRESS");
        this.save((IMObject)balance);
        Party customer = TestHelper.createCustomer();
        List payment = FinancialTestHelper.createPaymentCash((BigDecimal)BigDecimal.TEN, (Party)customer, (Entity)till, (String)"POSTED");
        this.checkUpdate(payment, balance, BigDecimal.TEN);
        TillBalanceRules rules = new TillBalanceRules(this.getArchetypeService());
        Assert.assertNull((Object)rules.getUnclearedBalance(till));
    }

    @Test
    public void testUpdateBalanceForAdjustment() {
        Entity till = TestHelper.createTill();
        FinancialAct balance = FinancialTestHelper.createTillBalance((Entity)till);
        balance.setStatus("IN_PROGRESS");
        this.save((IMObject)balance);
        FinancialAct act = (FinancialAct)this.create("act.tillBalanceAdjustment", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("credit", (Object)true);
        bean.setTarget("till", (IMObject)till);
        bean.setValue("amount", (Object)BigDecimal.TEN);
        this.checkUpdate(Collections.singletonList(act), balance, BigDecimal.TEN);
        bean.setValue("amount", (Object)BigDecimal.ONE);
        this.checkUpdate(Collections.singletonList(act), balance, BigDecimal.ONE);
        TillBalanceRules rules = new TillBalanceRules(this.getArchetypeService());
        Assert.assertNull((Object)rules.getUnclearedBalance(till));
    }

    private void checkUpdate(List<FinancialAct> acts, FinancialAct balance, BigDecimal expected) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute(status -> {
            TillBalanceUpdater updater = new TillBalanceUpdater((FinancialAct)acts.get(0), balance);
            Assert.assertTrue((boolean)updater.validate());
            updater.prepare();
            this.save(acts);
            updater.commit();
            return null;
        });
        FinancialAct balance2 = (FinancialAct)this.get((IMObject)balance);
        this.checkEquals(expected, balance2.getTotal());
    }
}

