/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.report;

import java.util.HashMap;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.print.locator.DocumentPrinterServiceLocator;
import org.openvpms.report.DocumentConverter;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.doc.DocumentTestHelper;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.reporting.report.SQLReportPrinter;
import org.springframework.beans.factory.annotation.Autowired;

public class SQLReportPrinterTestCase
extends AbstractAppTest {
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private DocumentHandlers handlers;
    @Autowired
    private DomainService domainService;

    @Test
    public void testContextFields() throws Exception {
        Context context = DocumentTestHelper.createReportContext();
        final Document document = this.documentFactory.createDocument("/sqlreport.jrxml");
        DocumentTemplate template = new DocumentTemplate((Entity)this.create("entity.documentTemplate", Entity.class), (ArchetypeService)this.getArchetypeService()){

            public boolean hasDocument() {
                return true;
            }

            public Document getDocument() {
                return document;
            }
        };
        ReportFactory factory = (ReportFactory)ServiceHelper.getBean(ReportFactory.class);
        FileNameFormatter formatter = (FileNameFormatter)ServiceHelper.getBean(FileNameFormatter.class);
        DataSource dataSource = (DataSource)ServiceHelper.getBean((String)"reportingDataSource", DataSource.class);
        DocumentPrinterServiceLocator printerLocator = (DocumentPrinterServiceLocator)Mockito.mock(DocumentPrinterServiceLocator.class);
        PrinterContext printerContext = new PrinterContext(printerLocator, this.getArchetypeService(), (DocumentConverter)Mockito.mock(DocumentConverter.class), this.handlers, this.domainService);
        SQLReportPrinter printer = new SQLReportPrinter(template, context, factory, formatter, dataSource, printerContext);
        Party customer = TestHelper.createCustomer((String)"Foo", (String)"Bar", (boolean)true);
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("customerId", customer.getId());
        printer.setParameters(parameters);
        Document csv = printer.getDocument("text/csv", false);
        String result = this.documentFactory.toString(csv).trim();
        Assert.assertEquals((Object)"Foo,Bar,Vets R Us,Main Clinic,Main Stock,\"Smith,J\",Fido,Vet Supplies,Acepromazine,Main Deposit,Main Till,Vet,User,Visit,Invoice,Appointment,Task", (Object)result);
    }
}

