/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.report;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.report.ParameterType;
import org.openvpms.web.workspace.reporting.report.ParameterEvaluator;

public class ParameterEvaluatorTestCase
extends ArchetypeServiceTest {
    @Test
    public void testEvaluator() {
        Party customer = TestHelper.createCustomer((String)"Foo", (String)"Bar", (boolean)false);
        Act appointment = (Act)this.create("act.customerAppointment", Act.class);
        appointment.setActivityStartTime(TestHelper.getDatetime((String)"2015-04-04 10:30:00"));
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("OpenVPMS.customer", customer);
        variables.put("OpenVPMS.appointment", appointment);
        variables.put("OpenVPMS.task", null);
        ParameterEvaluator evaluator = new ParameterEvaluator((ArchetypeService)this.getArchetypeService(), this.getLookupService());
        LinkedHashSet<ParameterType> set = new LinkedHashSet<ParameterType>();
        set.add(new ParameterType("firstName", String.class, null, (Object)"$OpenVPMS.customer.firstName"));
        set.add(new ParameterType("id", String.class, null, (Object)"$OpenVPMS.customer.id"));
        set.add(new ParameterType("startTime", String.class, null, (Object)"$OpenVPMS.appointment.startTime"));
        set.add(new ParameterType("lastName", String.class, null, true, (Object)"$OpenVPMS.customer.lastName"));
        set.add(new ParameterType("patient", String.class, null, (Object)"$OpenVPMS.patient.name"));
        set.add(new ParameterType("badtype", Long.class, null, (Object)"$OpenVPMS.customer.id"));
        set.add(new ParameterType("string", String.class, null, (Object)"ABC"));
        set.add(new ParameterType("long", Long.class, null, (Object)1L));
        set.add(new ParameterType("task", String.class, null, (Object)"$OpenVPMS.task.startTime"));
        Set evaluated = evaluator.evaluate(set, variables);
        this.check(evaluated, "firstName", "Foo");
        this.check(evaluated, "id", "-1");
        this.check(evaluated, "startTime", "2015-04-04 10:30:00.0");
        this.check(evaluated, "lastName", "$OpenVPMS.customer.lastName");
        this.check(evaluated, "patient", null);
        this.check(evaluated, "badtype", "$OpenVPMS.customer.id");
        this.check(evaluated, "string", "ABC");
        this.check(evaluated, "long", 1L);
        this.check(evaluated, "task", null);
        ParameterType[] types = evaluated.toArray(new ParameterType[evaluated.size()]);
        Assert.assertEquals((Object)"firstName", (Object)types[0].getName());
        Assert.assertEquals((Object)"task", (Object)types[types.length - 1].getName());
    }

    private void check(Set<ParameterType> types, String name, Object value) {
        ParameterType type = this.getParameter(types, name);
        Assert.assertEquals((Object)value, (Object)type.getDefaultValue());
    }

    private ParameterType getParameter(Set<ParameterType> types, String name) {
        for (ParameterType type : types) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        Assert.fail((String)("Parameter " + name + " not found"));
        return null;
    }
}

