/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderRule;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.party.TestPhoneContactBuilder;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.sms.exception.SMSException;
import org.openvpms.sms.internal.i18n.SMSMessages;
import org.openvpms.sms.internal.message.OutboundMessageBuilderImpl;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.sms.service.SMSService;
import org.openvpms.web.component.im.sms.SMSTemplateEvaluator;
import org.openvpms.web.component.service.SimpleSMSService;
import org.openvpms.web.workspace.reporting.reminder.AbstractPatientReminderProcessorTest;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;
import org.openvpms.web.workspace.reporting.reminder.ReminderSMSEvaluator;
import org.openvpms.web.workspace.reporting.reminder.ReminderSMSProcessor;
import org.openvpms.web.workspace.reporting.reminder.SMSReminders;
import org.springframework.beans.factory.annotation.Autowired;

public class ReminderSMSProcessorTestCase
extends AbstractPatientReminderProcessorTest<SMSReminders> {
    @Autowired
    private DomainService domainService;
    @Autowired
    private TestDocumentFactory documentFactory;
    private ReminderSMSProcessor processor;
    private SMSService smsService;

    public ReminderSMSProcessorTestCase() {
        super("contact.phoneNumber");
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Entity smsTemplate = this.reminderFactory.createSMSTemplate("XPATH", "concat($patient.name, ' is due for a vaccination at ', $location.name, '.', $nl, 'Please contact us on ', party:getTelephone($location), ' to make an appointment')");
        Entity documentTemplate = (Entity)this.reminderFactory.newVaccinationVaccinationReminderTemplate().smsTemplate(smsTemplate).build();
        this.reminderFactory.updateReminderType(this.reminderType).newCount().count(0).interval(0, DateUnits.WEEKS).template(documentTemplate).newRule().sms().sendTo(ReminderRule.SendTo.ANY).add().add().build();
        this.smsService = (SMSService)Mockito.mock(SMSService.class);
        Mockito.when((Object)this.smsService.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.smsService.getMaxParts()).thenReturn((Object)1);
        OutboundMessageBuilderImpl builder = new OutboundMessageBuilderImpl((ArchetypeService)this.getArchetypeService(), this.domainService);
        Mockito.when((Object)this.smsService.getOutboundMessageBuilder()).thenReturn((Object)builder);
        this.processor = this.createProcessor((Entity)this.newReminderConfiguration().build(false));
    }

    @Test
    public void testReminderContact() {
        Contact sms1 = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("1").sms().preferred()).purposes(new String[]{"REMINDER"})).build();
        Contact sms2 = this.contactFactory.newPhone().phone("2").sms().build();
        Contact sms3 = this.contactFactory.newPhone().phone("3").sms().build();
        this.customer.addContact(sms1);
        this.customer.addContact(sms2);
        this.customer.addContact(sms3);
        this.checkSend(null, "1", "Spot is due for a vaccination at Vets R Us.\nPlease contact us on 9123 4567 to make an appointment");
    }

    @Test
    public void testOverrideContact() {
        Contact sms1 = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("1").sms().preferred()).purposes(new String[]{"REMINDER"})).build();
        Contact sms2 = this.contactFactory.newPhone().phone("2").sms().build();
        this.customer.addContact(sms1);
        this.customer.addContact(sms2);
        this.checkSend(sms2, "2", "Spot is due for a vaccination at Vets R Us.\nPlease contact us on 9123 4567 to make an appointment");
    }

    @Test
    public void testCustomerGroupedReminder() {
        Party patient2 = this.patientFactory.createPatient(this.customer);
        Entity reminderType2 = this.reminderFactory.createReminderType("Checkup");
        Date tomorrow = DateRules.getTomorrow();
        Act item1 = this.createReminderItem(DateRules.getToday(), tomorrow);
        Act reminder1 = this.createReminder(tomorrow, this.patient, this.reminderType, item1);
        Act item2 = this.createReminderItem(DateRules.getToday(), tomorrow);
        Act reminder2 = this.createReminder(tomorrow, patient2, reminderType2, item2);
        Contact sms = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("1").sms().preferred()).purposes(new String[]{"REMINDER"})).build();
        this.customer.addContact(sms);
        Entity smsTemplate = this.reminderFactory.createSMSTemplate("XPATH", "concat('Hi ', $customer.firstName, ', your pets are due for ', list:sortNamesOf(., 'reminderType', ',', ' and '), '. Please contact us on ', party:getTelephone($location), ' to make an appointment')");
        Entity documentTemplate = (Entity)this.documentFactory.newTemplate().smsTemplate(smsTemplate).build();
        Entity config = (Entity)this.newReminderConfiguration().customerTemplate(documentTemplate).build();
        this.processor = this.createProcessor(config);
        ReminderEvent event1 = new ReminderEvent(reminder1, item1, this.patient, this.customer, sms);
        ReminderEvent event2 = new ReminderEvent(reminder2, item2, patient2, this.customer, sms);
        SMSReminders reminders = (SMSReminders)this.prepare(ReminderType.GroupBy.CUSTOMER, event1, event2);
        this.checkSendReminders(reminders, "1", "Hi J, your pets are due for Checkup and Vaccination. Please contact us on 9123 4567 to make an appointment");
    }

    @Test
    public void testPatientGroupedReminder() {
        Entity reminderType2 = this.reminderFactory.createReminderType("Checkup");
        Date tomorrow = DateRules.getTomorrow();
        Act item1 = this.createReminderItem(DateRules.getToday(), tomorrow);
        Act reminder1 = this.createReminder(tomorrow, this.patient, this.reminderType, item1);
        Act item2 = this.createReminderItem(DateRules.getToday(), tomorrow);
        Act reminder2 = this.createReminder(tomorrow, this.patient, reminderType2, item2);
        Contact sms = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("1").sms().preferred()).purposes(new String[]{"REMINDER"})).build();
        this.customer.addContact(sms);
        Entity smsTemplate = this.reminderFactory.createSMSTemplate("XPATH", "concat('Hi ', $customer.firstName, ', ', $patient.name, ' is due for ', list:sortNamesOf(., 'reminderType', ',', ' and '), '. Please contact us on ', party:getTelephone($location), ' to make an appointment')");
        Entity documentTemplate = (Entity)this.documentFactory.newTemplate().smsTemplate(smsTemplate).build();
        Entity config = (Entity)this.newReminderConfiguration().patientTemplate(documentTemplate).build();
        this.processor = this.createProcessor(config);
        ReminderEvent event1 = new ReminderEvent(reminder1, item1, this.patient, this.customer, sms);
        ReminderEvent event2 = new ReminderEvent(reminder2, item2, this.patient, this.customer, sms);
        SMSReminders reminders = (SMSReminders)this.prepare(ReminderType.GroupBy.PATIENT, event1, event2);
        this.checkSendReminders(reminders, "1", "Hi J, Spot is due for Checkup and Vaccination. Please contact us on 9123 4567 to make an appointment");
    }

    @Test
    public void testNoSMSContact() {
        Contact phone = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("1").sms(false).preferred()).purposes(new String[]{"REMINDER"})).build();
        this.customer.addContact(phone);
        this.checkNoContact();
    }

    @Test
    public void testMissingPhoneNumber() {
        Contact phone = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().phone(null).sms().preferred()).purposes(new String[]{"REMINDER"})).build();
        this.customer.addContact(phone);
        this.checkNoContact();
    }

    @Test
    public void testFailed() {
        Contact sms = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("1").sms().preferred()).purposes(new String[]{"REMINDER"})).build();
        this.customer.addContact(sms);
        Date tomorrow = DateRules.getTomorrow();
        Act item = this.createReminderItem(DateRules.getToday(), tomorrow);
        Act reminder = this.createReminder(tomorrow, this.reminderType, item);
        ((SMSService)Mockito.doThrow((Throwable[])new Throwable[]{new SMSException(SMSMessages.noMessageText())}).when((Object)this.smsService)).send((OutboundMessage)ArgumentMatchers.any());
        SMSReminders reminders = (SMSReminders)this.prepare(item, reminder, null);
        try {
            this.processor.process(reminders);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (OpenVPMSException expected) {
            Assert.assertTrue((boolean)this.processor.failed((PatientReminders)reminders, (Throwable)expected));
            this.checkItem((Act)this.get((IMObject)item), "ERROR", "SMS-0304: Message has no text");
        }
    }

    @Test
    public void testMissingReminderCount() {
        Contact phone = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("1").sms().preferred()).purposes(new String[]{"REMINDER"})).build();
        this.checkMissingReminderCount(phone);
    }

    @Test
    public void testMissingReminderCountTemplate() {
        Contact phone = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("1").sms().preferred()).purposes(new String[]{"REMINDER"})).build();
        this.checkMissingReminderCountTemplate(phone);
    }

    @Override
    protected PatientReminderProcessor<SMSReminders> getProcessor() {
        return this.processor;
    }

    @Override
    protected Act createReminderItem(Date send, Date dueDate) {
        return (Act)this.reminderFactory.newSMSReminder().sendDate(send).dueDate(dueDate).build();
    }

    private ReminderSMSProcessor createProcessor(Entity config) {
        IArchetypeService service = this.getArchetypeService();
        SMSTemplateEvaluator templateEvaluator = new SMSTemplateEvaluator((ArchetypeService)service, this.getLookupService(), null);
        ReminderSMSEvaluator evaluator = new ReminderSMSEvaluator(templateEvaluator);
        ReminderTypes reminderTypes = new ReminderTypes((ArchetypeService)service);
        SimpleSMSService simpleSMSService = new SimpleSMSService(this.smsService, (ArchetypeService)service);
        return new ReminderSMSProcessor(simpleSMSService, evaluator, reminderTypes, this.practice, this.reminderRules, this.patientRules, (ArchetypeService)service, new ReminderConfiguration((IMObject)config, (ArchetypeService)service), this.actionFactory);
    }

    private void checkSend(Contact contact, String to, String message) {
        SMSReminders reminders = this.prepare(contact);
        this.checkSendReminders(reminders, to, message);
    }

    private void checkSendReminders(SMSReminders reminders, String to, String message) {
        this.processor.process(reminders);
        ArgumentCaptor captor = ArgumentCaptor.forClass(OutboundMessage.class);
        ((SMSService)Mockito.verify((Object)this.smsService)).send((OutboundMessage)captor.capture());
        Assert.assertEquals((Object)to, (Object)((OutboundMessage)captor.getValue()).getPhone());
        Assert.assertEquals((Object)message, (Object)((OutboundMessage)captor.getValue()).getMessage());
        Assert.assertTrue((boolean)this.processor.complete((PatientReminders)reminders));
    }

    private SMSReminders prepare(Contact contact) {
        Date tomorrow = DateRules.getTomorrow();
        Act item = this.createReminderItem(DateRules.getToday(), tomorrow);
        Act reminder = this.createReminder(tomorrow, this.reminderType, item);
        return (SMSReminders)this.prepare(item, reminder, contact);
    }
}

