/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderFactory;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.macro.Macros;
import org.openvpms.web.component.im.sms.SMSTemplateEvaluator;
import org.openvpms.web.workspace.reporting.ReportingException;
import org.openvpms.web.workspace.reporting.reminder.ReminderSMSEvaluator;
import org.springframework.beans.factory.annotation.Autowired;

public class ReminderSMSEvaluatorTestCase
extends ArchetypeServiceTest {
    @Autowired
    private Macros macros;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestReminderFactory reminderFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    private ReminderSMSEvaluator evaluator;
    private Party practice;
    private Party location;
    private Act act;
    private Party customer;
    private Party patient;

    @Before
    public void setUp() {
        SMSTemplateEvaluator smsEvaluator = new SMSTemplateEvaluator((ArchetypeService)this.getArchetypeService(), this.getLookupService(), this.macros);
        this.evaluator = new ReminderSMSEvaluator(smsEvaluator);
        this.practice = (Party)((TestPracticeBuilder)this.practiceFactory.newPractice().name("Emergency Vet")).build(false);
        this.location = (Party)((TestLocationBuilder)((TestLocationBuilder)this.practiceFactory.newLocation().name("Emergency Vet - San Remo")).addPhone("12345678", new String[0])).build(false);
        this.customer = this.customerFactory.createCustomer("Reuben", "Smith");
        this.patient = (Party)((TestPatientBuilder)this.patientFactory.newPatient().name("Milo")).owner(this.customer).build();
        Entity reminderType = this.reminderFactory.createReminderType();
        this.act = (Act)((TestReminderBuilder)this.reminderFactory.newReminder().patient(this.patient)).reminderType(reminderType).date("2016-01-01 09:00:00").build();
    }

    @Test
    public void testXPathExpression() {
        String expression = "concat($patient.name, ' is due for a vaccination at ', \n       $location.name, '.', $nl, 'Please contact us on ',  \n       party:getTelephone($location), \n       ' to make an appointment')";
        String value = this.evaluate("XPATH", expression);
        Assert.assertEquals((Object)"Milo is due for a vaccination at Emergency Vet - San Remo.\nPlease contact us on 12345678 to make an appointment", (Object)value);
    }

    @Test
    public void testXPathVariables() {
        this.checkXPathExpression("$patient.name", "Milo");
        this.checkXPathExpression("$location.name", "Emergency Vet - San Remo");
        this.checkXPathExpression("$customer.firstName", "Reuben");
        this.checkXPathExpression("$practice.name", "Emergency Vet");
    }

    @Test
    public void testXPathException() {
        try {
            this.evaluate("XPATH", "$badexpression");
            Assert.fail((String)"Expected evaluation to throw an exception");
        }
        catch (ReportingException expected) {
            Assert.assertEquals((Object)"Failed to evaluate the SMS template Patient Reminder SMS Template", (Object)expected.getMessage());
        }
    }

    @Test
    public void testMacroExpression() {
        this.lookupFactory.getMacro("@patient", "$patient.name");
        this.lookupFactory.getMacro("@location", "$location.name");
        String expression = "@patient is due for a vaccination at @location";
        String value = this.evaluate("MACRO", expression);
        Assert.assertEquals((Object)"Milo is due for a vaccination at Emergency Vet - San Remo", (Object)value);
    }

    @Test
    public void testMacroException() {
        this.lookupFactory.getMacro("@badexpression", "concat(");
        try {
            this.evaluate("MACRO", "@badexpression");
            Assert.fail((String)"Expected evaluation to throw an exception");
        }
        catch (ReportingException expected) {
            Assert.assertEquals((Object)"Failed to evaluate the SMS template Patient Reminder SMS Template", (Object)expected.getMessage());
        }
    }

    private void checkXPathExpression(String expression, String expected) {
        String value = this.evaluate("XPATH", expression);
        Assert.assertEquals((Object)expected, (Object)value);
    }

    private String evaluate(String contentType, String content) {
        Entity template = this.reminderFactory.createSMSTemplate(contentType, content);
        return this.evaluator.evaluate(template, this.act, this.customer, this.patient, this.location, this.practice);
    }
}

