/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderRule;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.print.test.TestDocumentPrinter;
import org.openvpms.print.test.TestDocumentPrinterService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.reminder.AbstractPatientReminderProcessorTest;
import org.openvpms.web.workspace.reporting.reminder.GroupedReminders;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;
import org.openvpms.web.workspace.reporting.reminder.ReminderPrintProcessor;
import org.springframework.beans.factory.annotation.Autowired;

public class ReminderPrintProcessorTestCase
extends AbstractPatientReminderProcessorTest<GroupedReminders> {
    private TestReminderPrintProcessor processor;
    @Autowired
    private IMPrinterFactory printerFactory;
    @Autowired
    private TestDocumentPrinterService printerService;
    @Autowired
    private TestDocumentFactory documentFactory;
    private Party practiceLocation;
    private Entity documentTemplate;

    public ReminderPrintProcessorTestCase() {
        super("contact.location");
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.documentTemplate = this.reminderFactory.createVaccinationReminderTemplate();
        this.reminderFactory.updateReminderType(this.reminderType).defaultInterval(0, DateUnits.WEEKS).newCount().count(0).template(this.documentTemplate).newRule().print().sendTo(ReminderRule.SendTo.ANY).add().add().build();
        IArchetypeService service = this.getArchetypeService();
        ReminderTypes reminderTypes = new ReminderTypes((ArchetypeService)service);
        ReminderConfiguration config = this.createConfiguration();
        this.practiceLocation = this.practiceFactory.createLocation();
        this.processor = new TestReminderPrintProcessor(reminderTypes, config, this.practiceLocation, this.printerFactory);
    }

    @Test
    public void testReminderContact() {
        Contact location1 = this.createLocation("1 St Georges Rd", true, "REMINDER");
        Contact location2 = this.createLocation("2 Keon St", false, null);
        Contact location3 = this.createLocation("3 Hutton St", false, null);
        this.customer.addContact(location1);
        this.customer.addContact(location2);
        this.customer.addContact(location3);
        this.checkSend(null, location1);
    }

    @Test
    public void testOverrideContact() {
        Contact location1 = this.createLocation("1 St Georges Rd", true, "REMINDER");
        Contact location2 = this.createLocation("2 Keon St", false, null);
        this.customer.addContact(location1);
        this.customer.addContact(location2);
        this.checkSend(location2, location2);
    }

    @Test
    public void testMissingReminderCount() {
        this.checkMissingReminderCount(this.createLocation("1 St Georges Rd", true, "REMINDER"));
    }

    @Test
    public void testMissingReminderCountTemplate() {
        this.checkMissingReminderCountTemplate(this.createLocation("1 St Georges Rd", true, "REMINDER"));
    }

    @Test
    public void testPracticeLocationUsedForPrinterSelection() {
        Contact contact = this.createLocation("1 St Georges Rd", true, "REMINDER");
        this.customer.addContact(contact);
        Party customerLocation = this.practiceFactory.createLocation();
        this.customerFactory.updateCustomer(this.customer).practice(customerLocation).build();
        TestDocumentPrinter printer1 = new TestDocumentPrinter("printer1");
        TestDocumentPrinter printer2 = new TestDocumentPrinter("printer2");
        this.printerService.addPrinter((DocumentPrinter)printer1);
        this.printerService.addPrinter((DocumentPrinter)printer2);
        this.documentFactory.updateTemplate(this.documentTemplate).printer("printer1").location(this.practiceLocation).add().printer("printer2").location(customerLocation).add().build();
        this.checkSend(null, contact);
        Assert.assertEquals((Object)this.practiceLocation, (Object)this.processor.getContext().getLocation());
        MailContext mailContext = this.processor.getMailContext();
        Assert.assertTrue((boolean)(mailContext instanceof CustomerMailContext));
        Assert.assertEquals((Object)customerLocation, (Object)((CustomerMailContext)mailContext).getLocation());
        Assert.assertNotNull((Object)this.processor.getPrinter());
        Assert.assertEquals((Object)"printer1", (Object)this.processor.getPrinter().getId());
        Assert.assertEquals((long)1L, (long)printer1.getPrinted().size());
        Assert.assertTrue((boolean)printer2.getPrinted().isEmpty());
    }

    protected ReminderPrintProcessor getProcessor() {
        return this.processor;
    }

    @Override
    protected Act createReminderItem(Date send, Date dueDate) {
        return (Act)this.reminderFactory.newPrintReminder().sendDate(send).dueDate(dueDate).build();
    }

    private void checkSend(Contact contact, Contact to) {
        GroupedReminders reminders = (GroupedReminders)this.prepare(contact);
        this.processor.process(reminders);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)to, (Object)reminders.getContact());
    }

    private PatientReminders prepare(Contact contact) {
        Date tomorrow = DateRules.getTomorrow();
        Act item = this.createReminderItem(DateRules.getToday(), tomorrow);
        Act reminder = this.createReminder(tomorrow, this.reminderType, item);
        return this.prepare(item, reminder, contact);
    }

    private class TestReminderPrintProcessor
    extends ReminderPrintProcessor {
        private Context context;
        private MailContext mailContext;
        private DocumentPrinter printer;

        public TestReminderPrintProcessor(ReminderTypes reminderTypes, ReminderConfiguration config, Party location, IMPrinterFactory printerFactory) {
            super(new HelpContext("foo", null), reminderTypes, ReminderPrintProcessorTestCase.this.reminderRules, ReminderPrintProcessorTestCase.this.patientRules, location, ReminderPrintProcessorTestCase.this.practice, ReminderPrintProcessorTestCase.this.getArchetypeService(), config, printerFactory, (CommunicationLogger)Mockito.mock(CommunicationLogger.class), ReminderPrintProcessorTestCase.this.actionFactory);
        }

        public Context getContext() {
            return this.context;
        }

        public MailContext getMailContext() {
            return this.mailContext;
        }

        public DocumentPrinter getPrinter() {
            return this.printer;
        }

        protected <T> InteractiveIMPrinter<T> createPrinter(IMPrinter<T> printer, Context context) {
            this.context = context;
            return super.createPrinter(printer, context);
        }

        protected void print(InteractiveIMPrinter<?> iPrinter, DocumentPrinter printer) {
            super.print(iPrinter, printer);
            this.printer = printer;
            this.mailContext = iPrinter.getMailContext();
        }
    }
}

