/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderCSVExporter;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.party.TestContactFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.reminder.AbstractReminderBatchProcessorTest;
import org.openvpms.web.workspace.reporting.reminder.ReminderExportBatchProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderExportProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemQuerySource;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemSource;
import org.openvpms.web.workspace.reporting.reminder.Statistics;
import org.openvpms.web.workspace.reporting.reminder.TestCommunicationLogger;
import org.openvpms.web.workspace.reporting.reminder.TestReminderItemQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ReminderExportBatchProcessorTestCase
extends AbstractReminderBatchProcessorTest {
    private Party practice;
    private Party location;
    private ReminderTypes reminderTypes;
    private Entity schedule;
    @Autowired
    private ReminderRules reminderRules;
    @Autowired
    private PatientRules patientRules;
    @Autowired
    private PartyRules partyRules;
    @Autowired
    private AppointmentRules appointmentRules;
    @Autowired
    private DocumentHandlers documentHandlers;
    @Autowired
    private TestContactFactory contactFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    private ReminderConfiguration config;
    private PracticeService practiceService;
    private Entity reminderType1;
    private Entity reminderType2;
    private Party patientA;
    private Act reminderA1;
    private Act itemA1;
    private Act reminderA2;
    private Act itemA2;
    private Party patientB;
    private Act reminderB1;
    private Act itemB1;
    private Party patientC;
    private Act reminderC1;
    private Act itemC1;
    private Party customer1;
    private Contact contact1;
    private Party customer2;
    private Contact contact2;
    private ReminderItemQuerySource source;
    private Act appointmentA;
    private TestCommunicationLogger communicationLogger;
    private Date due;

    @Before
    public void setUp() {
        this.practice = this.practiceFactory.getPractice();
        this.location = this.practiceFactory.createLocation();
        IArchetypeService service = this.getArchetypeService();
        this.reminderTypes = new ReminderTypes((ArchetypeService)service);
        this.practiceService = (PracticeService)Mockito.mock(PracticeService.class);
        Mockito.when((Object)this.practiceService.getPractice()).thenReturn((Object)this.practice);
        this.config = new ReminderConfiguration(this.create("entity.reminderConfigurationType"), (ArchetypeService)service);
        this.schedule = this.schedulingFactory.createSchedule(this.location);
        this.contact1 = this.contactFactory.createLocation("103 Stafford Drive", "SALE", "VIC", "3085");
        this.customer1 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer("MS", "J", "Smith").addContact(this.contact1)).build();
        this.patientA = this.patientFactory.createPatient("Fido", this.customer1);
        this.patientB = this.patientFactory.createPatient("Spot", this.customer1);
        this.contact2 = this.contactFactory.createLocation("91 Smith Rd", "KONGWAK", "VIC", "3086");
        this.customer2 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer("MR", "K", "Aardvark").addContact(this.contact2)).build();
        this.patientC = this.patientFactory.createPatient("Fluffy", this.customer2);
        this.reminderType1 = (Entity)this.reminderFactory.newReminderType().defaultInterval(1, DateUnits.MONTHS).newCount().count(0).interval(0, DateUnits.WEEKS).add().newCount().count(1).interval(1, DateUnits.WEEKS).add().build();
        this.reminderType2 = (Entity)this.reminderFactory.newReminderType().defaultInterval(1, DateUnits.MONTHS).newCount().count(0).interval(0, DateUnits.WEEKS).add().newCount().count(1).interval(1, DateUnits.MONTHS).add().build();
        Date send = DateRules.getToday();
        this.due = DateRules.getTomorrow();
        this.itemA1 = this.reminderFactory.createExportReminder(send, this.due);
        this.itemA2 = this.reminderFactory.createExportReminder(send, this.due);
        this.reminderA1 = this.reminderFactory.createReminder(this.due, this.patientA, this.reminderType1, new Act[]{this.itemA1});
        this.reminderA2 = this.reminderFactory.createReminder(this.due, this.patientA, this.reminderType2, new Act[]{this.itemA2});
        this.createAppointment(DateRules.getYesterday(), this.customer1, this.patientA, "COMPLETED");
        Date appointment1Start = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.MONTHS);
        this.appointmentA = this.createAppointment(appointment1Start, this.customer1, this.patientA, "PENDING");
        this.createAppointment(DateRules.getNextDate((Date)appointment1Start), this.customer1, this.patientA, "PENDING");
        this.itemB1 = this.reminderFactory.createExportReminder(send, this.due);
        this.reminderB1 = this.reminderFactory.createReminder(this.due, this.patientB, this.reminderType1, new Act[]{this.itemB1});
        this.createAppointment(DateRules.getYesterday(), this.customer1, this.patientB, "CANCELLED");
        this.itemC1 = this.reminderFactory.createExportReminder(send, this.due);
        this.reminderC1 = this.reminderFactory.createReminder(this.due, this.patientC, this.reminderType2, new Act[]{this.itemC1});
        TestReminderItemQueryFactory factory = new TestReminderItemQueryFactory("act.patientReminderItemExport", this.itemA1, this.itemA2, this.itemB1, this.itemC1);
        this.source = new ReminderItemQuerySource((ReminderItemQueryFactory)factory, this.reminderTypes, this.config);
        this.communicationLogger = new TestCommunicationLogger((ArchetypeService)service);
    }

    @Test
    public void testExport() throws Exception {
        TestReminderExportProcessor processor = new TestReminderExportProcessor(this.communicationLogger);
        ReminderExportBatchProcessor batchProcessor = new ReminderExportBatchProcessor((ReminderItemSource)this.source, (ReminderExportProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        this.checkCompleted(this.itemA1, this.itemA2, this.itemB1, this.itemC1);
        Date oneWeek = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.WEEKS);
        Date oneMonth = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.MONTHS);
        this.checkReminder(this.reminderA1, oneWeek);
        this.checkReminder(this.reminderA2, oneMonth);
        this.checkReminder(this.reminderB1, oneWeek);
        this.checkReminder(this.reminderC1, oneMonth);
        List<ReminderEvent> exported = processor.getExported();
        List<Act> appointments = processor.getAppointments();
        Assert.assertEquals((long)4L, (long)exported.size());
        this.check(exported.get(0), this.reminderC1, this.itemC1, this.patientC, this.customer2, this.contact2, null, appointments.get(0));
        this.check(exported.get(1), this.reminderA1, this.itemA1, this.patientA, this.customer1, this.contact1, this.appointmentA, appointments.get(1));
        this.check(exported.get(2), this.reminderA2, this.itemA2, this.patientA, this.customer1, this.contact1, this.appointmentA, appointments.get(2));
        this.check(exported.get(3), this.reminderB1, this.itemB1, this.patientB, this.customer1, this.contact1, null, appointments.get(3));
        List<String[]> lines = this.readCSV(processor);
        Assert.assertEquals((long)5L, (long)lines.size());
        Assert.assertEquals((long)4L, (long)statistics.getCount());
        Assert.assertEquals((long)0L, (long)statistics.getErrors());
        Assert.assertEquals((long)0L, (long)statistics.getCancelled());
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemExport"}));
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemExport"}));
        Assert.assertEquals((long)4L, (long)this.communicationLogger.getLogs().size());
    }

    @Test
    public void testCancel() throws Exception {
        ((TestPatientBuilder)this.patientFactory.updatePatient(this.patientC).active(false)).build();
        TestReminderExportProcessor processor = new TestReminderExportProcessor(this.communicationLogger);
        ReminderExportBatchProcessor batchProcessor = new ReminderExportBatchProcessor((ReminderItemSource)this.source, (ReminderExportProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        this.checkCompleted(this.itemA1, this.itemA2, this.itemB1);
        this.checkStatus("CANCELLED", "Patient is inactive", this.itemC1);
        Date oneWeek = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.WEEKS);
        Date oneMonth = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.MONTHS);
        this.checkReminder(this.reminderA1, oneWeek);
        this.checkReminder(this.reminderA2, oneMonth);
        this.checkReminder(this.reminderB1, oneWeek);
        this.checkReminder(this.reminderC1, oneMonth);
        List<ReminderEvent> exported = processor.getExported();
        List<Act> appointments = processor.getAppointments();
        Assert.assertEquals((long)3L, (long)exported.size());
        this.check(exported.get(0), this.reminderA1, this.itemA1, this.patientA, this.customer1, this.contact1, this.appointmentA, appointments.get(0));
        this.check(exported.get(1), this.reminderA2, this.itemA2, this.patientA, this.customer1, this.contact1, this.appointmentA, appointments.get(1));
        this.check(exported.get(2), this.reminderB1, this.itemB1, this.patientB, this.customer1, this.contact1, null, appointments.get(2));
        List<String[]> lines = this.readCSV(processor);
        Assert.assertEquals((long)4L, (long)lines.size());
        Assert.assertEquals((long)3L, (long)statistics.getCount());
        Assert.assertEquals((long)0L, (long)statistics.getErrors());
        Assert.assertEquals((long)1L, (long)statistics.getCancelled());
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemExport"}));
        Assert.assertEquals((long)1L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemExport"}));
        Assert.assertEquals((long)3L, (long)this.communicationLogger.getLogs().size());
    }

    @Test
    public void testChangeReminderBeforeUpdate() throws Exception {
        TestReminderExportProcessor processor = new TestReminderExportProcessor(this.communicationLogger);
        processor.setBeforeUpdateAction(() -> {
            this.reminderA1.setDescription("some description, not normally editable, but will force object to be saved");
            this.save((IMObject)this.reminderA1);
        });
        ReminderExportBatchProcessor batchProcessor = new ReminderExportBatchProcessor((ReminderItemSource)this.source, (ReminderExportProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        this.checkStatus("ERROR", "Reminder was sent, but couldn't be updated. This may lead to a duplicate reminder. Failure reason: Reminder has been changed by another user", this.itemA1);
        this.checkCompleted(this.itemA2, this.itemB1, this.itemC1);
        Date oneWeek = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.WEEKS);
        Date oneMonth = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.MONTHS);
        this.checkReminder(this.reminderA1, 0, this.due);
        this.checkReminder(this.reminderA2, oneMonth);
        this.checkReminder(this.reminderB1, oneWeek);
        this.checkReminder(this.reminderC1, oneMonth);
        List<ReminderEvent> exported = processor.getExported();
        List<Act> appointments = processor.getAppointments();
        Assert.assertEquals((long)4L, (long)exported.size());
        this.check(exported.get(0), this.reminderC1, this.itemC1, this.patientC, this.customer2, this.contact2, null, appointments.get(0));
        this.check(exported.get(1), this.reminderA1, this.itemA1, this.patientA, this.customer1, this.contact1, this.appointmentA, appointments.get(1));
        this.check(exported.get(2), this.reminderA2, this.itemA2, this.patientA, this.customer1, this.contact1, this.appointmentA, appointments.get(2));
        this.check(exported.get(3), this.reminderB1, this.itemB1, this.patientB, this.customer1, this.contact1, null, appointments.get(3));
        List<String[]> lines = this.readCSV(processor);
        Assert.assertEquals((long)5L, (long)lines.size());
        Assert.assertEquals((long)4L, (long)statistics.getCount());
        Assert.assertEquals((long)0L, (long)statistics.getErrors());
        Assert.assertEquals((long)0L, (long)statistics.getCancelled());
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemExport"}));
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemExport"}));
        Assert.assertEquals((long)4L, (long)this.communicationLogger.getLogs().size());
    }

    @Test
    public void testChangeItemBeforeUpdate() {
        TestReminderExportProcessor processor = new TestReminderExportProcessor(this.communicationLogger);
        processor.setBeforeUpdateAction(() -> {
            this.itemA1.setDescription("some description, not normally editable, but will force object to be saved");
            this.save((IMObject)this.itemA1);
        });
        ReminderExportBatchProcessor batchProcessor = new ReminderExportBatchProcessor((ReminderItemSource)this.source, (ReminderExportProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        this.checkStatus("ERROR", "Reminder was sent, but couldn't be updated. This may lead to a duplicate reminder. Failure reason: Patient Export Reminder has been changed by another user", this.itemA1);
        this.checkCompleted(this.itemA2, this.itemB1, this.itemC1);
        Date oneWeek = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.WEEKS);
        Date oneMonth = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.MONTHS);
        this.checkReminder(this.reminderA1, 0, this.due);
        this.checkReminder(this.reminderA2, oneMonth);
        this.checkReminder(this.reminderB1, oneWeek);
        this.checkReminder(this.reminderC1, oneMonth);
        List<ReminderEvent> exported = processor.getExported();
        List<Act> appointments = processor.getAppointments();
        Assert.assertEquals((long)4L, (long)exported.size());
        this.check(exported.get(0), this.reminderC1, this.itemC1, this.patientC, this.customer2, this.contact2, null, appointments.get(0));
        this.check(exported.get(1), this.reminderA1, this.itemA1, this.patientA, this.customer1, this.contact1, this.appointmentA, appointments.get(1));
        this.check(exported.get(2), this.reminderA2, this.itemA2, this.patientA, this.customer1, this.contact1, this.appointmentA, appointments.get(2));
        this.check(exported.get(3), this.reminderB1, this.itemB1, this.patientB, this.customer1, this.contact1, null, appointments.get(3));
        Assert.assertEquals((long)4L, (long)statistics.getCount());
        Assert.assertEquals((long)0L, (long)statistics.getErrors());
        Assert.assertEquals((long)0L, (long)statistics.getCancelled());
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemExport"}));
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemExport"}));
        Assert.assertEquals((long)4L, (long)this.communicationLogger.getLogs().size());
    }

    @Test
    public void testDeleteReminderBeforeUpdate() {
        TestReminderExportProcessor processor = new TestReminderExportProcessor(this.communicationLogger);
        processor.setBeforeUpdateAction(() -> this.remove((IMObject)this.reminderA1));
        ReminderExportBatchProcessor batchProcessor = new ReminderExportBatchProcessor((ReminderItemSource)this.source, (ReminderExportProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        Assert.assertNull((Object)this.get((IMObject)this.reminderA1));
        Assert.assertNull((Object)this.get((IMObject)this.itemA1));
        this.checkCompleted(this.itemA2, this.itemB1, this.itemC1);
        Date oneWeek = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.WEEKS);
        Date oneMonth = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.MONTHS);
        this.checkReminder(this.reminderA2, oneMonth);
        this.checkReminder(this.reminderB1, oneWeek);
        this.checkReminder(this.reminderC1, oneMonth);
        List<ReminderEvent> exported = processor.getExported();
        Assert.assertEquals((long)4L, (long)exported.size());
        Assert.assertEquals((Object)this.reminderC1, (Object)exported.get(0).getReminder());
        Assert.assertEquals((Object)this.reminderA1, (Object)exported.get(1).getReminder());
        Assert.assertEquals((Object)this.reminderA2, (Object)exported.get(2).getReminder());
        Assert.assertEquals((Object)this.reminderB1, (Object)exported.get(3).getReminder());
        Assert.assertEquals((long)4L, (long)statistics.getCount());
        Assert.assertEquals((long)0L, (long)statistics.getErrors());
        Assert.assertEquals((long)0L, (long)statistics.getCancelled());
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemExport"}));
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemExport"}));
        Assert.assertEquals((long)4L, (long)this.communicationLogger.getLogs().size());
    }

    @Test
    public void testDeleteItemBeforeUpdate() {
        TestReminderExportProcessor processor = new TestReminderExportProcessor(this.communicationLogger);
        processor.setBeforeUpdateAction(() -> this.remove((IMObject)this.itemA1));
        ReminderExportBatchProcessor batchProcessor = new ReminderExportBatchProcessor((ReminderItemSource)this.source, (ReminderExportProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        Assert.assertNull((Object)this.get((IMObject)this.itemA1));
        this.checkCompleted(this.itemA2, this.itemB1, this.itemC1);
        Date oneWeek = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.WEEKS);
        Date oneMonth = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.MONTHS);
        this.checkReminder(this.reminderA1, 0, this.due);
        this.checkReminder(this.reminderA2, oneMonth);
        this.checkReminder(this.reminderB1, oneWeek);
        this.checkReminder(this.reminderC1, oneMonth);
        List<ReminderEvent> exported = processor.getExported();
        Assert.assertEquals((long)4L, (long)exported.size());
        Assert.assertEquals((Object)this.reminderC1, (Object)exported.get(0).getReminder());
        Assert.assertEquals((Object)this.reminderA1, (Object)exported.get(1).getReminder());
        Assert.assertEquals((Object)this.reminderA2, (Object)exported.get(2).getReminder());
        Assert.assertEquals((Object)this.reminderB1, (Object)exported.get(3).getReminder());
        Assert.assertEquals((long)4L, (long)statistics.getCount());
        Assert.assertEquals((long)0L, (long)statistics.getErrors());
        Assert.assertEquals((long)0L, (long)statistics.getCancelled());
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemExport"}));
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemExport"}));
        Assert.assertEquals((long)4L, (long)this.communicationLogger.getLogs().size());
    }

    private List<String[]> readCSV(TestReminderExportProcessor processor) throws IOException {
        Document document = processor.getDocument();
        Assert.assertNotNull((Object)document);
        InputStream content = this.documentHandlers.get(document).getContent(document);
        CSVReader reader = new CSVReader((Reader)new InputStreamReader(content), ',');
        return reader.readAll();
    }

    private void check(ReminderEvent event, Act reminder, Act item, Party patient, Party customer, Contact contact, Act expectedAppointment, Act actualAppointment) {
        Assert.assertEquals((Object)event.getReminder(), (Object)reminder);
        Assert.assertEquals((Object)event.getItem(), (Object)item);
        Assert.assertEquals((Object)event.getPatient(), (Object)patient);
        Assert.assertEquals((Object)event.getCustomer(), (Object)customer);
        Assert.assertEquals((Object)event.getContact(), (Object)contact);
        Assert.assertEquals((Object)expectedAppointment, (Object)actualAppointment);
    }

    private Act createAppointment(Date startTime, Party customer, Party patient, String status) {
        return (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(startTime)).schedule(this.schedule).customer(customer)).patient(patient)).status(status)).appointmentType(this.schedulingFactory.createAppointmentType()).build();
    }

    private class TestReminderExportProcessor
    extends ReminderExportProcessor {
        private final List<ReminderEvent> exported;
        private final List<Act> appointments;
        private Document document;
        private Runnable beforeUpdate;

        public TestReminderExportProcessor(CommunicationLogger communicationLogger) {
            super(ReminderExportBatchProcessorTestCase.this.reminderTypes, ReminderExportBatchProcessorTestCase.this.reminderRules, ReminderExportBatchProcessorTestCase.this.patientRules, ReminderExportBatchProcessorTestCase.this.location, ReminderExportBatchProcessorTestCase.this.practice, ReminderExportBatchProcessorTestCase.this.getArchetypeService(), ReminderExportBatchProcessorTestCase.this.config, communicationLogger, ReminderExportBatchProcessorTestCase.this.actionFactory);
            this.exported = new ArrayList<ReminderEvent>();
            this.appointments = new ArrayList<Act>();
        }

        public List<ReminderEvent> getExported() {
            return this.exported;
        }

        public List<Act> getAppointments() {
            return this.appointments;
        }

        public Document getDocument() {
            return this.document;
        }

        public void setBeforeUpdateAction(Runnable action) {
            this.beforeUpdate = action;
        }

        protected void export(List<ReminderEvent> reminders) {
            ReminderCSVExporter exporter = new ReminderCSVExporter(ReminderExportBatchProcessorTestCase.this.practiceService, ReminderExportBatchProcessorTestCase.this.partyRules, ReminderExportBatchProcessorTestCase.this.patientRules, ReminderExportBatchProcessorTestCase.this.appointmentRules, ReminderExportBatchProcessorTestCase.this.getArchetypeService(), ReminderExportBatchProcessorTestCase.this.documentHandlers){

                public Document export(List<ReminderEvent> reminders, Date date) {
                    Document result = super.export(reminders, date);
                    if (TestReminderExportProcessor.this.beforeUpdate != null) {
                        TestReminderExportProcessor.this.beforeUpdate.run();
                    }
                    return result;
                }

                protected void export(ReminderEvent event, Act appointment, CSVWriter writer) {
                    TestReminderExportProcessor.this.exported.add(event);
                    TestReminderExportProcessor.this.appointments.add(appointment);
                    super.export(event, appointment, writer);
                }
            };
            this.document = exporter.export(reminders, new Date());
        }
    }
}

