/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.email;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.mail.EmailAddress;
import org.openvpms.web.workspace.reporting.email.PracticeEmailAddresses;

public class PracticeEmailAddressesTestCase
extends ArchetypeServiceTest {
    private Party practice;
    private Party location1;
    private Party location2;
    private Party location3;
    private Contact practiceReminder;
    private Contact location1Reminder;
    private Contact location2Billing;
    private Contact location3Reminder;

    @Before
    public void setUp() {
        this.practice = (Party)this.create("party.organisationPractice", Party.class);
        this.location1 = TestHelper.createLocation();
        this.location2 = TestHelper.createLocation();
        this.location3 = TestHelper.createLocation();
        this.location1.setName("X Location 1");
        this.location2.setName("X Location 2");
        this.location2.setName("X Location 3");
        this.practice.setName("OpenVPMS Practice");
        this.practiceReminder = this.createEmailContact("mainreminder@practice.com", "REMINDER");
        Contact practiceBilling = this.createEmailContact("mainbilling@practice.com", "BILLING");
        this.practice.addContact(this.practiceReminder);
        this.practice.addContact(practiceBilling);
        this.location1Reminder = this.createEmailContact("branch1reminder@practice.com", "REMINDER");
        Contact location1Billing = this.createEmailContact("branch1billing@practice.com", "BILLING");
        this.location1.addContact(this.location1Reminder);
        this.location1.addContact(location1Billing);
        this.location2Billing = this.createEmailContact("branch2billing@practice.com", "BILLING");
        this.location2.addContact(this.location2Billing);
        this.location3Reminder = this.createEmailContact("branch3reminder@practice.com", "Name Override", "REMINDER");
        this.location3.addContact(this.location3Reminder);
    }

    @Test
    public void testGetAddress() {
        Party customer1 = this.createCustomer(this.location1);
        IMObjectBean customerBean = this.getBean((IMObject)customer1);
        customerBean.addTarget("practice", (IMObject)this.location1);
        Party customer2 = this.createCustomer(this.location2);
        Party customer3 = this.createCustomer(this.location3);
        Party customer4 = this.createCustomer(null);
        List<Party> locations = Arrays.asList(this.location1, this.location2, this.location3);
        PracticeEmailAddresses addresses = new PracticeEmailAddresses(this.practice, locations, "REMINDER", (ArchetypeService)this.getArchetypeService());
        this.checkAddress(addresses.getPracticeAddress(customer1), "branch1reminder@practice.com", "X Location 1");
        this.checkAddress(addresses.getPracticeAddress(customer2), "mainreminder@practice.com", "OpenVPMS Practice");
        this.checkAddress(addresses.getPracticeAddress(customer3), "branch3reminder@practice.com", "Name Override");
        this.checkAddress(addresses.getPracticeAddress(customer4), "mainreminder@practice.com", "OpenVPMS Practice");
    }

    @Test
    public void testGetContact() {
        Party location4 = TestHelper.createLocation();
        List<Party> locations = Arrays.asList(this.location1, this.location2, this.location3, location4);
        PracticeEmailAddresses addresses = new PracticeEmailAddresses(this.practice, locations, "REMINDER", (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)this.practiceReminder, (Object)addresses.getContact(this.practice));
        Assert.assertEquals((Object)this.location1Reminder, (Object)addresses.getContact(this.location1));
        Assert.assertNull((Object)addresses.getContact(this.location2));
        Assert.assertEquals((Object)this.location3Reminder, (Object)addresses.getContact(this.location3));
        Assert.assertNull((Object)addresses.getContact(location4));
    }

    protected Contact createEmailContact(String address, String purpose) {
        return TestHelper.createEmailContact((String)address, (boolean)false, (String)purpose);
    }

    protected Contact createEmailContact(String address, String name, String purpose) {
        Contact emailContact = TestHelper.createEmailContact((String)address, (boolean)false, (String)purpose);
        emailContact.setName(name);
        return emailContact;
    }

    private void checkAddress(EmailAddress emailAddress, String address, String name) {
        Assert.assertEquals((Object)address, (Object)emailAddress.getAddress());
        Assert.assertEquals((Object)name, (Object)emailAddress.getName());
    }

    private Party createCustomer(Party location) {
        Party customer = TestHelper.createCustomer((boolean)false);
        if (location != null) {
            IMObjectBean customerBean = this.getBean((IMObject)customer);
            customerBean.addTarget("practice", (IMObject)location);
        }
        return customer;
    }
}

