/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.summary;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.workspace.patient.summary.CustomerPatientContext;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomerPatientContextTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testContext() {
        LocalContext parent = new LocalContext();
        CustomerPatientContext context = new CustomerPatientContext((Context)parent);
        Assert.assertNull((Object)context.getCustomer());
        Assert.assertNull((Object)context.getPatient());
        Assert.assertNull((Object)context.getLocation());
        Party customer1 = this.customerFactory.createCustomer();
        Party patient1 = this.patientFactory.createPatient(customer1);
        parent.setCustomer(customer1);
        parent.setPatient(patient1);
        Assert.assertNull((Object)context.getCustomer());
        Assert.assertNull((Object)context.getPatient());
        Assert.assertNull((Object)context.getObject("party.customer*"));
        Assert.assertNull((Object)context.getObject("party.patient*"));
        Assert.assertNull((Object)context.getObject(customer1.getObjectReference()));
        Assert.assertNull((Object)context.getObject(patient1.getObjectReference()));
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        parent.setLocation(location1);
        Assert.assertEquals((Object)location1, (Object)context.getLocation());
        context.setLocation(location2);
        Assert.assertEquals((Object)location2, (Object)context.getLocation());
        Party customer2 = this.customerFactory.createCustomer();
        Party patient2 = this.patientFactory.createPatient(customer2);
        context.setCustomer(customer2);
        context.setPatient(patient2);
        Assert.assertEquals((Object)customer2, (Object)context.getCustomer());
        Assert.assertEquals((Object)patient2, (Object)context.getPatient());
        Assert.assertEquals((Object)customer2, (Object)context.getObject("party.customer*"));
        Assert.assertEquals((Object)patient2, (Object)context.getObject("party.patient*"));
        Assert.assertEquals((Object)customer2, (Object)context.getObject(customer2.getObjectReference()));
        Assert.assertEquals((Object)patient2, (Object)context.getObject(patient2.getObjectReference()));
    }
}

