/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorTest;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.patient.mr.PatientClinicalEventActEditor;
import org.openvpms.web.workspace.patient.mr.PatientVisitNoteEditor;

public class PatientVisitNoteEditorTestCase
extends AbstractIMObjectEditorTest<PatientVisitNoteEditor> {
    public PatientVisitNoteEditorTestCase() {
        super(PatientVisitNoteEditor.class, "act.patientClinicalEvent");
    }

    @Test
    public void testEditor() {
        Act visit = (Act)this.create("act.patientClinicalEvent", Act.class);
        PatientVisitNoteEditor editor = this.createEditor((IMObject)visit);
        editor.getComponent();
        editor.setNote("test");
        SaveHelper.save((IMObjectEditor)editor);
        visit = (Act)this.get((IMObject)visit);
        Act note = (Act)this.get((IMObject)editor.getNoteEditor().getObject());
        Assert.assertNotNull((Object)note);
        IMObjectBean bean = this.getBean((IMObject)visit);
        Assert.assertTrue((boolean)bean.hasTarget("items", (IMObject)note));
        Assert.assertEquals((Object)"test", (Object)this.getBean((IMObject)note).getString("note"));
    }

    @Test
    public void testNewInstanceAfterSave() {
        Act visit = (Act)this.create("act.patientClinicalEvent", Act.class);
        PatientVisitNoteEditor editor = this.createEditor((IMObject)visit);
        editor.getComponent();
        editor.setNote("test");
        SaveHelper.save((IMObjectEditor)editor);
        PatientVisitNoteEditor newInstance = (PatientVisitNoteEditor)editor.newInstance();
        Assert.assertNotNull((Object)newInstance);
        Assert.assertNotEquals((Object)editor, (Object)newInstance);
        Assert.assertEquals((Object)"test", (Object)newInstance.getNote());
    }

    public void testFactory() {
        IMObject object = this.create("act.patientClinicalEvent");
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        IMObjectEditor editor = this.getFactory().create(object, (LayoutContext)context);
        Assert.assertEquals(PatientClinicalEventActEditor.class, editor.getClass());
    }

    protected PatientVisitNoteEditor createEditor(IMObject object) {
        LocalContext context = new LocalContext();
        context.setPatient(TestHelper.createPatient());
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        return this.createEditor(object, (LayoutContext)layoutContext);
    }

    protected PatientVisitNoteEditor createEditor(IMObject object, LayoutContext context) {
        return new PatientVisitNoteEditor((Act)object, context);
    }
}

