/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.patient.history.PatientHistoryBrowser;
import org.openvpms.web.workspace.patient.history.PatientHistoryCRUDWindow;
import org.openvpms.web.workspace.patient.history.PatientHistoryQuery;
import org.openvpms.web.workspace.patient.mr.PatientRecordWorkspace;
import org.openvpms.web.workspace.patient.mr.RecordBrowser;
import org.openvpms.web.workspace.patient.problem.ProblemBrowser;
import org.openvpms.web.workspace.patient.problem.ProblemRecordCRUDWindow;

public class PatientRecordWorkspaceTestCase
extends AbstractAppTest {
    private Context context;
    private Party patient;

    @Before
    public void setUp() {
        super.setUp();
        this.context = new LocalContext((Context)ContextApplicationInstance.getInstance().getContext());
        this.patient = TestHelper.createPatient();
        this.context.setPatient(this.patient);
    }

    @Test
    public void testInit() {
        TestRecordWorkspace workspace = new TestRecordWorkspace(this.context);
        workspace.getComponent();
        Assert.assertEquals((Object)this.patient, (Object)workspace.getObject());
        CRUDWindow<Act> window = workspace.getCRUDWindow();
        Assert.assertTrue((boolean)(window instanceof PatientHistoryCRUDWindow));
        Assert.assertNull((Object)window.getObject());
        Assert.assertNull((Object)((PatientHistoryCRUDWindow)window).getEvent());
    }

    @Test
    public void testInitWithEvents() {
        PatientTestHelper.createEvent((Date)TestHelper.getDate((String)"2014-07-01"), (Party)this.patient, (Act[])new Act[0]);
        Act event2 = PatientTestHelper.createEvent((Date)TestHelper.getDate((String)"2014-07-02"), (Party)this.patient, (Act[])new Act[0]);
        TestRecordWorkspace workspace = new TestRecordWorkspace(this.context);
        workspace.getComponent();
        Assert.assertEquals((Object)this.patient, (Object)workspace.getObject());
        this.checkHistorySelection(event2, event2, workspace);
    }

    @Test
    public void testSelectHistory() {
        Date date1 = TestHelper.getDate((String)"2014-07-01");
        Act note1 = PatientTestHelper.createNote((Date)date1, (Party)this.patient);
        Act event1 = PatientTestHelper.createEvent((Date)date1, (Party)this.patient, (Act[])new Act[]{note1});
        Date date2 = TestHelper.getDate((String)"2014-07-02");
        Act note2 = PatientTestHelper.createNote((Date)date2, (Party)this.patient);
        Act event2 = PatientTestHelper.createEvent((Date)date2, (Party)this.patient, (Act[])new Act[]{note2});
        TestRecordWorkspace workspace = new TestRecordWorkspace(this.context);
        workspace.getComponent();
        PatientHistoryBrowser history = workspace.getBrowser().getHistory();
        history.setSelected(event1);
        this.checkHistorySelection(event1, event1, workspace);
        history.setSelected(note1);
        this.checkHistorySelection(note1, event1, workspace);
        history.setSelected(event2);
        this.checkHistorySelection(event2, event2, workspace);
        history.setSelected(note2);
        this.checkHistorySelection(note2, event2, workspace);
    }

    @Test
    public void testSelectProblems() {
        Date date1 = TestHelper.getDate((String)"2014-07-01");
        Act note1 = PatientTestHelper.createNote((Date)date1, (Party)this.patient);
        Act problem1 = PatientTestHelper.createProblem((Date)date1, (Party)this.patient, (Act[])new Act[]{note1});
        Act event1 = PatientTestHelper.createEvent((Date)date1, (Party)this.patient, (Act[])new Act[]{problem1, note1});
        Date date2 = TestHelper.getDate((String)"2014-07-02");
        Act note2 = PatientTestHelper.createNote((Date)date2, (Party)this.patient);
        Act problem2 = PatientTestHelper.createProblem((Date)date2, (Party)this.patient, (Act[])new Act[]{note2});
        Act event2 = PatientTestHelper.createEvent((Date)date2, (Party)this.patient, (Act[])new Act[]{problem2, note2});
        TestRecordWorkspace workspace = new TestRecordWorkspace(this.context);
        workspace.getComponent();
        TestRecordBrowser browser = workspace.getBrowser();
        browser.showProblems();
        this.checkProblemSelection(problem2, problem2, event2, workspace);
        browser.setSelected(problem1);
        this.checkProblemSelection(problem1, problem1, event1, workspace);
        browser.setSelected(note1);
        this.checkProblemSelection(note1, problem1, event1, workspace);
        browser.setSelected(event1);
        this.checkProblemSelection(event1, problem1, event1, workspace);
    }

    @Test
    public void testHyperlinks() {
        Date date1 = TestHelper.getDate((String)"2014-07-01");
        Act note1 = PatientTestHelper.createNote((Date)date1, (Party)this.patient);
        Act problem1 = PatientTestHelper.createProblem((Date)date1, (Party)this.patient, (Act[])new Act[]{note1});
        Act event1 = PatientTestHelper.createEvent((Date)date1, (Party)this.patient, (Act[])new Act[]{problem1});
        Date date2 = TestHelper.getDate((String)"2014-07-02");
        Act note2 = PatientTestHelper.createNote((Date)date2, (Party)this.patient);
        Act problem2 = PatientTestHelper.createProblem((Date)date2, (Party)this.patient, (Act[])new Act[]{note2});
        Act event2 = PatientTestHelper.createEvent((Date)date2, (Party)this.patient, (Act[])new Act[]{problem2});
        TestRecordWorkspace workspace = new TestRecordWorkspace(this.context);
        workspace.getComponent();
        TestRecordBrowser browser = workspace.getBrowser();
        browser.followHyperlink((IMObject)problem1);
        this.checkProblemSelection(problem1, problem1, event1, workspace);
        browser.followHyperlink((IMObject)event2);
        this.checkHistorySelection(event2, event2, workspace);
        browser.followHyperlink((IMObject)problem2);
        this.checkProblemSelection(problem2, problem2, event2, workspace);
    }

    private void checkHistorySelection(Act object, Act event, TestRecordWorkspace workspace) {
        Browser selectedBrowser = workspace.getBrowser().getSelectedBrowser();
        Assert.assertTrue((boolean)(selectedBrowser instanceof PatientHistoryBrowser));
        Assert.assertEquals((Object)object, (Object)selectedBrowser.getSelected());
        Assert.assertEquals((Object)event, (Object)((PatientHistoryBrowser)selectedBrowser).getSelectedParent());
        CRUDWindow<Act> window = workspace.getCRUDWindow();
        Assert.assertTrue((boolean)(window instanceof PatientHistoryCRUDWindow));
        Assert.assertEquals((Object)object, (Object)window.getObject());
        Assert.assertEquals((Object)event, (Object)((PatientHistoryCRUDWindow)window).getEvent());
    }

    private void checkProblemSelection(Act object, Act problem, Act event, TestRecordWorkspace workspace) {
        Browser selectedBrowser = workspace.getBrowser().getSelectedBrowser();
        Assert.assertTrue((boolean)(selectedBrowser instanceof ProblemBrowser));
        Assert.assertEquals((Object)object, (Object)selectedBrowser.getSelected());
        Assert.assertEquals((Object)problem, (Object)((ProblemBrowser)selectedBrowser).getSelectedParent());
        CRUDWindow<Act> window = workspace.getCRUDWindow();
        Assert.assertTrue((boolean)(window instanceof ProblemRecordCRUDWindow));
        Assert.assertEquals((Object)object, (Object)window.getObject());
        Assert.assertEquals((Object)problem, (Object)((ProblemRecordCRUDWindow)window).getProblem());
        Assert.assertEquals((Object)event, (Object)((ProblemRecordCRUDWindow)window).getEvent());
    }

    private static class TestRecordWorkspace
    extends PatientRecordWorkspace {
        public TestRecordWorkspace(Context context) {
            super(context, (Preferences)Mockito.mock(Preferences.class));
        }

        public CRUDWindow<Act> getCRUDWindow() {
            return super.getCRUDWindow();
        }

        public TestRecordBrowser getBrowser() {
            return (TestRecordBrowser)super.getBrowser();
        }

        protected RecordBrowser createRecordBrowser(Party patient, PatientHistoryQuery query, Context context, HelpContext help) {
            return new TestRecordBrowser(patient, query, context, help);
        }
    }

    private static class TestRecordBrowser
    extends RecordBrowser {
        public TestRecordBrowser(Party patient, PatientHistoryQuery query, Context context, HelpContext help) {
            super(patient, query, context, help);
        }

        public void followHyperlink(IMObject object) {
            super.followHyperlink(object);
        }
    }
}

