/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorTest;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.patient.mr.PatientPrescriptionEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientPrescriptionEditorTestCase
extends AbstractIMObjectEditorTest<PatientPrescriptionEditor> {
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;

    public PatientPrescriptionEditorTestCase() {
        super(PatientPrescriptionEditor.class, "act.patientPrescription");
    }

    @Test
    public void testDefaultExpiry() {
        Act act = (Act)this.create("act.patientPrescription", Act.class);
        Date start = act.getActivityStartTime();
        Party practice = (Party)this.practiceFactory.newPractice().prescriptionExpiryPeriod(6, DateUnits.MONTHS).build(false);
        LocalContext context = new LocalContext();
        context.setPractice(practice);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        PatientPrescriptionEditor editor1 = (PatientPrescriptionEditor)this.createEditor((IMObject)act, (LayoutContext)layoutContext);
        Assert.assertEquals((Object)DateRules.getDate((Date)start, (int)6, (DateUnits)DateUnits.MONTHS), (Object)act.getActivityEndTime());
        editor1.setPatient(this.patientFactory.createPatient());
        editor1.setProduct(this.productFactory.createMedication());
        editor1.setClinician(this.userFactory.createClinician());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        Date newExpiry = DateRules.getDate((Date)start, (int)3, (DateUnits)DateUnits.MONTHS);
        act.setActivityEndTime(newExpiry);
        this.createEditor((IMObject)act, (LayoutContext)layoutContext);
        Assert.assertEquals((Object)newExpiry, (Object)act.getActivityEndTime());
    }

    @Test
    public void testLabel() {
        Act act = (Act)this.create("act.patientPrescription", Act.class);
        Product product1 = (Product)this.productFactory.newMedication().labelInstructions("the label").build();
        Product product2 = this.productFactory.createMedication();
        PatientPrescriptionEditor editor = (PatientPrescriptionEditor)this.createEditor((IMObject)act);
        editor.getComponent();
        editor.setProduct(product1);
        Assert.assertEquals((Object)"the label", (Object)editor.getLabel());
        editor.setProduct(product2);
        Assert.assertNull((Object)editor.getLabel());
    }

    @Test
    public void testQuantityFromDose() {
        Act act = (Act)this.create("act.patientPrescription", Act.class);
        Party patient = this.patientFactory.createPatient();
        this.patientFactory.createWeight(patient, 5);
        Product product1 = (Product)this.productFactory.newMedication().concentration(1).newDose().weightRange(0, 2).rate(1).quantity(1).add().newDose().weightRange(2, 10).rate(2).quantity(1).add().build();
        PatientPrescriptionEditor editor = (PatientPrescriptionEditor)this.createEditor((IMObject)act);
        editor.getComponent();
        editor.setPatient(patient);
        editor.setProduct(product1);
        this.checkEquals(10, editor.getQuantity());
        Product product2 = this.productFactory.createMedication();
        editor.setProduct(product2);
        this.checkEquals(1, editor.getQuantity());
    }
}

