/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.laboratory.LaboratoryTestHelper;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.patient.history.PatientHistoryActions;

public class PatientHistoryActionsTestCase
extends AbstractAppTest {
    @Test
    public void testCanDelete() {
        PatientHistoryActions actions = new PatientHistoryActions();
        Party patient = TestHelper.createPatient();
        Act event1 = PatientTestHelper.createEvent((Party)patient);
        Act problem = PatientTestHelper.createProblem((Date)new Date(), (Party)patient, (Act[])new Act[0]);
        Act medication = PatientTestHelper.createMedication((Party)patient);
        DocumentAct investigation = PatientTestHelper.createInvestigation((Party)patient, (Entity)LaboratoryTestHelper.createInvestigationType());
        Act note = PatientTestHelper.createNote((Date)new Date(), (Party)patient);
        Act weight = PatientTestHelper.createWeight((Date)new Date(), (Party)patient);
        DocumentAct attachment = PatientTestHelper.createDocumentAttachment((Date)new Date(), (Party)patient);
        DocumentAct form = PatientTestHelper.createDocumentForm((Party)patient);
        DocumentAct letter = PatientTestHelper.createDocumentLetter((Date)new Date(), (Party)patient, (Act[])new Act[0]);
        DocumentAct image = PatientTestHelper.createDocumentImage((Date)new Date(), (Party)patient);
        Assert.assertTrue((boolean)actions.canDelete(event1));
        Assert.assertTrue((boolean)actions.canDelete(problem));
        Assert.assertTrue((boolean)actions.canDelete(medication));
        Assert.assertTrue((boolean)actions.canDelete((Act)investigation));
        Assert.assertTrue((boolean)actions.canDelete(note));
        Assert.assertTrue((boolean)actions.canDelete(weight));
        Assert.assertTrue((boolean)actions.canDelete((Act)attachment));
        Assert.assertTrue((boolean)actions.canDelete((Act)form));
        Assert.assertTrue((boolean)actions.canDelete((Act)letter));
        Assert.assertTrue((boolean)actions.canDelete((Act)image));
        Act event2 = PatientTestHelper.createEvent((Date)new Date(), (Party)patient, (Act[])new Act[]{problem, medication, investigation, note, weight, attachment, form, letter, image});
        Assert.assertFalse((boolean)actions.canDelete(event2));
        Assert.assertTrue((boolean)actions.canDelete(problem));
        Assert.assertTrue((boolean)actions.canDelete(medication));
        Assert.assertTrue((boolean)actions.canDelete((Act)investigation));
        Assert.assertTrue((boolean)actions.canDelete(note));
        Assert.assertTrue((boolean)actions.canDelete(weight));
        Assert.assertTrue((boolean)actions.canDelete((Act)attachment));
        Assert.assertTrue((boolean)actions.canDelete((Act)form));
        Assert.assertTrue((boolean)actions.canDelete((Act)letter));
        Assert.assertTrue((boolean)actions.canDelete((Act)image));
        Act invoiceItem = (Act)this.create("act.customerAccountInvoiceItem", Act.class);
        IMObjectBean bean = this.getBean((IMObject)invoiceItem);
        bean.addTarget("dispensing", (IMObject)medication, "invoiceItem");
        bean.addTarget("investigations", (IMObject)investigation, "invoiceItems");
        attachment.addActRelationship((ActRelationship)bean.addTarget("documents", (IMObject)attachment));
        bean.addTarget("documents", (IMObject)form, "invoiceItem");
        bean.addTarget("documents", (IMObject)letter, "invoiceItem");
        image.addActRelationship((ActRelationship)bean.addTarget("documents", (IMObject)image));
        Assert.assertFalse((boolean)actions.canDelete(medication));
        Assert.assertFalse((boolean)actions.canDelete((Act)investigation));
        Assert.assertTrue((boolean)actions.canDelete((Act)attachment));
        Assert.assertTrue((boolean)actions.canDelete((Act)form));
        Assert.assertTrue((boolean)actions.canDelete((Act)letter));
        Assert.assertTrue((boolean)actions.canDelete((Act)image));
        Act problem2 = PatientTestHelper.createProblem((Date)new Date(), (Party)patient, (Act[])new Act[]{note});
        Assert.assertFalse((boolean)actions.canDelete(problem2));
    }
}

