/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.model.act.Act;
import org.openvpms.web.workspace.patient.history.DefaultPatientHistoryDatingPolicy;
import org.openvpms.web.workspace.patient.history.PatientHistoryDatingPolicy;

public class DefaultPatientHistoryDatingPolicyTestCase
extends ArchetypeServiceTest {
    private PatientHistoryDatingPolicy locked1;
    private PatientHistoryDatingPolicy lockedExceptFormsAndLetters;
    private PatientHistoryDatingPolicy lockingDisabled;

    @Before
    public void setUp() {
        this.locked1 = this.createPolicy(new Period(2L, PeriodType.days()), false);
        this.lockedExceptFormsAndLetters = this.createPolicy(new Period(2L, PeriodType.days()), true);
        this.lockingDisabled = this.createPolicy(null, false);
    }

    @Test
    public void testCanEditDate() {
        Act event = (Act)this.create("act.patientClinicalEvent", Act.class);
        Act problem = (Act)this.create("act.patientClinicalProblem", Act.class);
        Act addendum = (Act)this.create("act.patientClinicalAddendum", Act.class);
        Act attachment = (Act)this.create("act.patientDocumentAttachment", Act.class);
        Act attachmentVersion = (Act)this.create("act.patientDocumentAttachmentVersion", Act.class);
        Act form = (Act)this.create("act.patientDocumentForm", Act.class);
        Act image = (Act)this.create("act.patientDocumentImage", Act.class);
        Act imageVersion = (Act)this.create("act.patientDocumentImageVersion", Act.class);
        Act investigation = (Act)this.create("act.patientInvestigation", Act.class);
        Act investigationVersion = (Act)this.create("act.patientInvestigationVersion", Act.class);
        Act letter = (Act)this.create("act.patientDocumentLetter", Act.class);
        Act letterVersion = (Act)this.create("act.patientDocumentLetterVersion", Act.class);
        Act medication = (Act)this.create("act.patientMedication", Act.class);
        Act note = (Act)this.create("act.patientClinicalNote", Act.class);
        Act weight = (Act)this.create("act.patientWeight", Act.class);
        this.checkCanEdit(event, "IN_PROGRESS", true, true, true);
        this.checkCanEdit(problem, "RESOLVED", true, true, true);
        this.checkCanEdit(addendum, "IN_PROGRESS", false, false, false);
        this.checkCanEdit(attachment, "IN_PROGRESS", false, false, true);
        this.checkCanEdit(attachmentVersion, "IN_PROGRESS", false, false, false);
        this.checkCanEdit(form, "IN_PROGRESS", false, true, true);
        this.checkCanEdit(image, "IN_PROGRESS", false, false, true);
        this.checkCanEdit(imageVersion, "IN_PROGRESS", false, false, false);
        this.checkCanEdit(investigation, "IN_PROGRESS", false, false, true);
        this.checkCanEdit(investigationVersion, "IN_PROGRESS", false, false, false);
        this.checkCanEdit(letter, "IN_PROGRESS", false, true, true);
        this.checkCanEdit(letterVersion, "IN_PROGRESS", false, false, false);
        this.checkCanEdit(medication, "IN_PROGRESS", false, false, true);
        this.checkCanEdit(note, "IN_PROGRESS", false, false, true);
        this.checkCanEdit(weight, "IN_PROGRESS", false, false, true);
        investigation.setStatus("CANCELLED");
        this.checkCanEdit(investigation, "CANCELLED", false, false, false);
        this.checkCanEdit(attachment, "POSTED", false, false, false);
        this.checkCanEdit(attachmentVersion, "POSTED", false, false, false);
        this.checkCanEdit(form, "POSTED", false, false, false);
        this.checkCanEdit(image, "POSTED", false, false, false);
        this.checkCanEdit(imageVersion, "POSTED", false, false, false);
        this.checkCanEdit(investigation, "POSTED", false, false, false);
        this.checkCanEdit(investigationVersion, "POSTED", false, false, false);
        this.checkCanEdit(letter, "POSTED", false, false, false);
        this.checkCanEdit(letterVersion, "POSTED", false, false, false);
        this.checkCanEdit(medication, "POSTED", false, false, false);
        this.checkCanEdit(note, "POSTED", false, false, false);
        this.checkCanEdit(weight, "POSTED", false, false, false);
    }

    private void checkCanEdit(Act act, String status, boolean locked, boolean lockedWithExceptions, boolean unlocked) {
        act.setStatus(status);
        Assert.assertEquals((Object)locked, (Object)this.locked1.canEditStartTime(act));
        Assert.assertEquals((Object)lockedWithExceptions, (Object)this.lockedExceptFormsAndLetters.canEditStartTime(act));
        Assert.assertEquals((Object)unlocked, (Object)this.lockingDisabled.canEditStartTime(act));
    }

    private DefaultPatientHistoryDatingPolicy createPolicy(Period period, boolean editFormsAndLetters) {
        PracticeService service = (PracticeService)Mockito.mock(PracticeService.class);
        Mockito.when((Object)service.getRecordLockPeriod()).thenReturn((Object)period);
        return new DefaultPatientHistoryDatingPolicy(editFormsAndLetters, this.getArchetypeService(), service);
    }
}

