/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.history;

import java.util.Date;
import java.util.List;
import org.apache.commons.collections.ComparatorUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.app.SelectionHistory;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.history.CustomerPatient;
import org.openvpms.web.workspace.history.CustomerPatientHistoryQuery;

public class CustomerPatientHistoryQueryTestCase
extends AbstractAppTest {
    @Test
    public void testQuery() throws Exception {
        int i;
        int count = 10;
        LocalContext context = new LocalContext();
        SelectionHistory patients = new SelectionHistory((Context)context);
        SelectionHistory customers = new SelectionHistory((Context)context);
        for (int i2 = 0; i2 < count; ++i2) {
            Party patient = TestHelper.createPatient((boolean)true);
            patients.add((IMObject)patient);
            Thread.sleep(100L);
            Party customer = TestHelper.createCustomer((boolean)true);
            customers.add((IMObject)customer);
            if (i2 < 5) continue;
            this.addOwnerRelationship(customer, patient);
        }
        CustomerPatientHistoryQuery query = new CustomerPatientHistoryQuery(customers, patients, (Context)context);
        query.setMaxResults(-1);
        ResultSet results = query.query();
        IPage page = results.getPage(0);
        List list = page.getResults();
        Assert.assertEquals((long)15L, (long)list.size());
        List customerHistory = customers.getSelections();
        List patientHistory = patients.getSelections();
        for (i = 0; i < 5; ++i) {
            this.checkCustomerPatient((CustomerPatient)list.get(i), (SelectionHistory.Selection)customerHistory.get(i), (SelectionHistory.Selection)patientHistory.get(i));
        }
        i = 5;
        while (i < list.size()) {
            for (int j = 5; j < 10; ++j) {
                this.checkCustomer((CustomerPatient)list.get(i), (SelectionHistory.Selection)customerHistory.get(j));
                this.checkPatient((CustomerPatient)list.get(++i), (SelectionHistory.Selection)patientHistory.get(j));
                ++i;
            }
        }
    }

    @Test
    public void testSort() {
        LocalContext context = new LocalContext();
        SelectionHistory patients = new SelectionHistory((Context)context);
        SelectionHistory customers = new SelectionHistory((Context)context);
        Party customer1 = TestHelper.createCustomer((String)"", (String)"XC", (boolean)true);
        Party customer2 = TestHelper.createCustomer((String)"", (String)"XA", (boolean)true);
        Party customer3 = TestHelper.createCustomer((String)"", (String)"XB", (boolean)true);
        Party patient1 = TestHelper.createPatient();
        patient1.setName("XPatient-XB");
        Party patient2 = TestHelper.createPatient();
        patient2.setName("XPatient-XA");
        this.save((IMObject[])new Party[]{patient1, patient2});
        customers.add((IMObject)customer1);
        customers.add((IMObject)customer2);
        customers.add((IMObject)customer3);
        patients.add((IMObject)patient1);
        patients.add((IMObject)patient2);
        CustomerPatientHistoryQuery query = new CustomerPatientHistoryQuery(customers, patients, (Context)context);
        query.setMaxResults(-1);
        this.checkSortCustomer(query, true, null, null, customer2, customer3, customer1);
        this.checkSortPatient(query, true, null, null, null, patient2, patient1);
        this.checkSortCustomer(query, false, customer1, customer3, customer2, null, null);
        this.checkSortPatient(query, false, patient1, patient2, null, null, null);
    }

    @Test
    public void testFilter() throws Exception {
        LocalContext context = new LocalContext();
        SelectionHistory patients = new SelectionHistory((Context)context);
        SelectionHistory customers = new SelectionHistory((Context)context);
        Party customer1 = TestHelper.createCustomer((String)"", (String)"XC", (boolean)true);
        Party customer2 = TestHelper.createCustomer((String)"", (String)"XA", (boolean)true);
        Party customer3 = TestHelper.createCustomer((String)"", (String)"XB", (boolean)true);
        Party patient1 = TestHelper.createPatient();
        patient1.setName("XPatient-XA");
        Party patient2 = TestHelper.createPatient();
        patient2.setName("XPatient-XB");
        this.save((IMObject[])new Party[]{patient1, patient2});
        customers.add((IMObject)customer1);
        customers.add((IMObject)customer2);
        customers.add((IMObject)customer3);
        Thread.sleep(100L);
        patients.add((IMObject)patient1);
        patients.add((IMObject)patient2);
        CustomerPatientHistoryQuery query = new CustomerPatientHistoryQuery(customers, patients, (Context)context);
        query.setMaxResults(-1);
        query.setValue("XA");
        List list = query.query().getPage(0).getResults();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertNull((Object)((CustomerPatient)list.get(0)).getCustomer());
        Assert.assertEquals((Object)patient1, (Object)((CustomerPatient)list.get(0)).getPatient());
        Assert.assertNull((Object)((CustomerPatient)list.get(1)).getPatient());
        Assert.assertEquals((Object)customer2, (Object)((CustomerPatient)list.get(1)).getCustomer());
    }

    private void checkCustomerPatient(CustomerPatient pair, SelectionHistory.Selection customer, SelectionHistory.Selection patient) {
        Assert.assertEquals((Object)customer.getObject(), (Object)pair.getCustomer());
        Assert.assertEquals((Object)patient.getObject(), (Object)pair.getPatient());
        Date expected = (Date)ComparatorUtils.max((Object)customer.getTime(), (Object)patient.getTime(), null);
        Assert.assertEquals((Object)expected, (Object)pair.getSelected());
    }

    private void checkCustomer(CustomerPatient pair, SelectionHistory.Selection customer) {
        Assert.assertEquals((Object)customer.getObject(), (Object)pair.getCustomer());
        Assert.assertNull((Object)pair.getPatient());
        Assert.assertEquals((Object)customer.getTime(), (Object)pair.getSelected());
    }

    private void checkPatient(CustomerPatient pair, SelectionHistory.Selection patient) {
        Assert.assertEquals((Object)patient.getObject(), (Object)pair.getPatient());
        Assert.assertNull((Object)pair.getCustomer());
        Assert.assertEquals((Object)patient.getTime(), (Object)pair.getSelected());
    }

    private void checkSortCustomer(CustomerPatientHistoryQuery query, boolean ascending, Party ... expected) {
        List<CustomerPatient> list = this.query(query, "customer", ascending);
        Assert.assertEquals((long)expected.length, (long)list.size());
        for (int i = 0; i < list.size(); ++i) {
            Assert.assertEquals((Object)expected[i], (Object)list.get(i).getCustomer());
        }
    }

    private void checkSortPatient(CustomerPatientHistoryQuery query, boolean ascending, Party ... expected) {
        List<CustomerPatient> list = this.query(query, "patient", ascending);
        Assert.assertEquals((long)expected.length, (long)list.size());
        for (int i = 0; i < list.size(); ++i) {
            Assert.assertEquals((Object)expected[i], (Object)list.get(i).getPatient());
        }
    }

    private List<CustomerPatient> query(CustomerPatientHistoryQuery query, String node, boolean ascending) {
        SortConstraint[] sort = new SortConstraint[]{new NodeSortConstraint(node, ascending)};
        ResultSet results = query.query(sort);
        IPage page = results.getPage(0);
        return page.getResults();
    }

    private void addOwnerRelationship(Party customer, Party patient) {
        IMObjectBean bean = this.getBean((IMObject)customer);
        bean.addTarget("patients", "entityRelationship.patientOwner", (IMObject)patient, "customers");
        this.save((IMObject[])new Party[]{customer, patient});
    }
}

