/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.order;

import org.apache.commons.lang3.mutable.MutableBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.order.OrderRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCreditItemVerifier;
import org.openvpms.archetype.test.builder.customer.account.TestCreditVerifier;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemVerifier;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceVerifier;
import org.openvpms.archetype.test.builder.customer.order.TestPharmacyOrderBuilder;
import org.openvpms.archetype.test.builder.customer.order.TestPharmacyOrderItemBuilder;
import org.openvpms.archetype.test.builder.customer.order.TestPharmacyReturnBuilder;
import org.openvpms.archetype.test.builder.customer.order.TestPharmacyReturnItemBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestMerchandiseProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.dialog.OptionDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditDialog;
import org.openvpms.web.workspace.customer.order.OrderCharger;
import org.openvpms.web.workspace.customer.order.OrderChargerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderChargerTestCase
extends AbstractAppTest {
    @Autowired
    private CustomerAccountRules accountRules;
    @Autowired
    private OrderRules orderRules;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    private OrderChargerFactory factory;

    @Before
    public void setUp() {
        super.setUp();
        Assert.assertNotNull((Object)this.applicationContext);
        IArchetypeService service = (IArchetypeService)this.applicationContext.getBean("archetypeService", IArchetypeService.class);
        IArchetypeRuleService ruleService = (IArchetypeRuleService)this.getArchetypeService();
        this.factory = new OrderChargerFactory(this.orderRules, this.accountRules, service, ruleService);
    }

    @Test
    public void testInvoicePharmacyOrderForDifferentCustomer() {
        Party customer1 = this.customerFactory.createCustomer();
        Party patient1 = this.patientFactory.createPatient(customer1);
        Party customer2 = this.customerFactory.createCustomer();
        Party patient2 = this.patientFactory.createPatient(customer2);
        Party practice = this.practiceFactory.getPractice();
        Party location = this.practiceFactory.createLocation();
        LocalContext context = new LocalContext();
        context.setPractice(practice);
        context.setLocation(location);
        context.setCustomer(customer1);
        context.setPatient(patient1);
        Product product = (Product)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().unitPrice(1)).build();
        FinancialAct order = (FinancialAct)((TestPharmacyOrderBuilder)((TestPharmacyOrderItemBuilder)((TestPharmacyOrderItemBuilder)((TestPharmacyOrderItemBuilder)((TestPharmacyOrderBuilder)this.customerFactory.newPharmacyOrder().customer(customer2)).item().patient(patient2)).product(product)).quantity(1)).add()).build();
        OrderCharger charger = this.factory.create(customer2, (Context)context, new HelpContext("foo", null));
        MutableBoolean completed = new MutableBoolean();
        charger.charge(order, () -> ((MutableBoolean)completed).setTrue());
        CustomerChargeActEditDialog dialog = (CustomerChargeActEditDialog)EchoTestHelper.getWindowPane(CustomerChargeActEditDialog.class);
        EditorTestHelper.assertValid((Modifiable)dialog.getEditor());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        Assert.assertTrue((boolean)completed.isTrue());
        FinancialAct invoice = (FinancialAct)this.get((IMObject)dialog.getEditor().getObject());
        TestInvoiceVerifier verifier = (TestInvoiceVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceVerifier)((TestInvoiceVerifier)((TestInvoiceVerifier)new TestInvoiceVerifier((ArchetypeService)this.getArchetypeService()).customer(customer2)).amount(1)).status("IN_PROGRESS")).item().patient(patient2)).product(product)).quantity(1)).unitPrice(1)).receivedQuantity(1).total(1)).status(null)).add();
        verifier.verify((IMObject)invoice);
        Assert.assertEquals((Object)"POSTED", (Object)((FinancialAct)this.get((IMObject)order)).getStatus());
    }

    @Test
    public void testCreditPharmacyReturnForDifferentCustomer() {
        Party customer1 = this.customerFactory.createCustomer();
        Party patient1 = this.patientFactory.createPatient(customer1);
        Party customer2 = this.customerFactory.createCustomer();
        Party patient2 = this.patientFactory.createPatient(customer2);
        Party practice = this.practiceFactory.getPractice();
        Party location = this.practiceFactory.createLocation();
        LocalContext context = new LocalContext();
        context.setPractice(practice);
        context.setLocation(location);
        context.setCustomer(customer1);
        context.setPatient(patient1);
        Product product = (Product)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().unitPrice(1)).build();
        FinancialAct pharmacyReturn = (FinancialAct)((TestPharmacyReturnBuilder)((TestPharmacyReturnItemBuilder)((TestPharmacyReturnItemBuilder)((TestPharmacyReturnItemBuilder)((TestPharmacyReturnBuilder)this.customerFactory.newPharmacyReturn().customer(customer2)).item().patient(patient2)).product(product)).quantity(1)).add()).build();
        OrderCharger charger = this.factory.create(customer2, (Context)context, new HelpContext("foo", null));
        MutableBoolean completed = new MutableBoolean();
        charger.charge(pharmacyReturn, () -> ((MutableBoolean)completed).setTrue());
        OptionDialog optionDialog = (OptionDialog)EchoTestHelper.getWindowPane(OptionDialog.class);
        optionDialog.setSelected(0);
        EchoTestHelper.fireDialogButton((PopupDialog)optionDialog, (String)"ok");
        CustomerChargeActEditDialog dialog = (CustomerChargeActEditDialog)EchoTestHelper.getWindowPane(CustomerChargeActEditDialog.class);
        EditorTestHelper.assertValid((Modifiable)dialog.getEditor());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        Assert.assertTrue((boolean)completed.isTrue());
        FinancialAct credit = (FinancialAct)this.get((IMObject)dialog.getEditor().getObject());
        TestCreditVerifier verifier = (TestCreditVerifier)((TestCreditItemVerifier)((TestCreditItemVerifier)((TestCreditItemVerifier)((TestCreditItemVerifier)((TestCreditItemVerifier)((TestCreditItemVerifier)((TestCreditVerifier)((TestCreditVerifier)((TestCreditVerifier)new TestCreditVerifier((ArchetypeService)this.getArchetypeService()).customer(customer2)).amount(1)).status("IN_PROGRESS")).item().patient(patient2)).product(product)).quantity(1)).unitPrice(1)).total(1)).status(null)).add();
        verifier.verify((IMObject)credit);
        Assert.assertEquals((Object)"POSTED", (Object)((FinancialAct)this.get((IMObject)pharmacyReturn)).getStatus());
    }
}

