/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.patient.prescription.PrescriptionTestHelper;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemVerifier;
import org.openvpms.archetype.test.builder.hl7.TestHL7Factory;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestMerchandiseProductBuilder;
import org.openvpms.archetype.test.builder.product.TestServiceProductBuilder;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.doc.ParameterDialog;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.reminder.ReminderEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientParticipationEditor;
import org.openvpms.web.component.im.product.ProductParticipationEditor;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.charge.AbstractCustomerChargeActEditorTest;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeTestHelper;
import org.openvpms.web.workspace.customer.charge.DefaultCustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.customer.charge.InvestigationManager;
import org.openvpms.web.workspace.customer.charge.TestChargeEditor;
import org.openvpms.web.workspace.customer.charge.TestLaboratoryOrderService;
import org.openvpms.web.workspace.customer.charge.TestPharmacyOrderService;
import org.openvpms.web.workspace.patient.mr.PatientMedicationActEditor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class DefaultCustomerChargeActEditorTestCase
extends AbstractCustomerChargeActEditorTest {
    private Party customer;
    private Party patient;
    private User author;
    private User clinician;
    private Party location;
    private LayoutContext layoutContext;
    @Autowired
    private MedicalRecordRules records;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestHL7Factory hl7Factory;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient(this.customer);
        this.author = this.userFactory.createUser();
        this.clinician = this.userFactory.createClinician();
        this.location = this.practiceFactory.createLocation();
        this.layoutContext = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        this.layoutContext.setEdit(true);
        this.layoutContext.getContext().setPractice(this.getPractice());
        this.layoutContext.getContext().setCustomer(this.customer);
        this.layoutContext.getContext().setUser(this.author);
        this.layoutContext.getContext().setClinician(this.clinician);
        this.layoutContext.getContext().setLocation(this.location);
        new AuthenticationContextImpl().setUser(this.author);
    }

    @Test
    public void testEmptyInvoice() {
        this.checkEmptyCharge((FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class));
    }

    @Test
    public void testEmptyCredit() {
        this.checkEmptyCharge((FinancialAct)this.create("act.customerAccountChargesCredit", FinancialAct.class));
    }

    @Test
    public void testEmptyCounterSale() {
        this.checkEmptyCharge((FinancialAct)this.create("act.customerAccountChargesCounter", FinancialAct.class));
    }

    @Test
    public void testInvoice() {
        this.checkEditCharge("act.customerAccountChargesInvoice", "act.customerAccountInvoiceItem", true);
    }

    @Test
    public void testInvoiceWithDelayedOrderDiscontinuation() {
        this.checkEditCharge("act.customerAccountChargesInvoice", "act.customerAccountInvoiceItem", false);
    }

    @Test
    public void testCounterSale() {
        this.checkEditCharge("act.customerAccountChargesCounter", "act.customerAccountCounterItem", true);
    }

    @Test
    public void testCredit() {
        this.checkEditCharge("act.customerAccountChargesCredit", "act.customerAccountCreditItem", true);
    }

    @Test
    public void testAdd3Items() {
        BigDecimal itemTotal1 = BigDecimal.valueOf(20L);
        BigDecimal itemTotal2 = BigDecimal.valueOf(50L);
        BigDecimal itemTotal3 = new BigDecimal("41.25");
        Product product1 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("18.18")).build();
        Product product2 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("45.45")).build();
        Product product3 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("37.50")).build();
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        BigDecimal total = itemTotal1.add(itemTotal2).add(itemTotal3);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        BigDecimal quantity = BigDecimal.ONE;
        this.addItem((CustomerChargeActEditor)editor, this.patient, product1, quantity, queue);
        this.addItem((CustomerChargeActEditor)editor, this.patient, product2, quantity, queue);
        this.addItem((CustomerChargeActEditor)editor, this.patient, product3, quantity, queue);
        this.save((CustomerChargeActEditor)editor);
        this.checkTotal(charge, total);
    }

    @Test
    public void testAdd3ItemsWithDeletion() {
        BigDecimal itemTotal1 = BigDecimal.valueOf(20L);
        BigDecimal itemTotal2 = BigDecimal.valueOf(50L);
        BigDecimal itemTotal3 = new BigDecimal("41.25");
        Product product1 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("18.18")).build();
        Product product2 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("45.45")).build();
        Product product3 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("37.50")).build();
        int j = 0;
        for (int i = 0; i < 3; ++i) {
            FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
            BigDecimal total = itemTotal1.add(itemTotal2).add(itemTotal3);
            TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
            editor.getComponent();
            Assert.assertTrue((boolean)editor.isValid());
            BigDecimal quantity = BigDecimal.ONE;
            EditorQueue queue = editor.getQueue();
            CustomerChargeActItemEditor itemEditor1 = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, quantity, queue);
            CustomerChargeActItemEditor itemEditor2 = this.addItem((CustomerChargeActEditor)editor, this.patient, product2, quantity, queue);
            CustomerChargeActItemEditor itemEditor3 = this.addItem((CustomerChargeActEditor)editor, this.patient, product3, quantity, queue);
            this.save((CustomerChargeActEditor)editor);
            charge = (FinancialAct)this.get((IMObject)charge);
            this.checkEquals(total, charge.getTotal());
            ActCalculator calculator = new ActCalculator((ArchetypeService)this.getArchetypeService());
            BigDecimal itemTotal = calculator.sum((Act)charge, "items", "total");
            this.checkEquals(total, itemTotal);
            if (j == 0) {
                editor.delete((Act)itemEditor1.getObject());
                total = total.subtract(itemTotal1);
            } else if (j == 1) {
                editor.delete((Act)itemEditor2.getObject());
                total = total.subtract(itemTotal2);
            } else if (j == 2) {
                editor.delete((Act)itemEditor3.getObject());
                total = total.subtract(itemTotal3);
            }
            if (++j > 2) {
                j = 0;
            }
            this.save((CustomerChargeActEditor)editor);
            charge = (FinancialAct)this.get((IMObject)charge);
            this.checkTotal(charge, total);
        }
    }

    @Test
    public void testAdd3ItemsWithDeletionAfterReload() {
        BigDecimal itemTotal1 = BigDecimal.valueOf(20L);
        BigDecimal itemTotal2 = BigDecimal.valueOf(50L);
        BigDecimal itemTotal3 = new BigDecimal("41.25");
        Product product1 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("18.18")).build();
        Product product2 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("45.45")).build();
        Product product3 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("37.50")).build();
        int j = 0;
        for (int i = 0; i < 3; ++i) {
            FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
            BigDecimal total = itemTotal1.add(itemTotal2).add(itemTotal3);
            TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
            EditorQueue queue = editor.getQueue();
            editor.getComponent();
            Assert.assertTrue((boolean)editor.isValid());
            BigDecimal quantity = BigDecimal.ONE;
            CustomerChargeActItemEditor itemEditor1 = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, quantity, queue);
            CustomerChargeActItemEditor itemEditor2 = this.addItem((CustomerChargeActEditor)editor, this.patient, product2, quantity, queue);
            CustomerChargeActItemEditor itemEditor3 = this.addItem((CustomerChargeActEditor)editor, this.patient, product3, quantity, queue);
            this.save((CustomerChargeActEditor)editor);
            charge = (FinancialAct)this.get((IMObject)charge);
            this.checkTotal(charge, total);
            editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
            editor.getComponent();
            if (j == 0) {
                editor.delete((Act)itemEditor1.getObject());
                total = total.subtract(itemTotal1);
            } else if (j == 1) {
                editor.delete((Act)itemEditor2.getObject());
                total = total.subtract(itemTotal2);
            } else if (j == 2) {
                editor.delete((Act)itemEditor3.getObject());
                total = total.subtract(itemTotal3);
            }
            if (++j > 2) {
                j = 0;
            }
            this.save((CustomerChargeActEditor)editor);
            charge = (FinancialAct)this.get((IMObject)charge);
            this.checkTotal(charge, total);
        }
    }

    @Test
    public void test3ItemsAdditionWithDeletionBeforeSave() {
        BigDecimal itemTotal1 = BigDecimal.valueOf(20L);
        BigDecimal itemTotal2 = BigDecimal.valueOf(50L);
        BigDecimal itemTotal3 = new BigDecimal("41.25");
        Product product1 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("18.18")).build();
        Product product2 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("45.45")).build();
        Product product3 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("37.50")).build();
        int j = 0;
        for (int i = 0; i < 3; ++i) {
            FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
            BigDecimal total = itemTotal1.add(itemTotal2).add(itemTotal3);
            TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
            EditorQueue queue = editor.getQueue();
            editor.getComponent();
            BigDecimal quantity = BigDecimal.ONE;
            CustomerChargeActItemEditor itemEditor1 = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, quantity, queue);
            CustomerChargeActItemEditor itemEditor2 = this.addItem((CustomerChargeActEditor)editor, this.patient, product2, quantity, queue);
            CustomerChargeActItemEditor itemEditor3 = this.addItem((CustomerChargeActEditor)editor, this.patient, product3, quantity, queue);
            if (j == 0) {
                editor.delete((Act)itemEditor1.getObject());
                total = total.subtract(itemTotal1);
            } else if (j == 1) {
                editor.delete((Act)itemEditor2.getObject());
                total = total.subtract(itemTotal2);
            } else if (j == 2) {
                editor.delete((Act)itemEditor3.getObject());
                total = total.subtract(itemTotal3);
            }
            if (++j > 2) {
                j = 0;
            }
            this.save((CustomerChargeActEditor)editor);
            charge = (FinancialAct)this.get((IMObject)charge);
            this.checkTotal(charge, total);
        }
    }

    @Test
    public void testItemChange() {
        BigDecimal itemTotal1 = BigDecimal.valueOf(20L);
        BigDecimal itemTotal2 = BigDecimal.valueOf(50L);
        BigDecimal itemTotal3 = new BigDecimal("41.25");
        Product product1 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("18.18")).build();
        Product product2 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("45.45")).build();
        Product product3 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice("37.50")).build();
        int j = 0;
        for (int i = 0; i < 3; ++i) {
            CustomerChargeActItemEditor itemEditor1;
            FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
            BigDecimal total = itemTotal1.add(itemTotal2).add(itemTotal3);
            boolean addDefaultItem = j == 0;
            TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext, addDefaultItem);
            editor.getComponent();
            BigDecimal quantity = BigDecimal.ONE;
            if (j == 0) {
                itemEditor1 = editor.getCurrentEditor();
                this.setItem((CustomerChargeActEditor)editor, itemEditor1, this.patient, product1, quantity, editor.getQueue());
            } else {
                itemEditor1 = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, quantity, editor.getQueue());
            }
            CustomerChargeActItemEditor itemEditor2 = this.addItem((CustomerChargeActEditor)editor, this.patient, product2, quantity, editor.getQueue());
            if (j == 0) {
                itemEditor1.setProduct(product3);
                total = total.subtract(itemTotal1);
            } else if (j == 1) {
                itemEditor2.setProduct(product3);
                total = total.subtract(itemTotal2);
            }
            if (++j > 1) {
                j = 0;
            }
            this.save((CustomerChargeActEditor)editor);
            charge = (FinancialAct)this.get((IMObject)charge);
            this.checkTotal(charge, total);
        }
    }

    @Test
    public void testDeleteInvoice() {
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        BigDecimal fixedPrice = BigDecimal.TEN;
        BigDecimal itemTotal = BigDecimal.valueOf(11L);
        BigDecimal total = itemTotal.multiply(BigDecimal.valueOf(3L));
        Entity pharmacy = this.hl7Factory.createHL7Pharmacy(this.location, this.userFactory.createUser());
        Entity laboratory = this.laboratoryFactory.createHL7Laboratory(this.location, this.userFactory.createUser());
        Entity taskType1 = this.schedulingFactory.createTaskType();
        Entity taskType2 = this.schedulingFactory.createTaskType();
        Entity taskType3 = this.schedulingFactory.createTaskType();
        Entity workList = (Entity)this.schedulingFactory.newWorkList().taskTypes(new Entity[]{taskType1, taskType2, taskType3}).build();
        Entity alertType1 = this.createAlertType();
        Product product1 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).pharmacy(pharmacy)).addAlertTypes(new Entity[]{alertType1})).newProductTask().taskType(taskType1).workList(workList).start(0, DateUnits.DAYS).add()).build();
        Entity reminderType1 = this.addReminder(product1);
        Entity investigationType1 = this.laboratoryFactory.createInvestigationType();
        this.addHL7Test(product1, investigationType1);
        Entity template1 = this.addDocumentTemplate(product1);
        Entity alertType2 = this.createAlertType();
        Product product2 = (Product)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(fixedPrice)).pharmacy(pharmacy)).addAlertTypes(new Entity[]{alertType2})).newProductTask().taskType(taskType2).workList(workList).start(0, DateUnits.DAYS).add()).build();
        Entity reminderType2 = this.addReminder(product2);
        Entity investigationType2 = this.laboratoryFactory.createInvestigationType();
        Entity investigationType3 = this.laboratoryFactory.createInvestigationType();
        this.addHL7Test(product2, investigationType2);
        this.addHL7Test(product2, investigationType3);
        Entity template2 = this.addDocumentTemplate(product2, "act.patientDocumentLetter");
        Entity alertType3 = this.createAlertType();
        Product product3 = (Product)((TestServiceProductBuilder)((TestServiceProductBuilder)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice(fixedPrice)).addAlertTypes(new Entity[]{alertType3})).newProductTask().taskType(taskType3).workList(workList).start(0, DateUnits.DAYS).add()).build();
        Entity reminderType3 = this.addReminder(product3);
        Entity investigationType4 = this.laboratoryFactory.createInvestigationType(laboratory);
        this.addHL7Test(product3, investigationType4);
        Entity investigationType5 = this.laboratoryFactory.createInvestigationType();
        Entity investigationType6 = this.laboratoryFactory.createInvestigationType();
        this.addHL7Test(product3, investigationType5);
        this.addHL7Test(product3, investigationType6);
        Entity template3 = this.addDocumentTemplate(product3);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        BigDecimal quantity = BigDecimal.ONE;
        CustomerChargeActItemEditor item1Editor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, quantity, queue);
        CustomerChargeActItemEditor item2Editor = this.addItem((CustomerChargeActEditor)editor, this.patient, product2, quantity, queue);
        CustomerChargeActItemEditor item3Editor = this.addItem((CustomerChargeActEditor)editor, this.patient, product3, quantity, queue);
        FinancialAct item1 = item1Editor.getObject();
        FinancialAct item2 = item2Editor.getObject();
        FinancialAct item3 = item3Editor.getObject();
        this.save((CustomerChargeActEditor)editor);
        editor.postSave(queue, false, new MutableBoolean(false));
        this.checkPatientAndProductReadOnly(item1Editor, true);
        this.checkPatientAndProductReadOnly(item2Editor, true);
        this.checkPatientAndProductReadOnly(item3Editor, true);
        List<TestPharmacyOrderService.Order> orders = editor.getPharmacyOrderService().getOrders();
        Assert.assertEquals((long)2L, (long)orders.size());
        editor.getPharmacyOrderService().clear();
        List<TestLaboratoryOrderService.LabOrder> labOrders = editor.getLaboratoryOrderService().getOrders();
        Assert.assertEquals((long)1L, (long)labOrders.size());
        editor.getLaboratoryOrderService().clear();
        BigDecimal balance = charge.isCredit() ? total.negate() : total;
        this.checkBalance(this.customer, balance, BigDecimal.ZERO);
        DocumentAct investigation1 = this.getInvestigation((Act)item1, investigationType1);
        DocumentAct investigation2 = this.getInvestigation((Act)item2, investigationType2);
        DocumentAct investigation3 = this.getInvestigation((Act)item2, investigationType3);
        DocumentAct investigation4 = this.getInvestigation((Act)item3, investigationType4);
        DocumentAct investigation5 = this.getInvestigation((Act)item3, investigationType5);
        DocumentAct investigation6 = this.getInvestigation((Act)item3, investigationType6);
        PatientTestHelper.addReport((DocumentAct)investigation4);
        PatientTestHelper.addReport((DocumentAct)investigation5);
        investigation1.setStatus("IN_PROGRESS");
        investigation2.setStatus("POSTED");
        investigation3.setStatus("IN_PROGRESS");
        investigation4.setStatus("IN_PROGRESS");
        investigation5.setStatus("CANCELLED");
        investigation6.setStatus("POSTED");
        this.save((IMObject[])new DocumentAct[]{investigation1, investigation2, investigation3, investigation4, investigation5, investigation6});
        Act reminder1 = this.getReminder((Act)item1, reminderType1);
        Act reminder2 = this.getReminder((Act)item2, reminderType2);
        Act reminder3 = this.getReminder((Act)item3, reminderType3);
        reminder1.setStatus("IN_PROGRESS");
        reminder2.setStatus("COMPLETED");
        reminder3.setStatus("CANCELLED");
        this.save((IMObject[])new Act[]{reminder1, reminder2, reminder3});
        DocumentAct doc1 = this.getDocument((Act)item1, template1);
        DocumentAct doc2 = this.getDocument((Act)item2, template2);
        DocumentAct doc3 = this.getDocument((Act)item3, template3);
        doc1.setStatus("IN_PROGRESS");
        doc2.setStatus("COMPLETED");
        doc3.setStatus("POSTED");
        this.save((IMObject[])new Act[]{doc1, doc2, doc3});
        Act alert1 = this.getAlert((Act)item1, alertType1);
        Act alert2 = this.getAlert((Act)item2, alertType2);
        Act alert3 = this.getAlert((Act)item3, alertType3);
        alert1.setStatus("IN_PROGRESS");
        alert2.setStatus("COMPLETED");
        alert3.setStatus("COMPLETED");
        this.save((IMObject[])new Act[]{alert1, alert2, alert3});
        Act task1 = this.getTask((Act)item1, taskType1);
        Act task2 = this.getTask((Act)item2, taskType2);
        Act task3 = this.getTask((Act)item3, taskType3);
        task1.setStatus("IN_PROGRESS");
        task2.setStatus("BILLED");
        task3.setStatus("COMPLETED");
        this.save((IMObject[])new Act[]{task1, task2, task3});
        charge = (FinancialAct)this.get((IMObject)charge);
        IMObjectBean bean = this.getBean((IMObject)charge);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)3L, (long)items.size());
        Assert.assertTrue((boolean)this.delete(editor));
        Assert.assertNull((Object)this.get((IMObject)charge));
        for (FinancialAct item : items) {
            Assert.assertNull((Object)this.get((IMObject)item));
        }
        orders = editor.getPharmacyOrderService().getOrders(true);
        Assert.assertEquals((long)2L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.CANCEL, this.patient, product1, quantity, item1.getId(), item1.getActivityStartTime(), this.clinician, pharmacy);
        CustomerChargeTestHelper.checkOrder(orders.get(1), TestPharmacyOrderService.Order.Type.CANCEL, this.patient, product2, quantity, item2.getId(), item2.getActivityStartTime(), this.clinician, pharmacy);
        labOrders = editor.getLaboratoryOrderService().getOrders();
        Assert.assertEquals((long)1L, (long)labOrders.size());
        CustomerChargeTestHelper.checkOrder(labOrders.get(0), TestLaboratoryOrderService.LabOrder.Type.CANCEL, this.patient, investigation4.getId(), investigation4.getActivityStartTime(), this.clinician, laboratory);
        Assert.assertNull((Object)this.get((IMObject)investigation1));
        Assert.assertNotNull((Object)this.get((IMObject)investigation2));
        Assert.assertNull((Object)this.get((IMObject)investigation3));
        Assert.assertNotNull((Object)this.get((IMObject)investigation4));
        Assert.assertNotNull((Object)this.get((IMObject)investigation5));
        Assert.assertNotNull((Object)this.get((IMObject)investigation6));
        Assert.assertNull((Object)this.get((IMObject)reminder1));
        Assert.assertNotNull((Object)this.get((IMObject)reminder2));
        Assert.assertNull((Object)this.get((IMObject)reminder3));
        Assert.assertNull((Object)this.get((IMObject)doc1));
        Assert.assertNotNull((Object)this.get((IMObject)doc2));
        Assert.assertNotNull((Object)this.get((IMObject)doc3));
        Assert.assertNull((Object)this.get((IMObject)alert1));
        Assert.assertNotNull((Object)this.get((IMObject)alert2));
        Assert.assertNotNull((Object)this.get((IMObject)alert3));
        Assert.assertNull((Object)this.get((IMObject)task1));
        Assert.assertNotNull((Object)this.get((IMObject)task2));
        Assert.assertNotNull((Object)this.get((IMObject)task3));
        this.checkBalance(this.customer, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    @Test
    public void testDeleteCredit() {
        this.checkDeleteCharge((FinancialAct)this.create("act.customerAccountChargesCredit", FinancialAct.class));
    }

    @Test
    public void testDeleteCounterSale() {
        this.checkDeleteCharge((FinancialAct)this.create("act.customerAccountChargesCounter", FinancialAct.class));
    }

    @Test
    public void testInvoiceStockUpdate() {
        this.checkChargeStockUpdate((FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class));
    }

    @Test
    public void testCreditStockUpdate() {
        this.checkChargeStockUpdate((FinancialAct)this.create("act.customerAccountChargesCredit", FinancialAct.class));
    }

    @Test
    public void testCounterSaleStockUpdate() {
        this.checkChargeStockUpdate((FinancialAct)this.create("act.customerAccountChargesCounter", FinancialAct.class));
    }

    @Test
    public void testExpandTemplateInvoice() {
        this.checkExpandTemplate((FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class), "act.customerAccountInvoiceItem");
    }

    @Test
    public void testExpandTemplateCredit() {
        this.checkExpandTemplate((FinancialAct)this.create("act.customerAccountChargesCredit", FinancialAct.class), "act.customerAccountCreditItem");
    }

    @Test
    public void testExpandTemplateCounterSale() {
        this.checkExpandTemplate((FinancialAct)this.create("act.customerAccountChargesCounter", FinancialAct.class), "act.customerAccountCounterItem");
    }

    @Test
    public void testTotalMismatch() {
        BigDecimal itemTotal = BigDecimal.valueOf(20L);
        Product product1 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice(itemTotal)).build();
        List acts = FinancialTestHelper.createChargesInvoice((BigDecimal)itemTotal, (Party)this.customer, (Party)this.patient, (Product)product1, (String)"IN_PROGRESS");
        this.save(acts);
        FinancialAct charge = (FinancialAct)acts.get(0);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        editor.getComponent();
        charge.setTotal((BigDecimal)Money.ONE);
        Assert.assertFalse((boolean)editor.isValid());
        DefaultValidator validator = new DefaultValidator();
        Assert.assertFalse((boolean)editor.validate((Validator)validator));
        List list = validator.getErrors((Modifiable)editor);
        Assert.assertEquals((long)1L, (long)list.size());
        String message = Messages.format((String)"act.validation.totalMismatch", (Object[])new Object[]{editor.getProperty("amount").getDisplayName(), NumberFormatter.formatCurrency((Number)charge.getTotal()), editor.getProperty("items").getDisplayName(), NumberFormatter.formatCurrency((Number)itemTotal)});
        String expected = Messages.format((String)ValidatorError.MSG_KEY, (Object[])new Object[]{message});
        Assert.assertEquals((Object)expected, (Object)((ValidatorError)list.get(0)).toString());
    }

    @Test
    public void testPrescription() {
        this.checkPrescription(this.clinician, this.clinician);
    }

    @Test
    public void testPrescriptionWithNoClinician() {
        this.checkPrescription(this.clinician, null);
    }

    @Test
    public void testDeleteInvoiceItemLinkedToPrescription() {
        Product product1 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(1)).build();
        Product product2 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(1)).build();
        Act prescription = PrescriptionTestHelper.createPrescription((Party)this.patient, (Product)product1, (User)this.clinician);
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor1 = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.ONE, queue);
        this.addItem((CustomerChargeActEditor)editor, this.patient, product2, BigDecimal.ONE, queue);
        this.save((CustomerChargeActEditor)editor);
        this.checkPrescription(prescription, itemEditor1);
        editor.removeItem((Act)itemEditor1.getObject());
        this.save((CustomerChargeActEditor)editor);
        prescription = (Act)this.get((IMObject)prescription);
        IMObjectBean bean = this.getBean((IMObject)prescription);
        Assert.assertTrue((boolean)bean.getTargets("dispensing").isEmpty());
    }

    @Test
    public void testDeleteUnsavedInvoiceItemWithPrescription() {
        this.checkDeleteUnsavedItemWithPrescription((FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class));
    }

    @Test
    public void testDeleteUnsavedCreditItem() {
        this.checkDeleteUnsavedItemWithPrescription((FinancialAct)this.create("act.customerAccountChargesCredit", FinancialAct.class));
    }

    @Test
    public void testDeleteUnsavedCounterItem() {
        this.checkDeleteUnsavedItemWithPrescription((FinancialAct)this.create("act.customerAccountChargesCounter", FinancialAct.class));
    }

    @Test
    public void testInitClinician() {
        Entity alertType1 = this.createAlertType();
        Product product1 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(1)).addAlertTypes(new Entity[]{alertType1})).build();
        Entity reminderType1 = this.addReminder(product1);
        Entity investigationType1 = this.laboratoryFactory.createInvestigationType();
        this.addHL7Test(product1, investigationType1);
        Entity template1 = this.addDocumentTemplate(product1);
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.ONE, queue);
        FinancialAct item = itemEditor.getObject();
        Assert.assertTrue((boolean)editor.isValid());
        this.checkPatientAndProductReadOnly(itemEditor, false);
        this.save((CustomerChargeActEditor)editor);
        this.checkPatientAndProductReadOnly(itemEditor, false);
        Act medication = (Act)this.getBean((IMObject)item).getTarget("dispensing", Act.class);
        Assert.assertNotNull((Object)medication);
        Act reminder = this.getReminder((Act)item, reminderType1);
        Act alert = this.getAlert((Act)item, alertType1);
        DocumentAct investigation = this.getInvestigation((Act)item, investigationType1);
        DocumentAct document = this.getDocument((Act)item, template1);
        this.checkClinician(medication, this.clinician);
        this.checkClinician(reminder, this.clinician);
        this.checkClinician(alert, this.clinician);
        this.checkClinician((Act)investigation, this.clinician);
        this.checkClinician((Act)document, this.clinician);
    }

    @Test
    public void testChangePatient() {
        Product product1 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(1)).build();
        Entity investigationType1 = this.laboratoryFactory.createInvestigationType();
        this.addHL7Test(product1, investigationType1);
        Entity template1 = this.addDocumentTemplate(product1);
        Party patient2 = this.patientFactory.createPatient(this.customer);
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.ONE, editor.getQueue());
        FinancialAct item = itemEditor.getObject();
        Assert.assertTrue((boolean)editor.isValid());
        this.checkPatientAndProductReadOnly(itemEditor, false);
        this.save((CustomerChargeActEditor)editor);
        this.checkPatientAndProductReadOnly(itemEditor, false);
        Act event1 = this.records.getEvent(this.patient);
        Act medication = (Act)this.getBean((IMObject)item).getTarget("dispensing", Act.class);
        Assert.assertNotNull((Object)event1);
        Assert.assertNotNull((Object)medication);
        DocumentAct investigation = this.getInvestigation((Act)item, investigationType1);
        DocumentAct document = this.getDocument((Act)item, template1);
        this.checkEventRelationships(event1, new Act[]{item, medication, investigation, document});
        editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        item = (FinancialAct)editor.getItems().getActs().get(0);
        itemEditor = editor.getEditor((Act)item);
        itemEditor.getComponent();
        itemEditor.setPatient(patient2);
        CustomerChargeTestHelper.checkSavePopup(editor.getQueue(), "act.patientInvestigation", false);
        Assert.assertTrue((boolean)editor.isValid());
        this.save((CustomerChargeActEditor)editor);
        event1 = (Act)this.get((IMObject)event1);
        medication = (Act)this.get((IMObject)medication);
        Act event2 = this.records.getEvent(patient2);
        investigation = this.getInvestigation((Act)item, investigationType1);
        document = this.getDocument((Act)item, template1);
        this.checkEventRelationships(event2, new Act[]{item, medication, investigation, document});
        Assert.assertEquals((long)0L, (long)event1.getSourceActRelationships().size());
    }

    @Test
    public void testChangePharmacyOrderQuantity() {
        Entity pharmacy = this.hl7Factory.createHL7Pharmacy(this.location, this.userFactory.createUser());
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(10)).pharmacy(pharmacy)).build();
        Act visit = this.patientFactory.createVisit(this.patient, this.location);
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product, BigDecimal.TEN, queue);
        FinancialAct item = itemEditor.getObject();
        this.save((CustomerChargeActEditor)editor);
        List<TestPharmacyOrderService.Order> orders = editor.getPharmacyOrderService().getOrders(true);
        Assert.assertEquals((long)1L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product, BigDecimal.TEN, item.getId(), item.getActivityStartTime(), this.clinician, pharmacy);
        TestInvoiceItemVerifier verifier = ((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)new TestInvoiceItemVerifier((ArchetypeService)this.getArchetypeService()).patient(this.patient)).product(product)).quantity(BigDecimal.TEN)).fixedPrice(11)).tax(1)).total(11)).clinician(this.clinician)).createdBy(this.author)).visit(visit).status("ORDERED")).receivedQuantity(null).returnedQuantity(null);
        verifier.verify(this.get((IMObject)item));
        editor.getPharmacyOrderService().clear();
        itemEditor.setQuantity(BigDecimal.ONE);
        this.save((CustomerChargeActEditor)editor);
        orders = editor.getPharmacyOrderService().getOrders(true);
        Assert.assertEquals((long)1L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.UPDATE, this.patient, product, BigDecimal.ONE, item.getId(), item.getActivityStartTime(), this.clinician, pharmacy);
        ((TestInvoiceItemVerifier)verifier.quantity(BigDecimal.ONE)).verify(this.get((IMObject)item));
    }

    @Test
    public void testDeleteInvoiceItemWithPharmacyOrder() {
        Entity pharmacy = this.hl7Factory.createHL7Pharmacy(this.location, this.userFactory.createUser());
        Product product1 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(10)).pharmacy(pharmacy)).build();
        Product product2 = (Product)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(10)).pharmacy(pharmacy)).build();
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        FinancialAct item1 = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.TEN, queue).getObject();
        FinancialAct item2 = this.addItem((CustomerChargeActEditor)editor, this.patient, product2, BigDecimal.ONE, queue).getObject();
        this.save((CustomerChargeActEditor)editor);
        List<TestPharmacyOrderService.Order> orders = editor.getPharmacyOrderService().getOrders(true);
        Assert.assertEquals((long)2L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product1, BigDecimal.TEN, item1.getId(), item1.getActivityStartTime(), this.clinician, pharmacy);
        CustomerChargeTestHelper.checkOrder(orders.get(1), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product2, BigDecimal.ONE, item2.getId(), item2.getActivityStartTime(), this.clinician, pharmacy);
        editor.getPharmacyOrderService().clear();
        editor.delete((Act)item1);
        this.save((CustomerChargeActEditor)editor);
        orders = editor.getPharmacyOrderService().getOrders(true);
        Assert.assertEquals((long)1L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.CANCEL, this.patient, product1, BigDecimal.TEN, item1.getId(), item1.getActivityStartTime(), this.clinician, pharmacy);
    }

    @Test
    public void testOneWayPharmacy() {
        Entity pharmacy = this.hl7Factory.createHL7Pharmacy(this.location, true, this.userFactory.createUser());
        Product product1 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(10)).pharmacy(pharmacy)).build();
        Act visit = this.patientFactory.createVisit(this.patient, this.location);
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.TEN, queue);
        FinancialAct item = itemEditor.getObject();
        this.save((CustomerChargeActEditor)editor);
        List<TestPharmacyOrderService.Order> orders1 = editor.getPharmacyOrderService().getOrders();
        Assert.assertEquals((long)1L, (long)orders1.size());
        CustomerChargeTestHelper.checkOrder(orders1.get(0), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product1, BigDecimal.TEN, item.getId(), item.getActivityStartTime(), this.clinician, pharmacy);
        TestInvoiceItemVerifier verifier = ((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)((TestInvoiceItemVerifier)new TestInvoiceItemVerifier((ArchetypeService)this.getArchetypeService()).patient(this.patient)).product(product1)).quantity(BigDecimal.TEN)).fixedPrice(11)).tax(1)).total(11)).clinician(this.clinician)).createdBy(this.author)).visit(visit).status("ORDERED")).receivedQuantity(BigDecimal.TEN).returnedQuantity(null);
        verifier.verify(this.get((IMObject)item));
        editor.getPharmacyOrderService().clear();
        itemEditor.setQuantity(BigDecimal.ONE);
        this.save((CustomerChargeActEditor)editor);
        List<TestPharmacyOrderService.Order> orders2 = editor.getPharmacyOrderService().getOrders();
        Assert.assertEquals((long)1L, (long)orders2.size());
        CustomerChargeTestHelper.checkOrder(orders2.get(0), TestPharmacyOrderService.Order.Type.UPDATE, this.patient, product1, BigDecimal.ONE, item.getId(), item.getActivityStartTime(), this.clinician, pharmacy);
        ((TestInvoiceItemVerifier)verifier.quantity(BigDecimal.ONE)).receivedQuantity(BigDecimal.ONE).verify(this.get((IMObject)item));
    }

    @Test
    public void testDeleteInvoiceItemWithLaboratoryOrder() {
        Entity laboratory = CustomerChargeTestHelper.createHL7Laboratory(this.location);
        Entity investigationType1 = this.laboratoryFactory.createInvestigationType(laboratory);
        Product product1 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice(10)).build();
        this.addHL7Test(product1, investigationType1);
        Product product2 = (Product)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(10)).build();
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor1 = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.TEN, queue);
        CustomerChargeActItemEditor itemEditor2 = this.addItem((CustomerChargeActEditor)editor, this.patient, product2, BigDecimal.ONE, queue);
        FinancialAct item1 = itemEditor1.getObject();
        this.save((CustomerChargeActEditor)editor);
        this.checkPatientAndProductReadOnly(itemEditor1, false);
        this.checkPatientAndProductReadOnly(itemEditor2, false);
        editor.postSave(queue, false, new MutableBoolean(false));
        this.checkPatientAndProductReadOnly(itemEditor1, true);
        this.checkPatientAndProductReadOnly(itemEditor2, false);
        DocumentAct investigation1 = this.getInvestigation((Act)item1, investigationType1);
        List<TestLaboratoryOrderService.LabOrder> orders = editor.getLaboratoryOrderService().getOrders();
        Assert.assertEquals((long)1L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestLaboratoryOrderService.LabOrder.Type.CREATE, this.patient, investigation1.getId(), investigation1.getActivityStartTime(), this.clinician, laboratory);
        editor.getLaboratoryOrderService().clear();
        editor.delete((Act)item1);
        this.save((CustomerChargeActEditor)editor);
        orders = editor.getLaboratoryOrderService().getOrders();
        Assert.assertEquals((long)1L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestLaboratoryOrderService.LabOrder.Type.CANCEL, this.patient, investigation1.getId(), investigation1.getActivityStartTime(), this.clinician, laboratory);
    }

    @Test
    public void testDeleteInvestigationPriorToSave() {
        Entity laboratory = CustomerChargeTestHelper.createHL7Laboratory(this.location);
        Entity investigationType1 = this.laboratoryFactory.createInvestigationType(laboratory);
        Product product1 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice(10)).build();
        this.addHL7Test(product1, investigationType1);
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.TEN, queue);
        FinancialAct item = itemEditor.getObject();
        InvestigationManager manager = editor.getItems().getEditContext().getInvestigations();
        List investigations = manager.getInvestigations();
        Assert.assertEquals((long)1L, (long)investigations.size());
        Assert.assertEquals((long)1L, (long)manager.getInvestigations(item).size());
        Assert.assertTrue((boolean)manager.removeInvestigation((DocumentAct)investigations.get(0)));
        Assert.assertEquals((long)0L, (long)manager.getInvestigations().size());
        Assert.assertEquals((long)0L, (long)manager.getInvestigations(item).size());
    }

    @Test
    public void testDeleteInvestigationPostSave() {
        Entity laboratory = this.laboratoryFactory.createLaboratory(new Party[]{this.location});
        Entity investigationType1 = this.laboratoryFactory.createInvestigationType(laboratory);
        Product product1 = (Product)((TestServiceProductBuilder)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice(10)).addTests(new Entity[]{this.laboratoryFactory.createTest(investigationType1)})).build();
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.TEN, queue);
        FinancialAct item = itemEditor.getObject();
        InvestigationManager manager = editor.getItems().getEditContext().getInvestigations();
        List investigations = manager.getInvestigations();
        Assert.assertEquals((long)1L, (long)investigations.size());
        Assert.assertEquals((long)1L, (long)manager.getInvestigations(item).size());
        this.save((CustomerChargeActEditor)editor);
        editor.postSave(queue, false, new MutableBoolean(false));
        DocumentAct investigation = (DocumentAct)investigations.get(0);
        Assert.assertFalse((boolean)investigation.isNew());
        IMObjectBean bean = this.getBean((IMObject)investigation);
        Act order = (Act)bean.getTarget("order", Act.class);
        Assert.assertNull((Object)order);
        Assert.assertTrue((boolean)manager.removeInvestigation(investigation));
        Assert.assertEquals((long)0L, (long)manager.getInvestigations().size());
        Assert.assertEquals((long)0L, (long)manager.getInvestigations(item).size());
        this.save((CustomerChargeActEditor)editor);
        Assert.assertNull((Object)this.get((IMObject)investigation));
    }

    @Test
    public void testDeleteInvestigationAfterSubmission() {
        Entity laboratory = CustomerChargeTestHelper.createHL7Laboratory(this.location);
        Entity investigationType1 = this.laboratoryFactory.createInvestigationType(laboratory);
        Product product1 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice(10)).build();
        this.addHL7Test(product1, investigationType1);
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.TEN, queue);
        FinancialAct item = itemEditor.getObject();
        InvestigationManager manager = editor.getItems().getEditContext().getInvestigations();
        List investigations = manager.getInvestigations();
        Assert.assertEquals((long)1L, (long)investigations.size());
        Assert.assertEquals((long)1L, (long)manager.getInvestigations(item).size());
        this.checkPatientAndProductReadOnly(itemEditor, false);
        this.save((CustomerChargeActEditor)editor);
        editor.postSave(queue, false, new MutableBoolean(false));
        this.checkPatientAndProductReadOnly(itemEditor, true);
        DocumentAct investigation = (DocumentAct)investigations.get(0);
        Assert.assertFalse((boolean)investigation.isNew());
        Assert.assertTrue((boolean)manager.removeInvestigation(investigation));
        Assert.assertEquals((long)0L, (long)manager.getInvestigations().size());
        Assert.assertEquals((long)0L, (long)manager.getInvestigations(item).size());
        this.save((CustomerChargeActEditor)editor);
        this.checkPatientAndProductReadOnly(itemEditor, true);
        Assert.assertNull((Object)this.get((IMObject)investigation));
    }

    @Test
    public void testTemplateExpansionForInvoice() {
        this.checkTemplateExpansion("act.customerAccountChargesInvoice", "act.customerAccountInvoiceItem", 1);
    }

    @Test
    public void testTemplateExpansionForCredit() {
        this.checkTemplateExpansion("act.customerAccountChargesCredit", "act.customerAccountCreditItem", 0);
    }

    @Test
    public void testTemplateExpansionForCounter() {
        this.checkTemplateExpansion("act.customerAccountChargesCounter", "act.customerAccountCounterItem", 0);
    }

    @Test
    public void testChangeTemplateProduct() {
        BigDecimal fixedPrice = BigDecimal.ONE;
        Product product1 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).build();
        Product product2 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).build();
        Product template = (Product)this.productFactory.newTemplate().newInclude().product(product1).quantity(1).add().build();
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, template, null, queue);
        Assert.assertEquals((Object)product1, (Object)itemEditor.getProduct());
        Assert.assertEquals((Object)template, (Object)itemEditor.getTemplate());
        itemEditor.setProduct(product2);
        Assert.assertNull((Object)itemEditor.getTemplate());
        this.save((CustomerChargeActEditor)editor);
        itemEditor.setProduct(template);
        Assert.assertEquals((Object)product1, (Object)itemEditor.getProduct());
        Assert.assertEquals((Object)template, (Object)itemEditor.getTemplate());
    }

    @Test
    public void testChangeMedicationQuantityDuringTemplateExpansion() {
        Product product1 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(0)).unitPrice(1)).build();
        Product product2 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(0)).unitPrice(1)).build();
        Product product3 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(0)).unitPrice(1)).build();
        Product template = (Product)this.productFactory.newTemplate().newInclude().product(product1).quantity(1).add().newInclude().product(product2).quantity(1).add().newInclude().product(product3).quantity(1).add().build();
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = editor.addItem();
        itemEditor.getComponent();
        itemEditor.setPatient(this.patient);
        itemEditor.setProduct(template);
        this.checkMedication(product1, BigDecimal.ONE, null, queue);
        this.checkMedication(product2, BigDecimal.ONE, BigDecimal.TEN, queue);
        this.checkMedication(product3, BigDecimal.ONE, null, queue);
        this.checkEquals(new BigDecimal("13.20"), charge.getTotal());
        this.save((CustomerChargeActEditor)editor);
    }

    @Test
    public void testMarkMatchingRemindersCompleted() {
        Product product1 = this.productFactory.createMedication();
        Entity reminderType = this.addReminder(product1);
        Act existing = ReminderTestHelper.createReminder((Party)this.patient, (Entity)reminderType);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)existing.getStatus());
        this.save((IMObject)existing);
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.ONE, queue);
        this.save((CustomerChargeActEditor)editor);
        Act reminder = this.getReminder((Act)itemEditor.getObject(), reminderType);
        existing = (Act)this.get((IMObject)existing);
        reminder = (Act)this.get((IMObject)reminder);
        Assert.assertEquals((Object)"COMPLETED", (Object)existing.getStatus());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)reminder.getStatus());
    }

    @Test
    public void testChangeProductWithReminderToOneWithout() {
        Product product1 = this.productFactory.createMedication();
        Entity reminderType1 = this.addReminder(product1);
        Product product2 = this.productFactory.createMedication();
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.ONE, queue);
        this.save((CustomerChargeActEditor)editor);
        Act reminder = this.getReminder((Act)itemEditor.getObject(), reminderType1);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)reminder.getStatus());
        itemEditor.setProduct(product2);
        this.save((CustomerChargeActEditor)editor);
        Assert.assertNull((Object)this.get((IMObject)reminder));
    }

    @Test
    public void testChangeProductWithReminders() {
        Product product1 = this.productFactory.createMedication();
        Entity reminderType1 = this.addReminder(product1);
        Product product2 = this.productFactory.createMedication();
        Product product3 = this.productFactory.createMedication();
        this.addReminder(product3, reminderType1);
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.ONE, queue);
        this.save((CustomerChargeActEditor)editor);
        Act reminder1 = this.getReminder((Act)itemEditor.getObject(), reminderType1);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)reminder1.getStatus());
        itemEditor.setProduct(product2);
        itemEditor.setProduct(product3);
        CustomerChargeTestHelper.checkSavePopup(queue, "act.patientReminder", false);
        this.save((CustomerChargeActEditor)editor);
        Assert.assertNull((Object)this.get((IMObject)reminder1));
        Act reminder2 = this.getReminder((Act)itemEditor.getObject(), reminderType1);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)reminder2.getStatus());
    }

    @Test
    public void testMarkMatchingAlertsCompleted() {
        Entity alertType = this.createAlertType();
        Product product1 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().addAlertTypes(new Entity[]{alertType})).build();
        Act existing = this.patientFactory.createAlert(this.patient, alertType);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)existing.getStatus());
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.ONE, queue);
        this.save((CustomerChargeActEditor)editor);
        Act alert = this.getAlert((Act)itemEditor.getObject(), alertType);
        existing = (Act)this.get((IMObject)existing);
        alert = (Act)this.get((IMObject)alert);
        Assert.assertEquals((Object)"COMPLETED", (Object)existing.getStatus());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)alert.getStatus());
    }

    @Test
    public void testChangeProductWithAlertToOneWithout() {
        Entity alertType = this.createAlertType();
        Product product1 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().addAlertTypes(new Entity[]{alertType})).build();
        Product product2 = this.productFactory.createMedication();
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.ONE, queue);
        this.save((CustomerChargeActEditor)editor);
        Act alert = this.getAlert((Act)itemEditor.getObject(), alertType);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)alert.getStatus());
        itemEditor.setProduct(product2);
        this.save((CustomerChargeActEditor)editor);
        Assert.assertNull((Object)this.get((IMObject)alert));
    }

    @Test
    public void testChangeProductWithAlerts() {
        Entity alertType1 = this.createAlertType();
        Product product1 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().addAlertTypes(new Entity[]{alertType1})).build();
        Product product2 = this.productFactory.createMedication();
        Product product3 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().addAlertTypes(new Entity[]{alertType1})).build();
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.ONE, queue);
        this.save((CustomerChargeActEditor)editor);
        Act alert1 = this.getAlert((Act)itemEditor.getObject(), alertType1);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)alert1.getStatus());
        itemEditor.setProduct(product2);
        itemEditor.setProduct(product3);
        CustomerChargeTestHelper.checkSavePopup(queue, "act.patientAlert", false);
        this.save((CustomerChargeActEditor)editor);
        Assert.assertNull((Object)this.get((IMObject)alert1));
        Act alert2 = this.getAlert((Act)itemEditor.getObject(), alertType1);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)alert2.getStatus());
    }

    @Test
    public void testNewInstance() {
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        DefaultCustomerChargeActEditor editor = new DefaultCustomerChargeActEditor(charge, null, this.layoutContext);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof DefaultCustomerChargeActEditor));
    }

    @Test
    public void testTemplateVisitNotes() {
        Party patient2 = this.patientFactory.createPatient(this.customer);
        BigDecimal fixedPrice = new BigDecimal("0.91");
        Product productA = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).build();
        Product productB = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).build();
        Product template1 = (Product)this.productFactory.newTemplate().visitNote("template 1 notes").newInclude().product(productA).quantity(1).add().newInclude().product(productB).quantity(1).add().build();
        Product template2 = (Product)this.productFactory.newTemplate().visitNote("template 2 notes").newInclude().product(productA).quantity(1).add().newInclude().product(productB).quantity(1).add().build();
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        this.addItem((CustomerChargeActEditor)editor, this.patient, template1, null, queue);
        this.addItem((CustomerChargeActEditor)editor, patient2, template2, null, queue);
        this.save((CustomerChargeActEditor)editor);
        charge = (FinancialAct)this.get((IMObject)charge);
        IMObjectBean bean = this.getBean((IMObject)charge);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)4L, (long)items.size());
        IMObjectBean item1 = this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, productA, template1, 0, this.author, this.clinician, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, new BigDecimal("0.091"), BigDecimal.ONE, true, null, 1);
        IMObjectBean item2 = this.checkItem(items, "act.customerAccountInvoiceItem", patient2, productA, template2, 1, this.author, this.clinician, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, new BigDecimal("0.091"), BigDecimal.ONE, true, null, 1);
        this.checkChargeEventNote(item1, this.patient, "template 1 notes");
        this.checkChargeEventNote(item2, patient2, "template 2 notes");
    }

    @Test
    public void testSetClinicianBeforeTemplateExpansion() {
        User clinician2 = this.userFactory.createClinician();
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMedication();
        Product product3 = this.productFactory.createMedication();
        Product template = (Product)this.productFactory.newTemplate().newInclude().product(product1).quantity(1).add().newInclude().product(product2).quantity(2).add().newInclude().product(product3).quantity(3).add().build();
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = editor.addItem();
        itemEditor.setClinician(clinician2);
        this.setItem((CustomerChargeActEditor)editor, itemEditor, this.patient, template, BigDecimal.ONE, queue);
        this.save((CustomerChargeActEditor)editor);
        charge = (FinancialAct)this.get((IMObject)charge);
        IMObjectBean bean = this.getBean((IMObject)charge);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)3L, (long)items.size());
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, product1, template, 0, this.author, clinician2, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, true, null, 1);
        BigDecimal two = BigDecimal.valueOf(2L);
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, product2, template, 0, this.author, clinician2, two, two, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, true, null, 1);
        BigDecimal three = BigDecimal.valueOf(3L);
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, product3, template, 0, this.author, clinician2, three, three, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, true, null, 1);
    }

    @Test
    public void testChangeClinician() {
        User clinician2 = this.userFactory.createClinician();
        Product product = this.productFactory.createService();
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = editor.addItem();
        this.setItem((CustomerChargeActEditor)editor, itemEditor, this.patient, product, BigDecimal.ONE, queue);
        this.save((CustomerChargeActEditor)editor);
        itemEditor.setClinician(null);
        this.save((CustomerChargeActEditor)editor);
        itemEditor.setClinician(clinician2);
        this.save((CustomerChargeActEditor)editor);
    }

    @Test
    public void testChangeClinicianOnReminder() {
        User clinician2 = this.userFactory.createClinician();
        Product product = this.productFactory.createMedication();
        Entity reminderType = this.addReminder(product);
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = editor.addItem();
        this.setItem((CustomerChargeActEditor)editor, itemEditor, this.patient, product, BigDecimal.ONE, queue);
        this.save((CustomerChargeActEditor)editor);
        FinancialAct item = itemEditor.getObject();
        Act reminder = this.checkReminder((Act)this.get((IMObject)item), this.patient, product, reminderType, this.author, this.clinician);
        ReminderEditor reminderEditor = itemEditor.getReminderEditor(reminder.getObjectReference());
        Assert.assertNotNull((Object)reminderEditor);
        reminderEditor.setClinician((User)null);
        this.save((CustomerChargeActEditor)editor);
        this.checkReminder((Act)this.get((IMObject)item), this.patient, product, reminderType, this.author, null);
        itemEditor.setClinician(null);
        this.save((CustomerChargeActEditor)editor);
        this.checkReminder((Act)this.get((IMObject)item), this.patient, product, reminderType, this.author, null);
        itemEditor.setClinician(clinician2);
        this.save((CustomerChargeActEditor)editor);
        this.checkReminder((Act)this.get((IMObject)item), this.patient, product, reminderType, this.author, clinician2);
    }

    @Test
    public void testDeleteDocumentOnProductChange() {
        Product product1 = this.productFactory.createService();
        Entity template1 = this.addDocumentTemplate(product1, "act.patientDocumentForm");
        Entity template2 = this.addDocumentTemplate(product1, "act.patientDocumentLetter");
        Product product2 = this.productFactory.createService();
        Product product3 = this.productFactory.createService();
        Entity template3 = this.addDocumentTemplate(product3, "act.patientDocumentLetter");
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = editor.addItem();
        this.setItem((CustomerChargeActEditor)editor, itemEditor, this.patient, product1, BigDecimal.ONE, queue);
        this.save((CustomerChargeActEditor)editor);
        Act event = this.records.getEvent(this.patient);
        Assert.assertNotNull((Object)event);
        FinancialAct item = itemEditor.getObject();
        IMObjectBean bean = this.getBean((IMObject)item);
        Assert.assertEquals((long)2L, (long)bean.getTargets("documents").size());
        DocumentAct document1 = this.checkDocument((Act)item, this.patient, product1, template1, this.author, this.clinician, false);
        DocumentAct document2 = this.checkDocument((Act)item, this.patient, product1, template2, this.author, this.clinician, true);
        this.checkEventRelationship(event, (Act)document1);
        this.checkEventRelationship(event, (Act)document2);
        itemEditor.setProduct(product2);
        this.save((CustomerChargeActEditor)editor);
        Assert.assertTrue((boolean)bean.getTargets("documents").isEmpty());
        Assert.assertNull((Object)this.get((IMObject)document1));
        Assert.assertNull((Object)this.get((IMObject)document2));
        Assert.assertNull((Object)this.get(document2.getDocument()));
        itemEditor.setProduct(product3);
        this.save((CustomerChargeActEditor)editor);
        Assert.assertEquals((long)1L, (long)bean.getTargets("documents").size());
        this.checkDocument((Act)item, this.patient, product3, template3, this.author, this.clinician, true);
    }

    @Test
    public void testChangeClinicianOnPatientLetter() {
        User clinician2 = this.userFactory.createClinician();
        Product product = this.productFactory.createService();
        Entity template = this.addDocumentTemplate(product, "act.patientDocumentLetter", true);
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = editor.addItem();
        this.setItem((CustomerChargeActEditor)editor, itemEditor, this.patient, product, BigDecimal.ONE, queue);
        this.save((CustomerChargeActEditor)editor);
        ParameterDialog parameterDialog1 = (ParameterDialog)this.findComponent(ParameterDialog.class);
        EchoTestHelper.fireDialogButton((PopupDialog)parameterDialog1, (String)"ok");
        FinancialAct item = itemEditor.getObject();
        DocumentAct document1 = this.checkDocument((Act)item, this.patient, product, template, this.author, this.clinician, true);
        itemEditor.setClinician(clinician2);
        ConfirmationDialog confirmationDialog = (ConfirmationDialog)EchoTestHelper.getWindowPane(ConfirmationDialog.class);
        EchoTestHelper.fireDialogButton((PopupDialog)confirmationDialog, (String)"yes");
        this.save((CustomerChargeActEditor)editor);
        Assert.assertNull((Object)this.get((IMObject)document1));
        ParameterDialog parameterDialog2 = (ParameterDialog)this.findComponent(ParameterDialog.class);
        EchoTestHelper.fireDialogButton((PopupDialog)parameterDialog2, (String)"ok");
        this.checkDocument((Act)item, this.patient, product, template, this.author, clinician2, true);
    }

    private void checkPatientAndProductReadOnly(CustomerChargeActItemEditor editor, boolean readOnly) {
        try {
            Assert.assertEquals((Object)readOnly, (Object)editor.isProductReadOnly());
            ProductParticipationEditor productEditor = (ProductParticipationEditor)MethodUtils.invokeMethod((Object)editor, (boolean)true, (String)"getProductEditor");
            Assert.assertNotNull((Object)productEditor);
            Assert.assertEquals((Object)readOnly, (Object)productEditor.isReadOnly());
            PatientParticipationEditor patientEditor = (PatientParticipationEditor)MethodUtils.invokeMethod((Object)editor, (boolean)true, (String)"getParticipationEditor", (Object[])new Object[]{"patient", false});
            if (readOnly) {
                Assert.assertNull((Object)patientEditor);
            } else {
                Assert.assertNotNull((Object)patientEditor);
            }
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    private void checkMedication(Product product, BigDecimal quantity, BigDecimal newQuantity, EditorQueue queue) {
        PopupDialog dialog = queue.getCurrent();
        Assert.assertTrue((boolean)(dialog instanceof EditDialog));
        IMObjectEditor editor = ((EditDialog)dialog).getEditor();
        Assert.assertTrue((boolean)(editor instanceof PatientMedicationActEditor));
        PatientMedicationActEditor medicationEditor = (PatientMedicationActEditor)editor;
        Assert.assertEquals((Object)product, (Object)medicationEditor.getProduct());
        this.checkEquals(quantity, medicationEditor.getQuantity());
        if (newQuantity != null) {
            medicationEditor.setQuantity(newQuantity);
        }
        Assert.assertTrue((boolean)editor.isValid());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
    }

    private void checkPrescription(User prescriptionClinician, User invoiceClinician) {
        BigDecimal fixedPrice = new BigDecimal("3.30");
        BigDecimal unitPrice = new BigDecimal("0.11");
        BigDecimal total = new BigDecimal("4.40");
        BigDecimal tax = new BigDecimal("0.40");
        Product product1 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice("3.00")).unitPrice("0.10")).build();
        Act prescription = PrescriptionTestHelper.createPrescription((Party)this.patient, (Product)product1, (User)prescriptionClinician, (int)10);
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        this.layoutContext.getContext().setClinician(invoiceClinician);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, null, queue);
        this.save((CustomerChargeActEditor)editor);
        this.checkPrescription(prescription, itemEditor);
        charge = (FinancialAct)this.get((IMObject)charge);
        List items = this.getBean((IMObject)charge).getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)1L, (long)items.size());
        Act event = this.records.getEvent(this.patient);
        Assert.assertNotNull((Object)event);
        this.checkItem(items, "act.customerAccountInvoiceItem", this.patient, product1, null, -1, this.author, invoiceClinician, BigDecimal.ZERO, BigDecimal.TEN, BigDecimal.ZERO, unitPrice, BigDecimal.ZERO, fixedPrice, BigDecimal.ZERO, tax, total, true, event, 1);
    }

    private void checkTemplateExpansion(String archetype, String itemArchetype, int childActs) {
        BigDecimal fixedPrice = new BigDecimal("0.91");
        Entity discount = (Entity)this.productFactory.newDiscount().percentage(10).discountFixedPrice(true).build();
        Product product1 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).build();
        Product product2 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).build();
        Product product3 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).build();
        this.addDiscount((Entity)product3, discount);
        this.addDiscount((Entity)this.customer, discount);
        Product template = (Product)this.productFactory.newTemplate().newInclude().product(product1).quantity(1).add().newInclude().product(product2).quantity(2).add().newInclude().product(product3).quantity(3).zeroPrice().add().build();
        FinancialAct charge = (FinancialAct)this.create(archetype, FinancialAct.class);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        this.addItem((CustomerChargeActEditor)editor, this.patient, template, null, queue);
        this.save((CustomerChargeActEditor)editor);
        charge = (FinancialAct)this.get((IMObject)charge);
        IMObjectBean bean = this.getBean((IMObject)charge);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)3L, (long)items.size());
        this.checkItem(items, itemArchetype, this.patient, product1, template, 0, this.author, this.clinician, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, new BigDecimal("0.091"), BigDecimal.ONE, true, null, childActs);
        BigDecimal two = BigDecimal.valueOf(2L);
        this.checkItem(items, itemArchetype, this.patient, product2, template, 0, this.author, this.clinician, two, two, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, new BigDecimal("0.091"), BigDecimal.ONE, true, null, childActs);
        BigDecimal three = BigDecimal.valueOf(3L);
        this.checkItem(items, itemArchetype, this.patient, product3, template, 0, this.author, this.clinician, three, three, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, true, null, childActs);
    }

    private void checkDeleteUnsavedItemWithPrescription(FinancialAct charge) {
        Product product1 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(1)).build();
        Product product2 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(1)).build();
        Act prescription = PrescriptionTestHelper.createPrescription((Party)this.patient, (Product)product1, (User)this.clinician);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        CustomerChargeActItemEditor itemEditor1 = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, BigDecimal.ONE, queue);
        this.addItem((CustomerChargeActEditor)editor, this.patient, product2, BigDecimal.ONE, queue);
        editor.removeItem((Act)itemEditor1.getObject());
        Assert.assertTrue((boolean)editor.isValid());
        this.save((CustomerChargeActEditor)editor);
        prescription = (Act)this.get((IMObject)prescription);
        IMObjectBean bean = this.getBean((IMObject)prescription);
        Assert.assertTrue((boolean)bean.getTargets("dispensing").isEmpty());
        charge = (FinancialAct)this.get((IMObject)charge);
        editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
    }

    private void checkDeleteCharge(FinancialAct charge) {
        BigDecimal fixedPrice = BigDecimal.TEN;
        BigDecimal itemTotal = BigDecimal.valueOf(11L);
        BigDecimal total = itemTotal.multiply(BigDecimal.valueOf(3L));
        Product product1 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).build();
        Product product2 = (Product)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(fixedPrice)).build();
        Product product3 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice(fixedPrice)).build();
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        BigDecimal quantity = BigDecimal.ONE;
        this.addItem((CustomerChargeActEditor)editor, this.patient, product1, quantity, queue);
        this.addItem((CustomerChargeActEditor)editor, this.patient, product2, quantity, queue);
        this.addItem((CustomerChargeActEditor)editor, this.patient, product3, quantity, queue);
        this.save((CustomerChargeActEditor)editor);
        BigDecimal balance = charge.isCredit() ? total.negate() : total;
        this.checkBalance(this.customer, balance, BigDecimal.ZERO);
        charge = (FinancialAct)this.get((IMObject)charge);
        IMObjectBean bean = this.getBean((IMObject)charge);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)3L, (long)items.size());
        Assert.assertTrue((boolean)this.delete(editor));
        Assert.assertNull((Object)this.get((IMObject)charge));
        for (FinancialAct item : items) {
            Assert.assertNull((Object)this.get((IMObject)item));
        }
        this.checkBalance(this.customer, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    private void checkEmptyCharge(FinancialAct charge) {
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        editor.save();
        this.checkBalance(this.customer, BigDecimal.ZERO, BigDecimal.ZERO);
        editor.setStatus("POSTED");
        editor.save();
        this.checkBalance(this.customer, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    private void checkEditCharge(String archetype, String itemArchetype, boolean discontinueOrdersOnFinalisation) {
        if (discontinueOrdersOnFinalisation) {
            this.setPharmacyOrderDiscontinuePeriod(0);
        } else {
            this.setPharmacyOrderDiscontinuePeriod(60);
        }
        Party location = (Party)this.practiceFactory.newLocation().stockControl().build();
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[]{location});
        this.layoutContext.getContext().setLocation(location);
        this.layoutContext.getContext().setStockLocation(stockLocation);
        BigDecimal fixedPrice = BigDecimal.TEN;
        BigDecimal fixedPriceIncTax = BigDecimal.valueOf(11L);
        BigDecimal itemTax = BigDecimal.valueOf(1L);
        BigDecimal itemTotal = BigDecimal.valueOf(11L);
        BigDecimal tax = itemTax.multiply(BigDecimal.valueOf(3L));
        BigDecimal total = itemTotal.multiply(BigDecimal.valueOf(3L));
        Entity pharmacy = this.hl7Factory.createHL7Pharmacy(location, this.userFactory.createUser());
        Entity laboratory = CustomerChargeTestHelper.createHL7Laboratory(location);
        FinancialAct charge = (FinancialAct)this.create(archetype, FinancialAct.class);
        boolean invoice = TypeHelper.isA((IMObject)charge, (String)"act.customerAccountChargesInvoice");
        Product product1 = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).pharmacy(pharmacy)).addAlertTypes(new Entity[]{this.createAlertType()})).build();
        this.addReminder(product1);
        this.addHL7Test(product1);
        this.addDocumentTemplate(product1);
        int product1Acts = invoice ? 5 : 0;
        Product product2 = (Product)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(fixedPrice)).pharmacy(pharmacy)).addAlertTypes(new Entity[]{this.createAlertType()})).build();
        this.addReminder(product2);
        this.addHL7Test(product2);
        this.addDocumentTemplate(product2, "act.patientDocumentLetter");
        int product2Acts = invoice ? 4 : 0;
        Product product3 = (Product)((TestServiceProductBuilder)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice(fixedPrice)).addAlertTypes(new Entity[]{this.createAlertType()})).build();
        this.addReminder(product3);
        Entity investigationType3 = this.laboratoryFactory.createInvestigationType(laboratory);
        this.addHL7Test(product3, investigationType3);
        this.addDocumentTemplate(product3);
        int product3Acts = invoice ? 4 : 0;
        BigDecimal product1Stock = BigDecimal.valueOf(100L);
        BigDecimal product2Stock = BigDecimal.valueOf(50L);
        this.initStock(product1, stockLocation, product1Stock);
        this.initStock(product2, stockLocation, product2Stock);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        EditorQueue queue = editor.getQueue();
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        BigDecimal quantity = BigDecimal.ONE;
        CustomerChargeActItemEditor itemEditor1 = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, quantity, queue);
        CustomerChargeActItemEditor itemEditor2 = this.addItem((CustomerChargeActEditor)editor, this.patient, product2, quantity, queue);
        CustomerChargeActItemEditor itemEditor3 = this.addItem((CustomerChargeActEditor)editor, this.patient, product3, quantity, queue);
        FinancialAct item1 = itemEditor1.getObject();
        FinancialAct item2 = itemEditor2.getObject();
        FinancialAct item3 = itemEditor3.getObject();
        Assert.assertTrue((boolean)editor.isValid());
        this.save((CustomerChargeActEditor)editor);
        if (invoice) {
            this.checkPatientAndProductReadOnly(itemEditor1, true);
            this.checkPatientAndProductReadOnly(itemEditor2, true);
            this.checkPatientAndProductReadOnly(itemEditor3, false);
            Assert.assertEquals((Object)"ORDERED", (Object)item1.getStatus());
            Assert.assertEquals((Object)"ORDERED", (Object)item2.getStatus());
            Assert.assertNull((Object)item3.getStatus());
            editor.postSave(queue, true, new MutableBoolean(false));
            Assert.assertEquals((Object)"ORDERED", (Object)item1.getStatus());
            Assert.assertEquals((Object)"ORDERED", (Object)item2.getStatus());
            Assert.assertEquals((Object)"ORDERED", (Object)item3.getStatus());
            this.checkPatientAndProductReadOnly(itemEditor1, true);
            this.checkPatientAndProductReadOnly(itemEditor2, true);
            this.checkPatientAndProductReadOnly(itemEditor3, true);
        } else {
            Assert.assertNull((Object)item1.getStatus());
            Assert.assertNull((Object)item2.getStatus());
            Assert.assertNull((Object)item3.getStatus());
        }
        BigDecimal balance = charge.isCredit() ? total.negate() : total;
        this.checkBalance(this.customer, balance, BigDecimal.ZERO);
        editor.setStatus("POSTED");
        editor.save();
        this.checkBalance(this.customer, BigDecimal.ZERO, balance);
        if (invoice) {
            List<TestPharmacyOrderService.Order> orders = editor.getPharmacyOrderService().getOrders(true);
            if (discontinueOrdersOnFinalisation) {
                Assert.assertEquals((long)4L, (long)orders.size());
            } else {
                Assert.assertEquals((long)2L, (long)orders.size());
            }
            int index = 0;
            CustomerChargeTestHelper.checkOrder(orders.get(index++), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product1, quantity, item1.getId(), item1.getActivityStartTime(), this.clinician, pharmacy);
            if (discontinueOrdersOnFinalisation) {
                CustomerChargeTestHelper.checkOrder(orders.get(index++), TestPharmacyOrderService.Order.Type.DISCONTINUE, this.patient, product1, quantity, item1.getId(), item1.getActivityStartTime(), this.clinician, pharmacy);
            }
            CustomerChargeTestHelper.checkOrder(orders.get(index++), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product2, quantity, item2.getId(), item2.getActivityStartTime(), this.clinician, pharmacy);
            if (discontinueOrdersOnFinalisation) {
                CustomerChargeTestHelper.checkOrder(orders.get(index), TestPharmacyOrderService.Order.Type.DISCONTINUE, this.patient, product2, quantity, item2.getId(), item2.getActivityStartTime(), this.clinician, pharmacy);
            }
            editor.getPharmacyOrderService().clear();
            String status = discontinueOrdersOnFinalisation ? "DISCONTINUED" : "ORDERED";
            Assert.assertEquals((Object)status, (Object)item1.getStatus());
            Assert.assertEquals((Object)status, (Object)item2.getStatus());
            Assert.assertEquals((Object)status, (Object)item3.getStatus());
            List<TestLaboratoryOrderService.LabOrder> labOrders = editor.getLaboratoryOrderService().getOrders();
            Assert.assertEquals((long)1L, (long)labOrders.size());
            DocumentAct investigation = this.getInvestigation((Act)item3, investigationType3);
            CustomerChargeTestHelper.checkOrder(labOrders.get(0), TestLaboratoryOrderService.LabOrder.Type.CREATE, this.patient, investigation.getId(), investigation.getActivityStartTime(), this.clinician, laboratory);
            editor.getLaboratoryOrderService().clear();
        } else {
            Assert.assertNull((Object)editor.getPharmacyOrderService());
            Assert.assertNull((Object)editor.getLaboratoryOrderService());
            Assert.assertNull((Object)item1.getStatus());
            Assert.assertNull((Object)item2.getStatus());
            Assert.assertNull((Object)item3.getStatus());
        }
        charge = (FinancialAct)this.get((IMObject)charge);
        IMObjectBean bean = this.getBean((IMObject)charge);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)3L, (long)items.size());
        this.checkCharge(charge, this.customer, this.author, this.clinician, tax, total);
        Act event = this.records.getEvent(this.patient);
        if (invoice) {
            Assert.assertNotNull((Object)event);
            this.checkEvent(event, this.patient, this.author, this.clinician, location, "COMPLETED");
        } else {
            Assert.assertNull((Object)event);
        }
        BigDecimal discount = BigDecimal.ZERO;
        this.checkItem(items, itemArchetype, this.patient, product1, null, -1, this.author, this.clinician, BigDecimal.ZERO, quantity, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, fixedPriceIncTax, discount, itemTax, itemTotal, true, event, product1Acts);
        this.checkItem(items, itemArchetype, this.patient, product2, null, -1, this.author, this.clinician, BigDecimal.ZERO, quantity, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, fixedPriceIncTax, discount, itemTax, itemTotal, true, event, product2Acts);
        this.checkItem(items, itemArchetype, this.patient, product3, null, -1, this.author, this.clinician, BigDecimal.ZERO, quantity, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, fixedPriceIncTax, discount, itemTax, itemTotal, true, event, product3Acts);
        boolean add = bean.isA(new String[]{"act.customerAccountChargesCredit"});
        this.checkStock(product1, stockLocation, product1Stock, quantity, add);
        this.checkStock(product2, stockLocation, product2Stock, quantity, add);
        this.checkStock(product3, stockLocation, BigDecimal.ZERO, BigDecimal.ZERO, add);
    }

    private void checkChargeStockUpdate(FinancialAct charge) {
        Party location = (Party)this.practiceFactory.newLocation().stockControl().build();
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[]{location});
        this.layoutContext.getContext().setLocation(location);
        this.layoutContext.getContext().setStockLocation(stockLocation);
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMerchandise();
        Product product3 = this.productFactory.createService();
        Product product4 = this.productFactory.createMerchandise();
        BigDecimal product1InitialStock = BigDecimal.valueOf(100L);
        BigDecimal product2InitialStock = BigDecimal.valueOf(50L);
        BigDecimal product4InitialStock = BigDecimal.valueOf(25L);
        this.initStock(product1, stockLocation, product1InitialStock);
        this.initStock(product2, stockLocation, product2InitialStock);
        this.initStock(product4, stockLocation, product4InitialStock);
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        BigDecimal quantity1 = BigDecimal.valueOf(5L);
        BigDecimal quantity2 = BigDecimal.TEN;
        BigDecimal quantity4a = BigDecimal.ONE;
        BigDecimal quantity4b = BigDecimal.TEN;
        BigDecimal quantity4 = quantity4a.add(quantity4b);
        CustomerChargeActItemEditor item1 = this.addItem((CustomerChargeActEditor)editor, this.patient, product1, quantity1, editor.getQueue());
        CustomerChargeActItemEditor item2 = this.addItem((CustomerChargeActEditor)editor, this.patient, product2, quantity2, editor.getQueue());
        this.addItem((CustomerChargeActEditor)editor, this.patient, product4, quantity4a, editor.getQueue());
        this.addItem((CustomerChargeActEditor)editor, this.patient, product4, quantity4b, editor.getQueue());
        this.save((CustomerChargeActEditor)editor);
        boolean add = TypeHelper.isA((IMObject)charge, (String)"act.customerAccountChargesCredit");
        BigDecimal product1Stock = this.checkStock(product1, stockLocation, product1InitialStock, quantity1, add);
        BigDecimal product2Stock = this.checkStock(product2, stockLocation, product2InitialStock, quantity2, add);
        this.checkStock(product4, stockLocation, product4InitialStock, quantity4, add);
        item1.setQuantity(BigDecimal.ZERO);
        item1.setQuantity(quantity1);
        Assert.assertTrue((boolean)item1.isModified());
        item2.setQuantity(BigDecimal.ZERO);
        item2.setQuantity(quantity2);
        Assert.assertTrue((boolean)item2.isModified());
        this.save((CustomerChargeActEditor)editor);
        this.checkStock(product1, stockLocation, product1Stock);
        this.checkStock(product2, stockLocation, product2Stock);
        item1.setQuantity(BigDecimal.valueOf(10L));
        item2.setProduct(product3);
        this.save((CustomerChargeActEditor)editor);
        this.checkStock(product1, stockLocation, product1Stock, BigDecimal.valueOf(5L), add);
        this.checkStock(product2, stockLocation, product2Stock, quantity2, !add);
        Assert.assertTrue((boolean)this.delete(editor));
        this.checkStock(product1, stockLocation, product1InitialStock);
        this.checkStock(product2, stockLocation, product2InitialStock);
        this.checkStock(product4, stockLocation, product4InitialStock);
    }

    private void checkExpandTemplate(FinancialAct charge, String itemArchetype) {
        Party location = (Party)this.practiceFactory.newLocation().stockControl().build();
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[]{location});
        this.layoutContext.getContext().setLocation(location);
        this.layoutContext.getContext().setStockLocation(stockLocation);
        this.patientFactory.createWeight(this.patient, new BigDecimal("4.2"), WeightUnits.KILOGRAMS);
        BigDecimal quantity = BigDecimal.valueOf(1L);
        BigDecimal fixedPrice = BigDecimal.TEN;
        BigDecimal fixedPriceIncTax = BigDecimal.valueOf(11L);
        BigDecimal discount = BigDecimal.ZERO;
        BigDecimal itemTax = BigDecimal.valueOf(1L);
        BigDecimal itemTotal = BigDecimal.valueOf(11L);
        BigDecimal tax = itemTax.multiply(BigDecimal.valueOf(3L));
        BigDecimal total = itemTotal.multiply(BigDecimal.valueOf(3L));
        Product product1 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(fixedPrice)).build();
        this.productFactory.updateMedication(product1).newDose().weightRange(0, 10).rate(1).quantity(1).add().concentration(1).build();
        Product product2 = (Product)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().fixedPrice(fixedPrice)).build();
        Product product3 = (Product)((TestServiceProductBuilder)this.productFactory.newService().fixedPrice(fixedPrice)).build();
        Product template = (Product)this.productFactory.newTemplate().newInclude().product(product1).add().newInclude().product(product2).add().newInclude().product(product3).add().build();
        TestChargeEditor editor = this.createCustomerChargeActEditor(charge, this.layoutContext);
        editor.getComponent();
        CustomerChargeTestHelper.addItem((CustomerChargeActEditor)editor, this.patient, template, null, editor.getQueue());
        boolean invoice = charge.isA("act.customerAccountChargesInvoice");
        int product1Acts = 0;
        if (invoice) {
            ++product1Acts;
        }
        this.save((CustomerChargeActEditor)editor);
        BigDecimal balance = charge.isCredit() ? total.negate() : total;
        this.checkBalance(this.customer, balance, BigDecimal.ZERO);
        charge = (FinancialAct)this.get((IMObject)charge);
        IMObjectBean bean = this.getBean((IMObject)charge);
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)3L, (long)items.size());
        this.checkCharge(charge, this.customer, this.author, this.clinician, tax, total);
        Act event = this.records.getEvent(this.patient);
        if (invoice) {
            Assert.assertNotNull((Object)event);
            this.checkEvent(event, this.patient, this.author, this.clinician, location, "IN_PROGRESS");
        } else {
            Assert.assertNull((Object)event);
        }
        if (TypeHelper.isA((IMObject)charge, (String)"act.customerAccountChargesCounter")) {
            this.checkItem(items, itemArchetype, this.patient, product1, template, 0, this.author, this.clinician, BigDecimal.ONE, quantity, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, fixedPriceIncTax, discount, itemTax, itemTotal, true, event, product1Acts);
        } else {
            this.checkItem(items, itemArchetype, this.patient, product1, template, 0, this.author, this.clinician, BigDecimal.ONE, new BigDecimal("4.2"), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, fixedPriceIncTax, discount, itemTax, itemTotal, true, event, product1Acts);
        }
        this.checkItem(items, itemArchetype, this.patient, product2, template, 0, this.author, this.clinician, BigDecimal.ONE, quantity, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, fixedPriceIncTax, discount, itemTax, itemTotal, true, event, 0);
        this.checkItem(items, itemArchetype, this.patient, product3, template, 0, this.author, this.clinician, BigDecimal.ONE, quantity, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, fixedPriceIncTax, discount, itemTax, itemTotal, true, event, 0);
    }

    private void initStock(Product product, Party stockLocation, BigDecimal quantity) {
        StockRules rules = new StockRules(this.getArchetypeService());
        rules.updateStock(product, stockLocation, quantity);
    }

    private BigDecimal checkStock(Product product, Party stockLocation, BigDecimal initial, BigDecimal change, boolean add) {
        BigDecimal expected = add ? initial.add(change) : initial.subtract(change);
        this.checkStock(product, stockLocation, expected);
        return expected;
    }

    private void checkStock(Product product, Party stockLocation, BigDecimal expected) {
        StockRules rules = new StockRules(this.getArchetypeService());
        this.checkEquals(expected, rules.getStock((Product)this.get((IMObject)product), (Party)this.get((IMObject)stockLocation)));
    }

    private void checkEvent(Act event, Party patient, User author, User clinician, Party location, String status) {
        IMObjectBean bean = this.getBean((IMObject)event);
        Assert.assertEquals((Object)patient.getObjectReference(), (Object)bean.getTargetRef("patient"));
        Assert.assertEquals((Object)author.getObjectReference(), (Object)event.getCreatedBy());
        Assert.assertEquals((Object)clinician.getObjectReference(), (Object)bean.getTargetRef("clinician"));
        Assert.assertEquals((Object)location.getObjectReference(), (Object)bean.getTargetRef("location"));
        Assert.assertEquals((Object)status, (Object)event.getStatus());
        if ("COMPLETED".equals(event.getStatus())) {
            Assert.assertNotNull((Object)event.getActivityEndTime());
        } else {
            Assert.assertNull((Object)event.getActivityEndTime());
        }
    }

    private void checkPrescription(Act prescription, CustomerChargeActItemEditor itemEditor) {
        prescription = (Act)this.get((IMObject)prescription);
        Assert.assertNotNull((Object)prescription);
        IMObjectBean prescriptionBean = this.getBean((IMObject)prescription);
        FinancialAct item = itemEditor.getObject();
        IMObjectBean bean = this.getBean((IMObject)item);
        List dispensing = bean.getTargets("dispensing", Act.class);
        Assert.assertEquals((long)1L, (long)dispensing.size());
        Act medication = (Act)dispensing.get(0);
        Assert.assertTrue((boolean)prescriptionBean.getTargets("dispensing").contains(medication));
    }

    private boolean delete(final DefaultCustomerChargeActEditor editor) {
        boolean result = false;
        try {
            TransactionTemplate template = new TransactionTemplate(ServiceHelper.getTransactionManager());
            template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    editor.delete();
                }
            });
            result = true;
        }
        catch (Throwable exception) {
            this.logger.error((Object)exception, exception);
        }
        return result;
    }

    private void checkBalance(Party customer, BigDecimal unbilled, BigDecimal balance) {
        CustomerAccountRules rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
        this.checkEquals(unbilled, rules.getUnbilledAmount(customer));
        this.checkEquals(balance, rules.getBalance(customer));
    }

    private void checkTotal(FinancialAct charge, BigDecimal total) {
        this.checkEquals(total, charge.getTotal());
        ActCalculator calculator = new ActCalculator((ArchetypeService)this.getArchetypeService());
        BigDecimal itemTotal = calculator.sum((Act)charge, "items", "total");
        this.checkEquals(total, itemTotal);
    }

    private void addHL7Test(Product product) {
        this.addHL7Test(product, this.laboratoryFactory.createInvestigationType());
    }

    private void addHL7Test(Product product, Entity investigationType) {
        Entity test = this.laboratoryFactory.createHL7Test(investigationType);
        this.productFactory.updateProduct(product).addTests(new Entity[]{test}).build();
    }

    private TestChargeEditor createCustomerChargeActEditor(FinancialAct invoice, LayoutContext context) {
        return this.createCustomerChargeActEditor(invoice, context, false);
    }

    private TestChargeEditor createCustomerChargeActEditor(FinancialAct invoice, LayoutContext context, boolean addDefaultItem) {
        return new TestChargeEditor(invoice, context, addDefaultItem);
    }
}

