/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.customer.charge.TestLaboratoryOrderService;
import org.openvpms.web.workspace.customer.charge.TestPharmacyOrderService;

public class CustomerChargeTestHelper {
    public static CustomerChargeActItemEditor addItem(CustomerChargeActEditor editor, Party patient, Product product, BigDecimal quantity, EditorQueue queue) {
        CustomerChargeActItemEditor itemEditor = editor.addItem();
        itemEditor.getComponent();
        EditorTestHelper.assertValid((Modifiable)editor);
        Assert.assertFalse((boolean)itemEditor.isValid());
        CustomerChargeTestHelper.setItem(editor, itemEditor, patient, product, quantity, queue);
        return itemEditor;
    }

    public static void setItem(CustomerChargeActEditor editor, CustomerChargeActItemEditor itemEditor, Party patient, Product product, BigDecimal quantity, EditorQueue queue) {
        DefaultValidator validator;
        boolean valid;
        if (itemEditor.getProperty("patient") != null) {
            itemEditor.setPatient(patient);
        }
        itemEditor.setProduct(product);
        if (quantity != null) {
            itemEditor.setQuantity(quantity);
        }
        if (TypeHelper.isA((IMObject)editor.getObject(), (String)"act.customerAccountChargesInvoice")) {
            if (!TypeHelper.isA((IMObject)product, (String)"product.template")) {
                CustomerChargeTestHelper.checkSavePopups(editor, itemEditor, product, queue);
            } else {
                IMObjectBean bean = IMObjectHelper.getBean((IMObject)product);
                List includes = bean.getTargets("includes", Entity.class);
                for (Entity include : includes) {
                    CustomerChargeTestHelper.checkSavePopups(editor, itemEditor, (Product)include, queue);
                }
            }
        }
        if (!(valid = itemEditor.validate((Validator)(validator = new DefaultValidator())))) {
            ValidationHelper.showError((Validator)validator);
        }
        EditorTestHelper.assertValid((Modifiable)itemEditor);
    }

    public static void checkSavePopups(CustomerChargeActEditor editor, CustomerChargeActItemEditor itemEditor, Product product, EditorQueue queue) {
        int i;
        IMObjectBean bean;
        if (TypeHelper.isA((IMObject)product, (String)"product.medication") && (bean = IMObjectHelper.getBean((IMObject)product)).getBoolean("label")) {
            Assert.assertFalse((String)("Editor should invalid after setting " + product.getName()), (boolean)itemEditor.isValid());
            CustomerChargeTestHelper.checkSavePopup(queue, "act.patientMedication", true);
        }
        bean = IMObjectHelper.getBean((IMObject)product);
        for (i = 0; i < bean.getTargetRefs("tests").size(); ++i) {
            Assert.assertFalse((boolean)editor.isValid());
            CustomerChargeTestHelper.checkSavePopup(queue, "act.patientInvestigation", false);
        }
        for (i = 0; i < bean.getTargetRefs("reminders").size(); ++i) {
            Assert.assertFalse((boolean)editor.isValid());
            CustomerChargeTestHelper.checkSavePopup(queue, "act.patientReminder", false);
        }
        for (i = 0; i < bean.getTargetRefs("alerts").size(); ++i) {
            Assert.assertFalse((boolean)editor.isValid());
            CustomerChargeTestHelper.checkSavePopup(queue, "act.patientAlert", false);
        }
        for (i = 0; i < bean.getTargetRefs("tasks").size(); ++i) {
            Assert.assertFalse((boolean)editor.isValid());
            CustomerChargeTestHelper.checkSavePopup(queue, "act.customerTask", false);
        }
    }

    public static void checkSavePopup(EditorQueue queue, String shortName, boolean prescription) {
        PopupDialog dialog;
        if (prescription && (dialog = queue.getCurrent()) instanceof ConfirmationDialog) {
            EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        }
        dialog = queue.getCurrent();
        Assert.assertTrue((boolean)(dialog instanceof EditDialog));
        IMObjectEditor editor = ((EditDialog)dialog).getEditor();
        Assert.assertTrue((boolean)TypeHelper.isA((IMObject)editor.getObject(), (String)shortName));
        EditorTestHelper.assertValid((Modifiable)editor);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
    }

    public static Entity createHL7Laboratory(Party location) {
        User user = TestHelper.createUser();
        return new TestLaboratoryFactory((ArchetypeService)ServiceHelper.getArchetypeService()).createHL7Laboratory(location, user);
    }

    public static void checkOrder(TestPharmacyOrderService.Order order, TestPharmacyOrderService.Order.Type type, Party patient, Product product, BigDecimal quantity, long placerOrderNumber, Date date, User clinician, Entity pharmacy) {
        Assert.assertEquals((Object)((Object)type), (Object)((Object)order.getType()));
        Assert.assertEquals((Object)patient, (Object)order.getPatient());
        Assert.assertEquals((Object)product, (Object)order.getProduct());
        TestHelper.checkEquals((BigDecimal)quantity, (BigDecimal)order.getQuantity());
        Assert.assertEquals((long)placerOrderNumber, (long)order.getPlacerOrderNumber());
        Assert.assertEquals((Object)date, (Object)order.getDate());
        Assert.assertEquals((Object)clinician, (Object)order.getClinician());
        Assert.assertEquals((Object)pharmacy, (Object)order.getPharmacy());
    }

    public static void checkOrder(TestLaboratoryOrderService.LabOrder order, TestLaboratoryOrderService.LabOrder.Type type, Party patient, long placerOrderNumber, Date date, User clinician, Entity laboratory) {
        Assert.assertEquals((Object)((Object)type), (Object)((Object)order.getType()));
        Assert.assertEquals((Object)patient, (Object)order.getPatient());
        Assert.assertEquals((long)placerOrderNumber, (long)order.getPlacerOrderNumber());
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)date, (Date)order.getDate(), (boolean)true));
        Assert.assertEquals((Object)clinician, (Object)order.getClinician());
        Assert.assertEquals((Object)laboratory, (Object)order.getLaboratory());
    }
}

