/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import nextapp.echo2.app.WindowPane;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.reminder.AccountReminderRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEFTPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.service.object.DomainObjectService;
import org.openvpms.paymentprocessor.internal.service.PaymentProcessorTransactionChecker;
import org.openvpms.paymentprocessor.internal.service.PaymentProcessors;
import org.openvpms.paymentprocessor.service.PaymentProcessorService;
import org.openvpms.paymentprocessor.transaction.Transaction;
import org.openvpms.plugin.manager.PluginManager;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.account.AccountActActions;
import org.openvpms.web.workspace.customer.payment.TestPaymentProcessorService;
import org.springframework.beans.factory.annotation.Autowired;

public class AccountActActionsTestCase
extends AbstractAppTest {
    @Autowired
    private CustomerAccountRules accountRules;
    @Autowired
    private DomainObjectService domainService;
    @Autowired
    private AccountReminderRules reminderRules;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPaymentProcessorFactory paymentProcessorFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    private AccountActActions actions;
    private TestPaymentProcessorService paymentProcessorService;

    @Before
    public void setUp() {
        super.setUp();
        this.paymentProcessorService = new TestPaymentProcessorService();
        final PaymentProcessors paymentProcessors = new PaymentProcessors((ArchetypeService)this.getArchetypeService(), (PluginManager)Mockito.mock(PluginManager.class)){

            public PaymentProcessorService getPaymentProcessor(Entity config) {
                return AccountActActionsTestCase.this.paymentProcessorService;
            }
        };
        this.actions = new AccountActActions(this.accountRules, this.reminderRules, this.getPracticeService(), (ArchetypeService)this.getArchetypeService()){

            protected PaymentProcessorTransactionChecker getPaymentProcessorTransactionChecker() {
                return new PaymentProcessorTransactionChecker(paymentProcessors, AccountActActionsTestCase.this.accountRules, AccountActActionsTestCase.this.domainService);
            }
        };
    }

    @Test
    public void testCanPost() {
        FinancialAct invoice1 = this.createInvoice("IN_PROGRESS");
        Assert.assertTrue((boolean)this.actions.canPost(invoice1));
        FinancialAct invoice2 = this.createInvoice("POSTED");
        this.verifyCantPost(invoice2, null, null);
        FinancialAct payment1 = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customerFactory.createCustomer())).location(this.practiceFactory.createLocation())).till(this.practiceFactory.createTill())).status("IN_PROGRESS")).eft().amount(10)).addTransaction("PENDING", this.practiceFactory.createEFTPOSTerminal())).add()).build();
        this.verifyCantPost(payment1, "Finalise Payment", "Cannot finalise Payment. It has an incomplete EFTPOS transaction.");
        Entity paymentProcessor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct payment2 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customerFactory.createCustomer())).location(this.practiceFactory.createLocation())).till(this.practiceFactory.createTill())).status("IN_PROGRESS")).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("SUBMITTED")).add()).build();
        this.verifyCantPost(payment2, "Finalise Payment", "Cannot finalise Payment. It has an incomplete " + paymentProcessor.getName() + " transaction.");
        FinancialAct refund1 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(this.customerFactory.createCustomer())).location(this.practiceFactory.createLocation())).till(this.practiceFactory.createTill())).status("IN_PROGRESS")).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("PENDING")).add()).build();
        this.verifyCantPost(refund1, "Finalise Refund", "Cannot finalise Refund. It has an unsubmitted " + paymentProcessor.getName() + " transaction.\n\nEdit the Refund to submit the transaction.");
    }

    @Test
    public void testCanPostForPaymentProcessorWhereTransactionStatusChangesOnCheck() {
        Entity paymentProcessor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.customerFactory.createCustomer())).location(this.practiceFactory.createLocation())).till(this.practiceFactory.createTill())).status("IN_PROGRESS")).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("SUBMITTED")).add()).build();
        this.verifyCantPost(payment, "Finalise Payment", "Cannot finalise Payment. It has an incomplete " + paymentProcessor.getName() + " transaction.");
        this.paymentProcessorService.setCheckCallback(transaction -> transaction.state().status(Transaction.Status.COMPLETED).update());
        Assert.assertTrue((boolean)this.actions.canPost(payment));
    }

    private void verifyCantPost(FinancialAct act, String title, String message) {
        Assert.assertFalse((boolean)this.actions.canPost(act));
        if (title != null) {
            InformationDialog dialog = (InformationDialog)EchoTestHelper.getWindowPane(InformationDialog.class);
            Assert.assertEquals((Object)title, (Object)dialog.getTitle());
            Assert.assertEquals((Object)message, (Object)dialog.getMessage());
        } else {
            Assert.assertNull((Object)EchoTestHelper.findWindowPane(WindowPane.class));
        }
    }

    private FinancialAct createInvoice(String status) {
        return (FinancialAct)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)this.accountFactory.newInvoice().customer(this.customerFactory.createCustomer())).location(this.practiceFactory.createLocation())).status(status)).build();
    }
}

