/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.PatientRelationshipState;
import org.openvpms.web.workspace.customer.PatientRelationshipStateQuery;

public class PatientRelationshipStateQueryTestCase
extends AbstractAppTest {
    @Test
    public void testQueryForCustomer() {
        Party customer = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient((Party)customer);
        Party patient2 = TestHelper.createPatient((Party)customer);
        Party patient3 = TestHelper.createPatient((Party)customer);
        IMObjectBean patientBean = this.getBean((IMObject)patient2);
        patientBean.setValue("deceased", (Object)true);
        patientBean.save();
        patient3.setActive(false);
        this.save((IMObject)patient3);
        IMObjectBean bean = this.getBean((IMObject)customer);
        EntityRelationship rel1 = (EntityRelationship)bean.getValue("patients", EntityRelationship.class, Predicates.targetEquals((IMObject)patient1));
        EntityRelationship rel2 = (EntityRelationship)bean.getValue("patients", EntityRelationship.class, Predicates.targetEquals((IMObject)patient2));
        EntityRelationship rel3 = (EntityRelationship)bean.getValue("patients", EntityRelationship.class, Predicates.targetEquals((IMObject)patient3));
        List relationships = bean.getValues("patients", Predicates.isA((String[])new String[]{"entityRelationship.patientOwner"}));
        Map<Relationship, RelationshipState> results = this.getOwnerRelationships(customer, relationships);
        Assert.assertEquals((long)3L, (long)results.size());
        this.checkResults(results, rel1, customer, patient1, false);
        this.checkResults(results, rel2, customer, patient2, true);
        this.checkResults(results, rel3, customer, patient3, false);
    }

    @Test
    public void testQueryForPatient() {
        PatientRules rules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
        Party customer1 = TestHelper.createCustomer();
        Party customer2 = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient();
        EntityRelationship rel1 = rules.addPatientOwnerRelationship(customer1, patient);
        this.save((IMObject[])new Party[]{patient, customer1});
        EntityRelationship rel2 = rules.addPatientOwnerRelationship(customer2, patient);
        this.save((IMObject[])new Party[]{patient, customer2});
        IMObjectBean bean = this.getBean((IMObject)patient);
        List relationships = bean.getValues("customers", IMObject.class);
        Map<Relationship, RelationshipState> results = this.getOwnerRelationships(patient, relationships);
        Assert.assertEquals((long)2L, (long)results.size());
        this.checkResults(results, rel1, customer1, patient, false);
        this.checkResults(results, rel2, customer2, patient, false);
        bean.setValue("deceased", (Object)true);
        bean.save();
        results = this.getOwnerRelationships(patient, relationships);
        this.checkResults(results, rel1, customer1, patient, true);
        this.checkResults(results, rel2, customer2, patient, true);
    }

    private Map<Relationship, RelationshipState> getOwnerRelationships(Party parent, List<IMObject> relationships) {
        PatientRelationshipStateQuery query = new PatientRelationshipStateQuery((Entity)parent, relationships, new String[]{"entityRelationship.patientOwner"});
        return query.query();
    }

    private void checkResults(Map<Relationship, RelationshipState> results, EntityRelationship relationship, Party customer, Party patient, boolean deceased) {
        boolean active = !deceased && patient.isActive() && relationship.isActive();
        RelationshipState state = results.get(relationship);
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)customer.getId(), (long)state.getSourceId());
        Assert.assertEquals((Object)customer.getObjectReference(), (Object)state.getSource());
        Assert.assertEquals((Object)customer.getName(), (Object)state.getSourceName());
        Assert.assertEquals((Object)customer.getDescription(), (Object)state.getSourceDescription());
        Assert.assertEquals((long)patient.getId(), (long)state.getTargetId());
        Assert.assertEquals((Object)patient.getObjectReference(), (Object)state.getTarget());
        Assert.assertEquals((Object)patient.getName(), (Object)state.getTargetName());
        Assert.assertEquals((Object)patient.getDescription(), (Object)state.getTargetDescription());
        Assert.assertEquals((Object)relationship, (Object)state.getRelationship());
        Assert.assertEquals((Object)active, (Object)state.isActive());
        Assert.assertEquals((Object)deceased, (Object)((PatientRelationshipState)state).isDeceased());
    }
}

