/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestLetterheadBuilder;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandler;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.template.letterhead.LetterheadDeletionHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class LetterheadDeletionHandlerTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestDocumentFactory documentFactory;

    @Test
    public void testDelete() {
        Document document = this.documentFactory.createPNG("logo.png");
        TestLetterheadBuilder builder = this.documentFactory.newLetterhead().logo(document);
        Entity letterhead = (Entity)builder.build();
        DocumentAct act = builder.getLogo();
        LetterheadDeletionHandler handler = this.createDeletionHandler(letterhead);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)letterhead));
        Assert.assertNull((Object)this.get((IMObject)document));
        Assert.assertNull((Object)this.get((IMObject)act));
    }

    @Test
    public void testFactory() {
        IMObjectDeletionHandlerFactory factory = new IMObjectDeletionHandlerFactory(this.getArchetypeService());
        Assert.assertNotNull((Object)this.applicationContext);
        factory.setApplicationContext(this.applicationContext);
        Entity letterhead = (Entity)this.documentFactory.newLetterhead().build();
        IMObjectDeletionHandler handler = factory.create((IMObject)letterhead);
        Assert.assertTrue((boolean)(handler instanceof LetterheadDeletionHandler));
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)letterhead));
    }

    protected LetterheadDeletionHandler createDeletionHandler(Entity letterhead) {
        return new LetterheadDeletionHandler(letterhead, this.factory, ServiceHelper.getTransactionManager(), ServiceHelper.getArchetypeService());
    }
}

