/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.domain.im.lookup.LookupRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.workspace.admin.hl7.AbstractLookupMappingTest;
import org.openvpms.web.workspace.admin.hl7.LookupMapping;
import org.openvpms.web.workspace.admin.hl7.LookupMappingCSVReader;
import org.openvpms.web.workspace.admin.hl7.LookupMappingCSVWriter;
import org.openvpms.web.workspace.admin.hl7.LookupMappings;

public class LookupMappingReaderWriterTestCase
extends AbstractLookupMappingTest {
    @Test
    public void testReadWrite() {
        DocumentHandlers handlers = new DocumentHandlers((ArchetypeService)this.getArchetypeService());
        Lookup species1 = this.getSpecies("SPECIES_1", "species1");
        Lookup species2 = this.getSpecies("SPECIES_2", "species2");
        Lookup species3 = this.getSpecies("SPECIES_3", "species3");
        Lookup speciesA = this.getIDEXXSpecies("SPECIES_A", "speciesA");
        Lookup speciesB = this.getIDEXXSpecies("SPECIES_B", "speciesB");
        Lookup speciesC = this.getIDEXXSpecies("SPECIES_C", "speciesC");
        IMObjectBean bean = this.getBean((IMObject)species2);
        LookupRelationship relationship = (LookupRelationship)bean.addTarget("mapping", (IMObject)speciesB);
        speciesB.addLookupRelationship((org.openvpms.component.model.lookup.LookupRelationship)relationship);
        this.save((IMObject[])new Lookup[]{species2, speciesB});
        final List<Lookup> from = Arrays.asList(species1, species2, species3);
        final List<Lookup> to = Arrays.asList(speciesA, speciesB, speciesC);
        LookupMappingCSVWriter writer = new LookupMappingCSVWriter(this.getArchetypeService(), this.getLookupService(), handlers, ','){

            protected List<Lookup> getLookups(String shortName) {
                return "lookup.species".equals(shortName) ? from : to;
            }
        };
        Document document = writer.write("mapping.csv", "lookup.species", "lookup.speciesIDEXX");
        LookupMappingCSVReader reader = new LookupMappingCSVReader(handlers, ',');
        LookupMappings read = reader.read((org.openvpms.component.model.document.Document)document);
        List mappings = read.getMappings();
        List errors = read.getErrors();
        Assert.assertEquals((long)1L, (long)mappings.size());
        Assert.assertEquals((long)4L, (long)errors.size());
        this.checkMapping((LookupMapping)errors.get(0), "lookup.species", "SPECIES_1", "species1", "lookup.speciesIDEXX", null, null, 2, "A value for Map To Code is required");
        this.checkMapping((LookupMapping)mappings.get(0), "lookup.species", "SPECIES_2", "species2", "lookup.speciesIDEXX", "SPECIES_B", "speciesB", 3, null);
        this.checkMapping((LookupMapping)errors.get(1), "lookup.species", "SPECIES_3", "species3", "lookup.speciesIDEXX", null, null, 4, "A value for Map To Code is required");
        this.checkMapping((LookupMapping)errors.get(2), "lookup.species", null, null, null, null, null, 5, "A value for Map From Code is required");
        this.checkMapping((LookupMapping)errors.get(3), "lookup.species", null, null, null, null, null, 6, "A value for Map From Code is required");
    }
}

