/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import org.junit.Assert;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.lookup.LookupRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.workspace.admin.hl7.LookupMapping;

public abstract class AbstractLookupMappingTest
extends ArchetypeServiceTest {
    protected static final char SEPARATOR = ',';
    protected static final String IDEXX_SPECIES = "lookup.speciesIDEXX";

    protected void checkMapping(LookupMapping mapping, String fromType, String fromCode, String fromName, String toType, String toCode, String toName, int line, String error) {
        Assert.assertEquals((Object)fromType, (Object)mapping.getFromType());
        Assert.assertEquals((Object)fromCode, (Object)mapping.getFromCode());
        Assert.assertEquals((Object)fromName, (Object)mapping.getFromName());
        Assert.assertEquals((Object)toType, (Object)mapping.getToType());
        Assert.assertEquals((Object)toCode, (Object)mapping.getToCode());
        Assert.assertEquals((Object)toName, (Object)mapping.getToName());
        Assert.assertEquals((long)line, (long)mapping.getLine());
        Assert.assertEquals((Object)error, (Object)mapping.getError());
    }

    protected Lookup getSpecies(String code, String name) {
        Lookup species = TestHelper.getLookup((String)"lookup.species", (String)code, (String)name, (boolean)true);
        IMObjectBean bean = this.getBean((IMObject)species);
        for (LookupRelationship relationship : bean.getValues("mapping", LookupRelationship.class)) {
            species.removeLookupRelationship((org.openvpms.component.model.lookup.LookupRelationship)relationship);
            Lookup target = (Lookup)this.get((Reference)relationship.getTarget());
            target.removeLookupRelationship((org.openvpms.component.model.lookup.LookupRelationship)relationship);
            this.save((IMObject[])new Lookup[]{species, target});
        }
        return species;
    }

    protected Lookup getIDEXXSpecies(String code, String name) {
        return TestHelper.getLookup((String)IDEXX_SPECIES, (String)code, (String)name, (boolean)true);
    }
}

