/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.select;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.select.SelectedObjects;

public class SelectedObjectsTestCase {
    private final SelectedObjects<Entity> objects = new SelectedObjects();
    private final Entity a = this.createEntity("A");
    private final Entity b = this.createEntity("B");
    private final Entity c = this.createEntity("C");
    private final Entity d = this.createEntity("D");

    @Test
    public void testAdd() {
        this.objects.addObject((IMObject)this.a);
        this.checkObjects(this.a);
        Assert.assertEquals((Object)"A; ", (Object)this.objects.getText());
        this.objects.addObject((IMObject)this.b);
        this.checkObjects(this.a, this.b);
        Assert.assertEquals((Object)"A; B; ", (Object)this.objects.getText());
        this.objects.addObject((IMObject)this.c);
        this.checkObjects(this.a, this.b, this.c);
        Assert.assertEquals((Object)"A; B; C; ", (Object)this.objects.getText());
    }

    @Test
    public void testRemove() {
        this.objects.addObjects((IMObject[])new Entity[]{this.a, this.b, this.c, this.d});
        this.checkObjects(this.a, this.b, this.c, this.d);
        Assert.assertEquals((Object)"A; B; C; D; ", (Object)this.objects.getText());
        this.objects.setNames(new String[]{"A", "D"});
        this.checkObjects(this.a, this.d);
        Assert.assertEquals((Object)"A; D; ", (Object)this.objects.getText());
        this.objects.setNames(new String[]{"D"});
        this.checkObjects(this.d);
        Assert.assertEquals((Object)"D; ", (Object)this.objects.getText());
        this.objects.setNames(new String[0]);
        this.checkObjects(new Entity[0]);
        Assert.assertEquals((Object)"", (Object)this.objects.getText());
    }

    @Test
    public void testReplace() {
        this.objects.addObjects((IMObject[])new Entity[]{this.a, this.b, this.c});
        this.checkObjects(this.a, this.b, this.c);
        Assert.assertEquals((Object)"A; B; C; ", (Object)this.objects.getText());
        this.objects.parseNames("D; B; C; ");
        Assert.assertEquals((Object)"D; B; C; ", (Object)this.objects.getText());
        Assert.assertFalse((boolean)this.objects.isValid());
        Assert.assertFalse((boolean)this.objects.haveMatch(0));
        this.objects.setObject(0, (IMObject)this.d);
        Assert.assertTrue((boolean)this.objects.isValid());
        Assert.assertTrue((boolean)this.objects.haveMatch(0));
        Assert.assertEquals((Object)"D; B; C; ", (Object)this.objects.getText());
    }

    @Test
    public void testSetNames() {
        this.objects.setNames(new String[]{"A", "B", "C"});
        Assert.assertEquals((Object)"A; B; C; ", (Object)this.objects.getText());
    }

    private void checkObjects(Entity ... expected) {
        List entities = this.objects.getObjects();
        Assert.assertEquals((long)expected.length, (long)entities.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], entities.get(i));
        }
    }

    private Entity createEntity(String name) {
        org.openvpms.component.business.domain.im.common.Entity result = new org.openvpms.component.business.domain.im.common.Entity();
        result.setName(name);
        return result;
    }
}

