/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.act;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.im.act.ActHierarchyIterator;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.patient.history.PatientHistoryQuery;

public class ActHierarchyIteratorTestCase
extends AbstractAppTest {
    private static final String[] SHORT_NAMES = new String[]{"act.patientClinicalProblem", "act.patientWeight", "act.patientClinicalNote"};

    @Test
    public void testEvents() {
        Party patient = TestHelper.createPatient((boolean)true);
        this.createEvent(patient, TestHelper.getDatetime((String)"2007-02-01 10:30:00"));
        this.createEvent(patient, TestHelper.getDatetime((String)"2007-02-10 11:45:00"));
        this.createEvent(patient, TestHelper.getDatetime((String)"2007-01-10 11:45:00"));
        PatientHistoryQuery query = new PatientHistoryQuery(patient, (Preferences)Mockito.mock(Preferences.class));
        query.getComponent();
        this.checkIterator(query, -1, 3, new String[0]);
        this.checkIterator(query, -1, 6, "act.patientClinicalProblem");
        this.checkIterator(query, -1, 12, "act.patientClinicalProblem", "act.patientClinicalNote");
        this.checkIterator(query, -1, 15, "act.patientClinicalNote", "act.patientClinicalProblem", "act.patientWeight");
        this.checkIterator(query, 1, 3, new String[0]);
        this.checkIterator(query, 1, 3, "act.patientClinicalNote", "act.patientClinicalProblem", "act.patientWeight");
        this.checkIterator(query, 2, 12, "act.patientClinicalNote", "act.patientClinicalProblem", "act.patientWeight");
    }

    @Test
    public void testProblem() {
        Party patient = TestHelper.createPatient((boolean)true);
        User clinician = TestHelper.createClinician();
        Act weight = PatientTestHelper.createWeight((Date)TestHelper.getDatetime((String)"2014-05-09 10:00:00"), (Party)patient, (User)clinician);
        Act problemNote = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2014-05-09 10:04:00"), (Party)patient, (User)clinician);
        Act problem = PatientTestHelper.createProblem((Date)TestHelper.getDatetime((String)"2014-05-09 10:05:00"), (Party)patient, (User)clinician, (Act[])new Act[]{problemNote});
        Act event = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2014-05-09 10:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{weight, problemNote, problem});
        PatientHistoryQuery query = new PatientHistoryQuery(patient, (Preferences)Mockito.mock(Preferences.class));
        query.getComponent();
        this.checkIterator(query, -1, new String[0], event);
        this.checkIterator(query, -1, new String[]{"act.patientClinicalProblem", "act.patientWeight"}, event, weight, problem);
        this.checkIterator(query, -1, SHORT_NAMES, event, weight, problem, problemNote);
        this.checkIterator(query, 1, SHORT_NAMES, event);
        this.checkIterator(query, 2, SHORT_NAMES, event, weight, problemNote, problem);
        this.checkIterator(query, 3, SHORT_NAMES, event, weight, problem, problemNote);
    }

    private void checkIterator(PatientHistoryQuery query, int maxDepth, String[] shortNames, Act ... acts) {
        int index = 0;
        for (Act act : new ActHierarchyIterator((Iterable)query, shortNames, maxDepth)) {
            Assert.assertEquals((Object)acts[index++], (Object)act);
        }
        Assert.assertEquals((long)index, (long)acts.length);
    }

    private void checkIterator(PatientHistoryQuery query, int maxDepth, int expected, String ... shortNames) {
        ActHierarchyIterator summary = new ActHierarchyIterator((Iterable)query, shortNames, maxDepth);
        int acts = 0;
        Act event = null;
        for (Act act : summary) {
            if (event == null) {
                Assert.assertTrue((boolean)TypeHelper.isA((IMObject)act, (String)"act.patientClinicalEvent"));
            }
            if (TypeHelper.isA((IMObject)act, (String)"act.patientClinicalEvent")) {
                event = act;
            } else {
                Assert.assertNotNull((Object)event);
                Assert.assertTrue((boolean)TypeHelper.isA((IMObject)act, (String[])shortNames));
            }
            ++acts;
        }
        Assert.assertEquals((long)expected, (long)acts);
    }

    private Act createEvent(Party patient, Date startTime) {
        Act eventNote = PatientTestHelper.createNote((Date)startTime, (Party)patient);
        Act problemNote = PatientTestHelper.createNote((Date)startTime, (Party)patient);
        Act problem = PatientTestHelper.createProblem((Date)startTime, (Party)patient, (Act[])new Act[]{problemNote});
        Act weight = PatientTestHelper.createWeight((Date)startTime, (Party)patient, null);
        return PatientTestHelper.createEvent((Date)startTime, (Party)patient, (Act[])new Act[]{eventNote, problem, weight});
    }
}

