/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2025 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.workspace.workflow.i18n;

import org.openvpms.component.i18n.Message;
import org.openvpms.component.i18n.Messages;
import org.openvpms.component.model.party.Party;

/**
 * Workflow messages.
 *
 * @author Tim Anderson
 */
public class WorkflowMessages {

    /**
     * The messages.
     */
    private static final Messages messages = new Messages("WORKFLOW", WorkflowMessages.class.getName());

    /**
     * Returns a message indicating that the context has no practice.
     *
     * @return the message
     */
    public static Message contextHasNoPractice() {
        return messages.create(1);
    }

    /**
     * Returns a message indicating that the context has no practice.
     *
     * @return the message
     */
    public static Message contextHasNoLocation() {
        return messages.create(2);
    }

    /**
     * Returns a message indicating that the context has no customer.
     *
     * @return the message
     */
    public static Message contextHasNoCustomer() {
        return messages.create(3);
    }

    /**
     * Returns a message indicating that the context has no patient.
     *
     * @return the message
     */
    public static Message contextHasNoPatient() {
        return messages.create(4);
    }

    /**
     * Returns a message indicating that the context has no visit.
     *
     * @return the message
     */
    public static Message contextHasNoVisit() {
        return messages.create(5);
    }

    /**
     * Returns a message indicating that the location has no OTC customer.
     *
     * @param location the location
     * @return the message
     */
    public static Message locationHasNoOTCCustomer(Party location) {
        return messages.create(6, location.getName());
    }

    /**
     * Returns a message indicating that an appointment has no customer.
     *
     * @return the message
     */
    public static Message appointmentHasNoCustomer() {
        return messages.create(7);
    }

    /**
     * Returns a message indicating that an appointment has no patient.
     *
     * @return the message
     */
    public static Message appointmentHasNoPatient() {
        return messages.create(8);
    }

    /**
     * Returns a message indicating that a task has no customer.
     *
     * @return the message
     */
    public static Message taskHasNoCustomer() {
        return messages.create(9);
    }

    /**
     * Returns a message indicating that a task has no patient.
     *
     * @return the message
     */
    public static Message taskHasNoPatient() {
        return messages.create(10);
    }
}