/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import java.util.Date;
import java.util.Objects;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.workflow.TaskRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleBrowser;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleCRUDWindow;
import org.openvpms.web.workspace.workflow.scheduling.SchedulingWorkspace;
import org.openvpms.web.workspace.workflow.worklist.TaskBrowser;
import org.openvpms.web.workspace.workflow.worklist.TaskCRUDWindow;
import org.openvpms.web.workspace.workflow.worklist.TaskSchedules;

public class TaskWorkspace
extends SchedulingWorkspace {
    public TaskWorkspace(Context context, Preferences preferences) {
        super("workflow.worklist", (Archetypes<Entity>)Archetypes.create((String)"entity.organisationWorkListView", Entity.class), context, preferences, "entity.preferenceGroupWorkList");
    }

    @Override
    public void setObject(Entity object) {
        this.getContext().setWorkListView(object);
        super.setObject(object);
    }

    public boolean canUpdate(String shortName) {
        return super.canUpdate(shortName) || "act.customerTask".equals(shortName);
    }

    public void update(IMObject object) {
        if (object != null) {
            if (object.isA("entity.organisationWorkListView")) {
                if (!Objects.equals(this.getObject(), object)) {
                    this.setObject((Entity)object);
                }
            } else if (object.isA("act.customerTask")) {
                Act act = (Act)object;
                if (!Objects.equals(this.getCRUDWindow().getObject(), act)) {
                    Entity view;
                    TaskRules rules = (TaskRules)ServiceHelper.getBean(TaskRules.class);
                    Entity worklist = rules.getWorkList(act);
                    Party location = this.getContext().getLocation();
                    if (worklist != null && location != null && (view = rules.getWorkListView(location, worklist)) != null) {
                        this.setScheduleView(view, act.getActivityStartTime(), act.getStatus());
                        ScheduleBrowser scheduleBrowser = this.getBrowser();
                        scheduleBrowser.setSelected(scheduleBrowser.getEvent(act));
                        this.getCRUDWindow().setObject((IMObject)act);
                    }
                }
            }
        }
    }

    @Override
    protected void setScheduleView(Entity view, Date date) {
        this.setScheduleView(view, date, null);
    }

    protected void setScheduleView(Entity view, Date date, String status) {
        this.setScheduleView(view);
        TaskBrowser browser = (TaskBrowser)this.getBrowser();
        browser.setScheduleView(view);
        browser.setDate(date);
        browser.includeStatus(status);
        browser.query();
        this.onQuery();
    }

    @Override
    protected ScheduleBrowser createBrowser() {
        return new TaskBrowser(this.getPreferences(), this.getContext());
    }

    @Override
    protected ScheduleCRUDWindow createCRUDWindow() {
        return new TaskCRUDWindow(this.getContext(), this.getHelpContext());
    }

    @Override
    protected void onQuery() {
        Context context = this.getContext();
        ScheduleBrowser browser = this.getBrowser();
        context.setWorkListDate(browser.getDate());
        context.setWorkList((Entity)((Party)browser.getSelectedSchedule()));
        super.onQuery();
    }

    @Override
    protected void onSaved(IMObject object, boolean isNew) {
        this.query();
        TaskBrowser browser = (TaskBrowser)this.getBrowser();
        browser.setSelected((Act)object);
        this.firePropertyChange("summary", null, null);
    }

    @Override
    protected void onRefresh(IMObject object) {
        this.query();
        TaskBrowser browser = (TaskBrowser)this.getBrowser();
        if (!browser.setSelected((Act)object)) {
            this.getCRUDWindow().setObject(null);
        }
        this.firePropertyChange("summary", null, null);
    }

    @Override
    protected void eventSelected(PropertySet event) {
        this.updateContext();
        super.eventSelected(event);
        this.getContext().setTask((Act)this.getCRUDWindow().getObject());
    }

    @Override
    protected void onEdit(PropertySet event) {
        this.updateContext();
        super.onEdit(event);
    }

    protected Entity getLatest() {
        return (Entity)this.getLatest((IMObject)this.getContext().getWorkListView());
    }

    @Override
    protected Entity getDefaultView(Party location, Preferences prefs) {
        TaskSchedules schedules = new TaskSchedules(location, prefs);
        return schedules.getDefaultScheduleView();
    }

    private void updateContext() {
        Party workList = (Party)this.getBrowser().getSelectedSchedule();
        this.getContext().setWorkList((Entity)workList);
    }
}

