/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.workspace.workflow.appointment.AbstractScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.openvpms.web.workspace.workflow.worklist.TaskSchedule;

public class TaskGrid
extends AbstractScheduleEventGrid {
    private int slots;

    public TaskGrid(Entity scheduleView, Date date, Map<Entity, ScheduleEvents> tasks, AppointmentRules rules) {
        super(scheduleView, date, rules);
        ArrayList<Schedule> schedules = new ArrayList<Schedule>();
        for (Map.Entry<Entity, ScheduleEvents> entry : tasks.entrySet()) {
            Entity workList = entry.getKey();
            List sets = entry.getValue().getEvents();
            TaskSchedule schedule = new TaskSchedule(workList, rules);
            for (PropertySet set : sets) {
                schedule.addEvent(set);
            }
            schedules.add(schedule);
            int events = schedule.getSlots() + 1;
            if (this.slots < events) {
                this.slots = events <= schedule.getMaxSlots() ? events : schedule.getMaxSlots();
                continue;
            }
            if (this.slots != 0) continue;
            this.slots = schedule.getSlots();
        }
        this.setSchedules(schedules);
    }

    @Override
    public int getSlots() {
        return this.slots;
    }

    @Override
    public PropertySet getEvent(Schedule schedule, int slot) {
        List<PropertySet> events = schedule.getEvents();
        return events.size() > slot ? events.get(slot) : null;
    }

    @Override
    public Date getStartTime(Schedule schedule, int slot) {
        PropertySet event = this.getEvent(schedule, slot);
        return event != null ? event.getDate("act.startTime") : null;
    }

    @Override
    public Date getEndTime(Schedule schedule, int slot) {
        PropertySet event = this.getEvent(schedule, slot);
        return event != null ? event.getDate("act.endTime") : null;
    }

    @Override
    public ScheduleEventGrid.Availability getAvailability(Schedule schedule, int slot) {
        TaskSchedule s = (TaskSchedule)schedule;
        if (slot < s.getSlots()) {
            return ScheduleEventGrid.Availability.BUSY;
        }
        if (slot < s.getMaxSlots()) {
            return ScheduleEventGrid.Availability.FREE;
        }
        return ScheduleEventGrid.Availability.UNAVAILABLE;
    }

    @Override
    public int getUnavailableSlots(Schedule schedule, int slot) {
        TaskSchedule s = (TaskSchedule)schedule;
        if (slot >= s.getMaxSlots()) {
            return 0;
        }
        return this.getSlots() - slot;
    }

    @Override
    public int getSlot(Date time) {
        return -1;
    }

    @Override
    public int getSlotSize() {
        return 0;
    }
}

