/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskListener;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.LocalClinicianContext;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleCRUDWindow;
import org.openvpms.web.workspace.workflow.worklist.TaskActEditor;
import org.openvpms.web.workspace.workflow.worklist.TransferWorkflow;

public class TaskCRUDWindow
extends ScheduleCRUDWindow {
    private static final String TRANSFER_ID = "button.transfer";
    private static final String COMPLETED_ID = "button.complete";

    public TaskCRUDWindow(Context context, HelpContext help) {
        super((Archetypes<Act>)Archetypes.create((String)"act.customerTask", Act.class), TaskActions.INSTANCE, context, help);
    }

    public void setObject(Act object) {
        super.setObject((IMObject)object);
        this.getContext().setTask(object);
    }

    public void create() {
        if (this.getContext().getWorkList() != null) {
            super.create();
        }
    }

    @Override
    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createConsultButton());
        buttons.add(this.createCheckOutButton());
        buttons.add(TRANSFER_ID, this.action("act.customerTask", this::transferTask, act -> this.getActions().canCheckoutOrConsult((Act)act), "workflow.worklist.transfer.title"));
        buttons.add(COMPLETED_ID, this.action("act.customerTask", this::completeTask, act -> this.getActions().canCheckoutOrConsult((Act)act), "workflow.worklist.complete.title"));
        buttons.add(this.createOverTheCounterButton());
        buttons.add(this.createFlowSheetButton());
    }

    @Override
    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        Act act = (Act)this.getObject();
        boolean checkout = enable && this.getActions().canCheckoutOrConsult(act);
        boolean complete = enable && this.getActions().canComplete(act);
        buttons.setEnabled("button.consult", checkout);
        buttons.setEnabled("button.checkout", checkout);
        buttons.setEnabled(TRANSFER_ID, checkout);
        buttons.setEnabled(COMPLETED_ID, complete);
    }

    protected LayoutContext createLayoutContext(HelpContext help) {
        LocalClinicianContext local = new LocalClinicianContext(this.getContext());
        return new DefaultLayoutContext(true, (Context)local, help);
    }

    @Override
    protected TaskActions getActions() {
        return (TaskActions)super.getActions();
    }

    private void transferTask(final Act task) {
        HelpContext help = this.getHelpContext().subtopic("transfer");
        TransferWorkflow transfer = new TransferWorkflow(task, this.getContext(), help);
        transfer.addTaskListener((TaskListener)new DefaultTaskListener(){

            public void taskEvent(TaskEvent event) {
                TaskCRUDWindow.this.onRefresh(task);
            }
        });
        transfer.start();
    }

    private void completeTask(Act task) {
        IMObjectBean bean = this.getBean((IMObject)task);
        String name = IMObjectHelper.getName((Reference)bean.getTargetRef("customer"));
        ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"workflow.worklist.complete.title"))).message(Messages.format((String)"workflow.worklist.complete.message", (Object[])new Object[]{name}))).yesNo()).yes(() -> {
            HelpContext edit = this.createEditTopic((IMObject)task);
            LayoutContext context = this.createLayoutContext(edit);
            TaskActEditor editor = (TaskActEditor)this.createEditor((IMObject)task, context);
            editor.setStatus("COMPLETED");
            SaveHelper.save((IMObjectEditor)editor);
            this.onSaved((IMObject)task, false);
        })).show();
    }

    protected static class TaskActions
    extends ScheduleCRUDWindow.ScheduleActions {
        public static final TaskActions INSTANCE = new TaskActions();

        protected TaskActions() {
        }

        @Override
        public boolean canCheckoutOrConsult(Act act) {
            boolean result = false;
            if (this.canComplete(act)) {
                IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)act);
                result = bean.getTargetRef("patient") != null;
            }
            return result;
        }

        public boolean canComplete(Act act) {
            String status = act.getStatus();
            return "PENDING".equals(status) || "IN_PROGRESS".equals(status) || "BILLED".equals(status);
        }
    }
}

