/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import java.util.Date;
import nextapp.echo2.app.Extent;
import org.apache.commons.lang3.time.DateUtils;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.scheduling.AbstractScheduleActEditor;
import org.openvpms.web.workspace.workflow.worklist.TaskQueryHelper;
import org.openvpms.web.workspace.workflow.worklist.TaskTypeParticipationEditor;

public abstract class TaskActEditor
extends AbstractScheduleActEditor {
    protected static final String WORK_LIST = "worklist";
    protected static final String TASK_TYPE = "taskType";
    protected static final String STATUS = "status";
    protected static final String CONSULT_START_TIME = "consultStartTime";

    public TaskActEditor(Act act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
        Date date;
        if (act.isNew()) {
            this.initParticipant("customer", (IMObject)context.getContext().getCustomer());
            this.initParticipant("patient", (IMObject)context.getContext().getPatient());
        }
        if (this.getStartTime() == null && (date = context.getContext().getWorkListDate()) != null) {
            this.setStartTime(this.getDefaultStartTime(date), true);
        }
        this.addStartEndTimeListeners();
        this.getProperty(STATUS).addModifiableListener(modifiable -> this.onStatusChanged());
    }

    public void setWorkList(Entity workList) {
        this.setParticipant(WORK_LIST, workList);
        TaskTypeParticipationEditor editor = this.getTaskTypeEditor();
        if (editor != null) {
            editor.setWorkList(workList);
        }
    }

    public Entity getWorkList() {
        return this.getParticipant(WORK_LIST);
    }

    public void setTaskType(Entity taskType) {
        this.setParticipant(TASK_TYPE, taskType);
    }

    public Entity getTaskType() {
        return this.getParticipant(TASK_TYPE);
    }

    public User getClinician() {
        return (User)this.getParticipant("clinician");
    }

    protected boolean doValidation(Validator validator) {
        boolean result = super.doValidation(validator);
        if (result) {
            result = this.checkMaxSlots();
        }
        return result;
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new LayoutStrategy();
    }

    @Override
    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        Party workList = (Party)this.getParticipant(WORK_LIST);
        TaskTypeParticipationEditor editor = this.getTaskTypeEditor();
        if (editor != null) {
            editor.setWorkList((Entity)workList);
        }
    }

    protected TaskTypeParticipationEditor getTaskTypeEditor() {
        return (TaskTypeParticipationEditor)this.getParticipationEditor(TASK_TYPE, true);
    }

    protected void onStatusChanged() {
        Property status = this.getProperty(STATUS);
        Date time = null;
        String value = (String)status.getValue();
        if ("COMPLETED".equals(value) || "CANCELLED".equals(value)) {
            time = new Date();
        }
        this.setEndTime(time, false);
        if ("IN_PROGRESS".equals(value)) {
            this.getProperty(CONSULT_START_TIME).setValue((Object)new Date());
        }
    }

    protected Date getDefaultStartTime(Date date) {
        date = DateRules.isToday((Date)date) ? DateUtils.truncate((Date)new Date(), (int)12) : DateRules.getDate((Date)date);
        return date;
    }

    private boolean checkMaxSlots() {
        boolean result;
        Act act = this.getObject();
        if (TaskQueryHelper.tooManyTasks(act)) {
            String title = Messages.get((String)"workflow.worklist.toomanytasks.title");
            String message = Messages.get((String)"workflow.worklist.toomanytasks.message");
            ErrorDialog.show((String)title, (String)message);
            result = false;
        } else {
            result = true;
        }
        return result;
    }

    protected class LayoutStrategy
    extends AbstractLayoutStrategy {
        public LayoutStrategy() {
            this.addComponent(new ComponentState((PropertyEditor)TaskActEditor.this.getStartTimeEditor()));
            this.addComponent(new ComponentState((PropertyEditor)TaskActEditor.this.getEndTimeEditor()));
        }

        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            Property notes = properties.get("notes");
            if (notes != null) {
                this.addComponent(this.createMultiLineText(notes, 2, 5, new Extent(50, 128), context));
            }
            return super.apply(object, properties, parent, context);
        }
    }
}

