/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.EntityObjectSetQuery;
import org.openvpms.web.component.im.query.EntityObjectSetResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectHelper;

public class ScheduleWorkListQuery
extends EntityObjectSetQuery {
    private final Entity schedule;
    private final Entity location;
    private static final String[] SHORT_NAMES = new String[]{"party.organisationWorkList"};

    public ScheduleWorkListQuery(Entity schedule, Entity location) {
        super(SHORT_NAMES);
        this.schedule = schedule;
        this.location = location;
        this.setAuto(true);
        this.setDistinct(true);
    }

    protected ResultSet<ObjectSet> createResultSet(SortConstraint[] sort) {
        return new EntityObjectSetResultSet(this.getArchetypeConstraint(), this.getValue(), this.isIdentitySearch(), sort, this.getMaxResults(), this.isDistinct()){

            protected ArchetypeQuery createQuery() {
                IMObjectBean bean;
                ArchetypeQuery query = super.createQuery();
                boolean useAllWorkLists = true;
                if (ScheduleWorkListQuery.this.schedule != null && !(useAllWorkLists = (bean = IMObjectHelper.getBean((IMObject)ScheduleWorkListQuery.this.schedule)).getBoolean("useAllWorkLists", true))) {
                    query.add((IConstraint)Constraints.exists((ArchetypeQuery)Constraints.subQuery((String)"party.organisationSchedule", (String)"schedule").add((IConstraint)Constraints.eq((String)"id", (Object)ScheduleWorkListQuery.this.schedule.getId())).add((IConstraint)Constraints.join((String)"workLists", (String)"w").add((IConstraint)Constraints.idEq((String)"entity", (String)"w.target")))));
                }
                if (useAllWorkLists && ScheduleWorkListQuery.this.location != null) {
                    query.add((IConstraint)Constraints.exists((ArchetypeQuery)Constraints.subQuery((String)"party.organisationLocation", (String)"location").add((IConstraint)Constraints.eq((String)"id", (Object)ScheduleWorkListQuery.this.location.getId())).add((IConstraint)Constraints.join((String)"workListViews").add((IConstraint)Constraints.join((String)"target", (String)"workListView").add((IConstraint)Constraints.join((String)"workListView.workLists", (String)"w").add((IConstraint)Constraints.idEq((String)"entity", (String)"w.target")))))));
                }
                return query;
            }
        };
    }
}

